/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.OidListListener;

public class ObjectRemovedEvent
extends NamedEvent {
    protected int _oid;
    protected transient boolean _alreadyApplied;

    public ObjectRemovedEvent(int targetOid, String name, int oid) {
        super(targetOid, name);
        this._oid = oid;
    }

    public int getOid() {
        return this._oid;
    }

    public boolean alreadyApplied() {
        return this._alreadyApplied;
    }

    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this._alreadyApplied) {
            OidList list = (OidList)target.getAttribute(this._name);
            list.remove(this._oid);
        }
        return true;
    }

    protected void notifyListener(Object listener) {
        if (listener instanceof OidListListener) {
            ((OidListListener)listener).objectRemoved(this);
        }
    }

    protected void toString(StringBuilder buf) {
        buf.append("OBJREM:");
        super.toString(buf);
        buf.append(", oid=").append(this._oid);
    }

    protected ObjectRemovedEvent setAlreadyApplied(boolean alreadyApplied) {
        this._alreadyApplied = alreadyApplied;
        return this;
    }
}

