/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.google.common.collect.Maps;
import com.samskivert.util.MethodFinder;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.ElementUpdateListener;
import com.threerings.presents.dobj.ElementUpdatedEvent;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicListener<T extends DSet.Entry>
implements AttributeChangeListener,
ElementUpdateListener,
SetListener<T> {
    protected Object _target;
    protected MethodFinder _finder;
    protected HashMap<String, Method> _mcache = Maps.newHashMap();

    public DynamicListener(Object target) {
        this(target, new MethodFinder(target.getClass()));
    }

    public DynamicListener(Object target, MethodFinder finder) {
        this._target = target;
        this._finder = finder;
    }

    @Override
    public void attributeChanged(AttributeChangedEvent event) {
        this.dispatchMethod(event.getName() + "Changed", new Object[]{event.getValue()});
    }

    @Override
    public void elementUpdated(ElementUpdatedEvent event) {
        this.dispatchMethod(event.getName() + "Updated", new Object[]{event.getIndex(), event.getValue()});
    }

    @Override
    public void entryAdded(EntryAddedEvent<T> event) {
        this.dispatchMethod(event.getName() + "Added", new Object[]{event.getEntry()});
    }

    @Override
    public void entryUpdated(EntryUpdatedEvent<T> event) {
        this.dispatchMethod(event.getName() + "Updated", new Object[]{event.getEntry()});
    }

    @Override
    public void entryRemoved(EntryRemovedEvent<T> event) {
        this.dispatchMethod(event.getName() + "Removed", new Object[]{event.getKey()});
    }

    public void dispatchMethod(String name, Object[] arguments) {
        Method method = this._mcache.get(name);
        if (method == null && !this._mcache.containsKey(name)) {
            method = this.resolveMethod(name, arguments);
            this._mcache.put(name, method);
        }
        if (method != null) {
            try {
                method.invoke(this._target, arguments);
            }
            catch (Exception e) {
                Log.log.warning((Object)("Failed to dispatch event callback " + name + "(" + StringUtil.toString((Object)arguments) + ")."), new Object[]{e});
            }
        }
    }

    protected Method resolveMethod(String name, Object[] arguments) {
        Class[] ptypes = new Class[arguments.length];
        for (int ii = 0; ii < arguments.length; ++ii) {
            ptypes[ii] = arguments[ii] == null ? null : arguments[ii].getClass();
        }
        try {
            return this._finder.findMethod(name, ptypes);
        }
        catch (Exception e) {
            return null;
        }
    }
}

