/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.samskivert.util.StringUtil;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import java.lang.reflect.Array;

public class AttributeChangedEvent
extends NamedEvent {
    protected Object _value;
    protected transient Object _oldValue = UNSET_OLD_VALUE;

    public AttributeChangedEvent(int targetOid, String name, Object value) {
        super(targetOid, name);
        this._value = value;
    }

    public Object getValue() {
        return this._value;
    }

    public Object getOldValue() {
        return this._oldValue;
    }

    public byte getByteValue() {
        return (Byte)this._value;
    }

    public short getShortValue() {
        return (Short)this._value;
    }

    public int getIntValue() {
        return (Integer)this._value;
    }

    public long getLongValue() {
        return (Long)this._value;
    }

    public float getFloatValue() {
        return ((Float)this._value).floatValue();
    }

    public double getDoubleValue() {
        return (Double)this._value;
    }

    public boolean alreadyApplied() {
        return this._oldValue != UNSET_OLD_VALUE;
    }

    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this.alreadyApplied()) {
            Class<?> vclass;
            this._oldValue = target.getAttribute(this._name);
            Object value = this._value;
            if (value != null && !(vclass = value.getClass()).isPrimitive()) {
                if (vclass.isArray()) {
                    int length = Array.getLength(value);
                    Object clone = Array.newInstance(vclass.getComponentType(), length);
                    System.arraycopy(value, 0, clone, 0, length);
                    value = clone;
                } else if (DSet.class.isAssignableFrom(vclass)) {
                    value = ((DSet)value).clone();
                }
            }
            target.setAttribute(this._name, value);
        }
        return true;
    }

    protected void notifyListener(Object listener) {
        if (listener instanceof AttributeChangeListener) {
            ((AttributeChangeListener)listener).attributeChanged(this);
        }
    }

    protected void toString(StringBuilder buf) {
        buf.append("CHANGE:");
        super.toString(buf);
        buf.append(", value=");
        StringUtil.toString((StringBuilder)buf, (Object)this._value);
    }

    protected AttributeChangedEvent setOldValue(Object oldValue) {
        this._oldValue = oldValue;
        return this;
    }
}

