/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.data;

import com.threerings.presents.client.InvocationReceiver;
import com.threerings.presents.data.InvocationCodes;
import com.threerings.presents.data.Permission;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.util.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientObject
extends DObject {
    public static final String USERNAME = "username";
    public static final String RECEIVERS = "receivers";
    public static final String CLOBJ_CHANGED = "!clobj_changed!";
    public Name username;
    public DSet<InvocationReceiver.Registration> receivers = DSet.newDSet();
    protected transient PermissionPolicy _permPolicy;
    protected transient int _references;

    public String who() {
        return "(" + this.username + ":" + this.getOid() + ")";
    }

    public String checkAccess(Permission perm, Object context) {
        if (this._permPolicy == null) {
            this._permPolicy = this.createPermissionPolicy();
        }
        return this._permPolicy.checkAccess(perm, context);
    }

    public String checkAccess(Permission perm) {
        return this.checkAccess(perm, null);
    }

    public boolean hasAccess(Permission perm, Object context) {
        return this.checkAccess(perm, context) == null;
    }

    public boolean hasAccess(Permission perm) {
        return this.checkAccess(perm) == null;
    }

    public synchronized void reference() {
        ++this._references;
    }

    public synchronized boolean release() {
        return --this._references > 0;
    }

    public void setUsername(Name value) {
        Name ovalue = this.username;
        this.requestAttributeChange(USERNAME, value, ovalue);
        this.username = value;
    }

    public void addToReceivers(InvocationReceiver.Registration elem) {
        this.requestEntryAdd(RECEIVERS, this.receivers, elem);
    }

    public void removeFromReceivers(Comparable<?> key) {
        this.requestEntryRemove(RECEIVERS, this.receivers, key);
    }

    public void updateReceivers(InvocationReceiver.Registration elem) {
        this.requestEntryUpdate(RECEIVERS, this.receivers, elem);
    }

    public void setReceivers(DSet<InvocationReceiver.Registration> value) {
        Object clone;
        this.requestAttributeChange(RECEIVERS, value, this.receivers);
        this.receivers = clone = value == null ? null : value.clone();
    }

    protected PermissionPolicy createPermissionPolicy() {
        return new PermissionPolicy();
    }

    protected class PermissionPolicy
    implements InvocationCodes {
        protected PermissionPolicy() {
        }

        public String checkAccess(Permission perm, Object context) {
            return "m.access_denied";
        }
    }
}

