/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.nio.conman;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.samskivert.net.AddressUtil;
import com.samskivert.util.Lifecycle;
import com.threerings.NaryaLog;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.nio.conman.NetEventHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.List;

public class ServerSocketChannelAcceptor
implements Lifecycle.ShutdownComponent {
    protected final int[] _ports;
    protected final String _bindHostname;
    protected final ConnectionManager _conMan;
    protected List<ServerSocketChannel> _ssockets = Lists.newArrayList();

    public ServerSocketChannelAcceptor(String socketHostname, int[] socketPorts, ConnectionManager mgr) {
        Preconditions.checkNotNull((Object)socketPorts, (Object)"Socket ports must be non-null.");
        this._bindHostname = socketHostname;
        this._ports = socketPorts;
        this._conMan = mgr;
    }

    public boolean bind() {
        int successes = 0;
        for (int port : this._ports) {
            try {
                this.acceptConnections(port);
                ++successes;
            }
            catch (IOException ioe) {
                NaryaLog.log.warning((Object)"Failure listening to socket", new Object[]{"hostname", this._bindHostname, "port", port, ioe});
            }
        }
        return successes > 0;
    }

    public void shutdown() {
        for (ServerSocketChannel ssocket : this._ssockets) {
            try {
                ssocket.socket().close();
            }
            catch (IOException ioe) {
                NaryaLog.log.warning((Object)("Failed to close listening socket: " + ssocket), new Object[]{ioe});
            }
        }
    }

    protected void acceptConnections(int port) throws IOException {
        final ServerSocketChannel ssocket = ServerSocketChannel.open();
        ssocket.configureBlocking(false);
        InetSocketAddress isa = AddressUtil.getAddress((String)this._bindHostname, (int)port);
        ssocket.socket().bind(isa);
        this._conMan.register(ssocket, 16, new NetEventHandler(){

            public int handleEvent(long when) {
                try {
                    ServerSocketChannelAcceptor.this._conMan.handleAcceptedSocket(ssocket.accept());
                }
                catch (IOException ioe) {
                    NaryaLog.log.info((Object)("Failure accepting connected socket: " + ioe), new Object[0]);
                }
                return 0;
            }

            public boolean checkIdle(long idleStamp) {
                return false;
            }

            public void becameIdle() {
            }
        });
        this._ssockets.add(ssocket);
        NaryaLog.log.info((Object)("Server listening on " + isa + "."), new Object[0]);
    }
}

