/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    protected ByteBuffer _buffer = ByteBuffer.allocate(32);
    protected static final int INITIAL_BUFFER_SIZE = 32;

    public ByteBuffer getBuffer() {
        return this._buffer;
    }

    public ByteBuffer flip() {
        this._buffer.flip();
        return this._buffer;
    }

    public void reset() {
        this._buffer.clear();
    }

    public void write(int b) {
        try {
            this._buffer.put((byte)b);
        }
        catch (BufferOverflowException boe) {
            this.expand(1);
            this._buffer.put((byte)b);
        }
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            this._buffer.put(b, off, len);
        }
        catch (BufferOverflowException boe) {
            this.expand(len);
            this._buffer.put(b, off, len);
        }
    }

    protected final void expand(int needed) {
        int ocapacity = this._buffer.capacity();
        int ncapacity = this._buffer.position() + needed;
        if (ncapacity > ocapacity) {
            ncapacity = Math.max(ocapacity << 1, ncapacity);
            ByteBuffer newbuf = ByteBuffer.allocate(ncapacity);
            newbuf.put((ByteBuffer)this._buffer.flip());
            this._buffer = newbuf;
        }
    }
}

