/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.Interval;
import com.samskivert.util.MethodFinder;
import com.samskivert.util.StringUtil;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.data.SpeakMarshaller;
import com.threerings.crowd.chat.server.SpeakHandler;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.Place;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.CrowdObjectAccess;
import com.threerings.crowd.server.OccupantOp;
import com.threerings.crowd.server.PlaceManagerDelegate;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.AccessController;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DynamicListener;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.MessageListener;
import com.threerings.presents.dobj.NamedSetAdapter;
import com.threerings.presents.dobj.ObjectAddedEvent;
import com.threerings.presents.dobj.ObjectDeathListener;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.ObjectRemovedEvent;
import com.threerings.presents.dobj.OidListListener;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.dobj.SetAdapter;
import com.threerings.presents.server.InvocationDispatcher;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceManager
implements MessageListener,
SpeakHandler.SpeakerValidator {
    protected SetAdapter<OccupantInfo> _bodyUpdater = new NamedSetAdapter<OccupantInfo>("occupantInfo"){

        @Override
        public void namedEntryUpdated(EntryUpdatedEvent<OccupantInfo> event) {
            PlaceManager.this.bodyUpdated(event.getEntry());
        }
    };
    protected OidListListener _occListener = new OidListListener(){

        public void objectAdded(ObjectAddedEvent event) {
            if (event.getName().equals("occupants")) {
                PlaceManager.this.bodyEntered(event.getOid());
            }
        }

        public void objectRemoved(ObjectRemovedEvent event) {
            if (event.getName().equals("occupants")) {
                PlaceManager.this.bodyLeft(event.getOid());
            }
        }
    };
    protected ObjectDeathListener _deathListener = new ObjectDeathListener(){

        public void objectDestroyed(ObjectDestroyedEvent event) {
            PlaceManager.this._registry.unmapPlaceManager(PlaceManager.this);
            try {
                PlaceManager.this.didShutdown();
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Manager choked in didShutdown()", new Object[]{"where", PlaceManager.this.where(), t});
            }
        }
    };
    @Inject
    protected Injector _injector;
    protected PlaceRegistry _registry;
    protected InvocationManager _invmgr;
    protected RootDObjectManager _omgr;
    protected BodyLocator _locator;
    protected PlaceObject _plobj;
    protected PlaceConfig _config;
    protected Map<String, MessageHandler> _msghandlers;
    protected List<PlaceManagerDelegate> _delegates;
    protected List<InvocationMarshaller> _marshallers = Lists.newArrayList();
    protected HashIntMap<OccupantInfo> _occInfo = new HashIntMap();
    protected Interval _shutdownInterval;
    protected DynamicListener<?> _dispatcher;
    protected static Map<Class<?>, MethodFinder> _dispatcherFinders = Maps.newHashMap();

    public PlaceConfig getConfig() {
        return this._config;
    }

    public Place getLocation() {
        return new Place(this._plobj.getOid());
    }

    public PlaceObject getPlaceObject() {
        return this._plobj;
    }

    public void applyToOccupants(OccupantOp op) {
        if (this._plobj != null) {
            for (OccupantInfo info : this._plobj.occupantInfo) {
                op.apply(info);
            }
        }
    }

    public <T extends OccupantInfo> boolean updateOccupantInfo(int bodyOid, OccupantInfo.Updater<T> updater) {
        OccupantInfo info = (OccupantInfo)this._occInfo.get(bodyOid);
        if (info == null || !updater.update(info)) {
            return false;
        }
        this._occInfo.put(info.getBodyOid(), (Object)info);
        this._plobj.updateOccupantInfo(info.clone());
        return true;
    }

    public void init(PlaceRegistry registry, InvocationManager invmgr, RootDObjectManager omgr, BodyLocator locator, PlaceConfig config) {
        this._registry = registry;
        this._invmgr = invmgr;
        this._omgr = omgr;
        this._locator = locator;
        this._config = config;
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.init(PlaceManager.this, PlaceManager.this._omgr, PlaceManager.this._invmgr);
            }
        });
        try {
            this.didInit();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Manager choked in didInit()", new Object[]{"where", this.where(), t});
        }
    }

    public void addDelegate(PlaceManagerDelegate delegate) {
        if (this._delegates == null) {
            this._delegates = Lists.newArrayList();
        }
        if (this._omgr != null) {
            delegate.init(this, this._omgr, this._invmgr);
            delegate.didInit(this._config);
        }
        this._delegates.add(delegate);
    }

    public void applyToDelegates(DelegateOp op) {
        if (this._delegates != null) {
            int ll = this._delegates.size();
            for (int ii = 0; ii < ll; ++ii) {
                PlaceManagerDelegate delegate = this._delegates.get(ii);
                if (!op.shouldApply(delegate)) continue;
                op.apply(delegate);
            }
        }
    }

    public String checkPermissions() {
        return null;
    }

    public void startup(PlaceObject plobj) {
        this._plobj = plobj;
        if (this.shouldCreateSpeakService()) {
            plobj.setSpeakService(this.addProvider(this.createSpeakHandler(plobj), SpeakMarshaller.class));
        }
        plobj.addListener(this);
        plobj.addListener(this._bodyUpdater);
        plobj.addListener(this._occListener);
        plobj.addListener(this._deathListener);
        plobj.setAccessController(this.getAccessController());
        try {
            this.didStartup();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Manager choked in didStartup()", new Object[]{"where", this.where(), t});
        }
        this.checkShutdownInterval();
    }

    public void shutdown() {
        this._omgr.destroyObject(this._plobj.getOid());
        this.cancelShutdowner();
    }

    public String ratifyBodyEntry(BodyObject body) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bodyWillEnter(BodyObject body) {
        OccupantInfo info = body.createOccupantInfo(this._plobj);
        this._occInfo.put(info.getBodyOid(), (Object)info);
        this._plobj.startTransaction();
        try {
            this.addOccupantInfo(body, info.clone());
        }
        finally {
            this._plobj.commitTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bodyWillLeave(BodyObject body) {
        this._plobj.startTransaction();
        try {
            this._plobj.removeFromOccupantInfo(Integer.valueOf(body.getOid()));
            this._plobj.removeFromOccupants(body.getOid());
        }
        finally {
            this._plobj.commitTransaction();
        }
    }

    @Deprecated
    public void registerMessageHandler(String name, MessageHandler handler) {
        if (this._msghandlers == null) {
            this._msghandlers = Maps.newHashMap();
        }
        this._msghandlers.put(name, handler);
    }

    @Override
    public void messageReceived(MessageEvent event) {
        MessageHandler handler;
        if (this._msghandlers != null && (handler = this._msghandlers.get(event.getName())) != null) {
            handler.handleEvent(event, this);
        }
        if (event.isPrivate()) {
            Object[] nargs;
            int srcoid = event.getSourceOid();
            DObject source = srcoid <= 0 ? null : this._omgr.getObject(srcoid);
            Object[] args = event.getArgs();
            if (args == null) {
                nargs = new Object[]{source};
            } else {
                nargs = new Object[args.length + 1];
                nargs[0] = source;
                System.arraycopy(args, 0, nargs, 1, args.length);
            }
            if (this._dispatcher == null) {
                Class<?> clazz = this.getClass();
                MethodFinder finder = _dispatcherFinders.get(clazz);
                if (finder == null) {
                    finder = new MethodFinder(clazz);
                    _dispatcherFinders.put(clazz, finder);
                }
                this._dispatcher = new DynamicListener(this, finder);
            }
            this._dispatcher.dispatchMethod(event.getName(), nargs);
        }
    }

    @Override
    public boolean isValidSpeaker(DObject speakObj, ClientObject speaker, byte mode) {
        switch (mode) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
        }
        return this._plobj.occupants.contains(speaker.getOid());
    }

    public String where() {
        return this._plobj == null ? StringUtil.shortClassName((Object)this) + ":-1" : this._plobj.which();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        this.toString(buf);
        buf.append("]");
        return buf.toString();
    }

    protected PlaceObject createPlaceObject() {
        try {
            return this.getPlaceObjectClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected Class<? extends PlaceObject> getPlaceObjectClass() {
        return PlaceObject.class;
    }

    protected void didInit() {
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.didInit(PlaceManager.this._config);
            }
        });
    }

    protected void permissionsFailed() {
    }

    protected boolean shouldCreateSpeakService() {
        return true;
    }

    protected AccessController getAccessController() {
        return (AccessController)this._injector.getInstance(CrowdObjectAccess.PlaceAccessController.class);
    }

    protected void didStartup() {
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.didStartup(PlaceManager.this._plobj);
            }
        });
    }

    protected void didShutdown() {
        this._plobj.removeListener(this);
        this._plobj.removeListener(this._bodyUpdater);
        this._plobj.removeListener(this._occListener);
        this._plobj.removeListener(this._deathListener);
        for (InvocationMarshaller marsh : this._marshallers) {
            this._invmgr.clearDispatcher(marsh);
        }
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.didShutdown();
            }
        });
        this.cancelShutdowner();
    }

    protected <T extends InvocationMarshaller> T addProvider(InvocationProvider prov, Class<T> mclass) {
        T marsh = this._invmgr.registerProvider(prov, mclass);
        this._marshallers.add((InvocationMarshaller)marsh);
        return marsh;
    }

    protected <T extends InvocationMarshaller> T addDispatcher(InvocationDispatcher<T> disp) {
        T marsh = this._invmgr.registerDispatcher(disp);
        this._marshallers.add((InvocationMarshaller)marsh);
        return marsh;
    }

    protected void bodyEntered(final int bodyOid) {
        Log.log.debug((Object)"Body entered", new Object[]{"where", this.where(), "oid", bodyOid});
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.bodyEntered(bodyOid);
            }
        });
        this.cancelShutdowner();
    }

    protected void bodyLeft(final int bodyOid) {
        Log.log.debug((Object)"Body left", new Object[]{"where", this.where(), "oid", bodyOid});
        Integer key = bodyOid;
        if (this._plobj.occupantInfo.containsKey(key)) {
            this._plobj.removeFromOccupantInfo(key);
        }
        OccupantInfo leaver = (OccupantInfo)this._occInfo.remove(bodyOid);
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.bodyLeft(bodyOid);
            }
        });
        if (this.shouldDeclareEmpty(leaver)) {
            this.placeBecameEmpty();
        }
    }

    protected void addOccupantInfo(BodyObject body, OccupantInfo info) {
        this._plobj.addToOccupantInfo(info);
        this._plobj.addToOccupants(body.getOid());
    }

    protected boolean shouldDeclareEmpty(OccupantInfo leaver) {
        return this._plobj.occupants.size() == 0;
    }

    protected void bodyUpdated(final OccupantInfo info) {
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.bodyUpdated(info);
            }
        });
    }

    protected void placeBecameEmpty() {
        this.applyToDelegates(new DelegateOp(PlaceManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                delegate.placeBecameEmpty();
            }
        });
        this.checkShutdownInterval();
    }

    protected void checkShutdownInterval() {
        long idlePeriod = this.idleUnloadPeriod();
        if (idlePeriod > 0L && this._shutdownInterval == null) {
            this._shutdownInterval = this._omgr.newInterval(new Runnable(){

                public void run() {
                    Log.log.debug((Object)("Unloading idle place '" + PlaceManager.this.where() + "'."), new Object[0]);
                    PlaceManager.this.shutdown();
                }
            });
            this._shutdownInterval.schedule(idlePeriod);
        }
    }

    protected void cancelShutdowner() {
        if (this._shutdownInterval != null) {
            this._shutdownInterval.cancel();
            this._shutdownInterval = null;
        }
    }

    protected long idleUnloadPeriod() {
        return 300000L;
    }

    protected void toString(StringBuilder buf) {
        buf.append("place=").append(this._plobj);
        buf.append(", config=").append(this._config);
    }

    protected SpeakHandler createSpeakHandler(PlaceObject plobj) {
        return new SpeakHandler(this._locator, plobj, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DelegateOp {
        protected Class<? extends PlaceManagerDelegate> _delegateClass;

        public DelegateOp(Class<? extends PlaceManagerDelegate> delegateClass) {
            this._delegateClass = delegateClass;
        }

        public abstract void apply(PlaceManagerDelegate var1);

        public boolean shouldApply(PlaceManagerDelegate delegate) {
            return this._delegateClass.isInstance(delegate);
        }
    }

    @Deprecated
    public static interface MessageHandler {
        public void handleEvent(MessageEvent var1, PlaceManager var2);
    }
}

