/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.client;

import com.samskivert.util.BasicRunQueue;
import com.samskivert.util.Config;
import com.samskivert.util.RunQueue;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.client.OccupantDirector;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.MessageManager;
import com.threerings.util.Name;

public class TestClient
implements ClientObserver {
    protected Client _client;
    protected CrowdContext _ctx;
    protected LocationDirector _locdir;
    protected OccupantDirector _occdir;
    protected MessageManager _msgmgr;
    protected ChatDirector _chatdir;
    protected BasicRunQueue _rqueue = new BasicRunQueue();

    public TestClient(String username) {
        this._ctx = this.createContext();
        this._client = new Client(new UsernamePasswordCreds(new Name(username), "test"), (RunQueue)this._rqueue);
        this._locdir = new LocationDirector(this._ctx);
        this._occdir = new OccupantDirector(this._ctx);
        this._msgmgr = new MessageManager("rsrc");
        this._chatdir = new ChatDirector(this._ctx, "global");
        this._client.addClientObserver(this);
        this._client.setServer("localhost", Client.DEFAULT_SERVER_PORTS);
    }

    public void run() {
        this._client.logon();
        this._rqueue.run();
    }

    public void clientWillLogon(Client client) {
    }

    public void clientDidLogon(Client client) {
        Log.log.info((Object)("Client did logon [client=" + client + "]."), new Object[0]);
        this._ctx.getLocationDirector().moveTo(15);
    }

    public void clientObjectDidChange(Client client) {
        Log.log.info((Object)("Client object did change [client=" + client + "]."), new Object[0]);
    }

    public void clientFailedToLogon(Client client, Exception cause) {
        Log.log.info((Object)("Client failed to logon [client=" + client + ", cause=" + cause + "]."), new Object[0]);
    }

    public void clientConnectionFailed(Client client, Exception cause) {
        Log.log.info((Object)("Client connection failed [client=" + client + ", cause=" + cause + "]."), new Object[0]);
    }

    public boolean clientWillLogoff(Client client) {
        Log.log.info((Object)("Client will logoff [client=" + client + "]."), new Object[0]);
        return true;
    }

    public void clientDidLogoff(Client client) {
        Log.log.info((Object)("Client did logoff [client=" + client + "]."), new Object[0]);
        System.exit(0);
    }

    public void clientDidClear(Client client) {
    }

    protected CrowdContext createContext() {
        return new CrowdContextImpl();
    }

    public static void main(String[] args) {
        TestClient tclient = new TestClient("test");
        tclient.run();
    }

    protected class CrowdContextImpl
    implements CrowdContext {
        protected CrowdContextImpl() {
        }

        public Config getConfig() {
            return null;
        }

        public Client getClient() {
            return TestClient.this._client;
        }

        public DObjectManager getDObjectManager() {
            return TestClient.this._client.getDObjectManager();
        }

        public LocationDirector getLocationDirector() {
            return TestClient.this._locdir;
        }

        public OccupantDirector getOccupantDirector() {
            return TestClient.this._occdir;
        }

        public ChatDirector getChatDirector() {
            return TestClient.this._chatdir;
        }

        public MessageManager getMessageManager() {
            return TestClient.this._msgmgr;
        }

        public void setPlaceView(PlaceView view) {
        }

        public void clearPlaceView(PlaceView view) {
        }
    }
}

