/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.server;

import com.threerings.crowd.Log;
import com.threerings.crowd.chat.data.ChatCodes;
import com.threerings.crowd.chat.server.SpeakProvider;
import com.threerings.crowd.chat.server.SpeakUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;

public class SpeakHandler
implements SpeakProvider {
    protected BodyLocator _locator;
    protected DObject _speakObj;
    protected SpeakerValidator _validator;

    public SpeakHandler(DObject speakObj, SpeakerValidator validator) {
        this(null, speakObj, validator);
    }

    public SpeakHandler(BodyLocator locator, DObject speakObj, SpeakerValidator validator) {
        this._locator = locator;
        this._speakObj = speakObj;
        this._validator = validator;
    }

    public void speak(ClientObject caller, String message, byte mode) {
        BodyObject source = this._locator != null ? this._locator.forClient(caller) : (BodyObject)caller;
        String errmsg = source.checkAccess(ChatCodes.CHAT_ACCESS, null);
        if (errmsg != null) {
            SpeakUtil.sendFeedback(source, "global", errmsg);
            return;
        }
        if (mode == 4 || this._validator != null && !this._validator.isValidSpeaker(this._speakObj, source, mode)) {
            Log.log.warning((Object)"Refusing invalid speak request", new Object[]{"source", source.who(), "speakObj", this._speakObj.which(), "message", message, "mode", mode});
        } else {
            SpeakUtil.sendSpeak(this._speakObj, source.getVisibleName(), null, message, mode);
        }
    }

    public static interface SpeakerValidator {
        public boolean isValidSpeaker(DObject var1, ClientObject var2, byte var3);
    }
}

