/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.StringUtil;
import com.threerings.crowd.chat.client.ChatService;
import com.threerings.crowd.chat.data.ChatCodes;
import com.threerings.crowd.chat.data.ChatMarshaller;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.server.SpeakUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.BodyLocal;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import com.threerings.util.TimeUtil;
import java.util.Iterator;

@Singleton
public class ChatProvider
implements InvocationProvider {
    @Inject
    protected PlaceRegistry _plreg;
    @Inject
    protected BodyLocator _locator;
    protected TellAutoResponder _autoRespond;
    protected ChatForwarder _chatForwarder;
    protected DObject _broadcastObject;

    @Inject
    public ChatProvider(InvocationManager invmgr) {
        invmgr.registerProvider(this, ChatMarshaller.class, "crowd");
    }

    public void setAlternateBroadcastObject(DObject object) {
        this._broadcastObject = object;
    }

    public void setTellAutoResponder(TellAutoResponder autoRespond) {
        this._autoRespond = autoRespond;
    }

    public void setChatForwarder(ChatForwarder forwarder) {
        this._chatForwarder = forwarder;
    }

    public void tell(ClientObject caller, Name target, String message, ChatService.TellListener listener) throws InvocationException {
        BodyObject targobj;
        BodyObject source = this._locator.forClient(caller);
        InvocationException.requireAccess(source, ChatCodes.CHAT_ACCESS);
        this.deliverTell(this.createTellMessage(source, message), target, listener);
        if (this._autoRespond != null && (targobj = this._locator.lookupBody(target)) != null) {
            this._autoRespond.sentTell(source, targobj, message);
        }
    }

    public void broadcast(ClientObject caller, String message, InvocationService.InvocationListener listener) throws InvocationException {
        BodyObject body = this._locator.forClient(caller);
        InvocationException.requireAccess(body, ChatCodes.BROADCAST_ACCESS);
        this.broadcast(body.getVisibleName(), null, message, false, true);
    }

    public void away(ClientObject caller, String message) {
        BodyObject body = this._locator.forClient(caller);
        body.setAwayMessage(message);
    }

    public void broadcast(Name from, String bundle, String msg, boolean attention, boolean forward) {
        byte levelOrMode = from != null ? (byte)4 : (attention ? (byte)2 : 0);
        this.broadcast(from, levelOrMode, bundle, msg, forward);
    }

    public void broadcast(Name from, byte levelOrMode, String bundle, String msg, boolean forward) {
        if (this._broadcastObject != null) {
            this.broadcastTo(this._broadcastObject, from, levelOrMode, bundle, msg);
        } else {
            Iterator<PlaceObject> iter = this._plreg.enumeratePlaces();
            while (iter.hasNext()) {
                PlaceObject plobj = iter.next();
                if (!plobj.shouldBroadcast()) continue;
                this.broadcastTo(plobj, from, levelOrMode, bundle, msg);
            }
        }
        if (forward && this._chatForwarder != null) {
            this._chatForwarder.forwardBroadcast(from, levelOrMode, bundle, msg);
        }
    }

    public void deliverTell(UserMessage message, Name target, ChatService.TellListener listener) throws InvocationException {
        BodyObject tobj = this._locator.lookupBody(target);
        if (tobj == null) {
            if (this._chatForwarder != null && this._chatForwarder.forwardTell(message, target, listener)) {
                return;
            }
            throw new InvocationException("m.user_not_online");
        }
        if (tobj.status == 2) {
            String errmsg = MessageBundle.compose("m.user_disconnected", (Object)TimeUtil.getTimeOrderString(System.currentTimeMillis() - tobj.getLocal(BodyLocal.class).statusTime, (byte)1));
            throw new InvocationException(errmsg);
        }
        this.deliverTell(tobj, message);
        long idle = 0L;
        if (tobj.status == 1) {
            idle = System.currentTimeMillis() - tobj.getLocal(BodyLocal.class).statusTime;
        }
        String awayMessage = null;
        if (!StringUtil.isBlank((String)tobj.awayMessage)) {
            awayMessage = tobj.awayMessage;
        }
        listener.tellSucceeded(idle, awayMessage);
    }

    public void deliverTell(BodyObject target, UserMessage message) {
        SpeakUtil.sendMessage(target, message);
        SpeakUtil.noteMessage(message.speaker, message);
    }

    protected UserMessage createTellMessage(BodyObject source, String message) {
        return UserMessage.create(source.getVisibleName(), message);
    }

    protected void broadcastTo(DObject object, Name from, byte levelOrMode, String bundle, String msg) {
        if (from == null) {
            SpeakUtil.sendSystem(object, bundle, msg, levelOrMode);
        } else {
            SpeakUtil.sendSpeak(object, from, bundle, msg, levelOrMode);
        }
    }

    public static interface ChatForwarder {
        public boolean forwardTell(UserMessage var1, Name var2, ChatService.TellListener var3);

        public void forwardBroadcast(Name var1, byte var2, String var3, String var4);
    }

    public static interface TellAutoResponder {
        public void sentTell(BodyObject var1, BodyObject var2, String var3);
    }
}

