/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.client;

import com.samskivert.util.RandomUtil;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.client.ChatFilter;
import com.threerings.util.Name;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CurseFilter
implements ChatFilter {
    protected Matcher _stopMatcher;
    protected Matcher[] _matchers;
    protected int[] _comicLength;
    protected String[] _replacements;
    protected String[] _vernacular;
    protected static final String[] COMIC_CHARS = new String[]{"!", "@", "#", "%", "&", "*"};

    public CurseFilter(String curseWords, String stopWords) {
        this.configureCurseWords(curseWords);
        this.configureStopWords(stopWords);
    }

    public abstract Mode getFilterMode();

    public String filter(String msg, Name otherUser, boolean outgoing) {
        this._stopMatcher.reset(msg);
        if (this._stopMatcher.find()) {
            return null;
        }
        Mode level = this.getFilterMode();
        if (level == Mode.UNFILTERED) {
            return msg;
        }
        StringBuffer inbuf = new StringBuffer(msg);
        StringBuffer outbuf = new StringBuffer(msg.length());
        int nn = this._matchers.length;
        for (int ii = 0; ii < nn; ++ii) {
            Matcher m = this._matchers[ii];
            m.reset(inbuf);
            while (m.find()) {
                switch (level) {
                    case DROP: {
                        return null;
                    }
                    case COMIC: {
                        m.appendReplacement(outbuf, this._replacements[ii].replace(" ", this.comicChars(this._comicLength[ii])));
                        break;
                    }
                    case VERNACULAR: {
                        String vernacular = this._vernacular[ii];
                        if (Character.isUpperCase(m.group(2).codePointAt(0))) {
                            int firstCharLen = Character.charCount(vernacular.codePointAt(0));
                            vernacular = vernacular.substring(0, firstCharLen).toUpperCase() + vernacular.substring(firstCharLen);
                        }
                        m.appendReplacement(outbuf, this._replacements[ii].replace(" ", vernacular));
                        break;
                    }
                    case UNFILTERED: {
                        Log.log.warning((Object)"Omg? We're trying to filter chat even though we're unfiltered?", new Object[0]);
                    }
                }
            }
            if (outbuf.length() == 0) continue;
            m.appendTail(outbuf);
            StringBuffer temp = inbuf;
            inbuf = outbuf;
            outbuf = temp;
            outbuf.setLength(0);
        }
        return inbuf.toString();
    }

    protected void configureCurseWords(String curseWords) {
        StringTokenizer st = new StringTokenizer(curseWords);
        int numWords = st.countTokens();
        this._matchers = new Matcher[numWords];
        this._replacements = new String[numWords];
        this._vernacular = new String[numWords];
        this._comicLength = new int[numWords];
        for (int ii = 0; ii < numWords; ++ii) {
            String mapping = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(mapping, "=");
            if (st2.countTokens() != 2) {
                Log.log.warning((Object)("Something looks wrong in the x.cursewords properties (" + mapping + "), skipping."), new Object[0]);
                continue;
            }
            String curse = st2.nextToken();
            String s = "";
            String p = "";
            if (curse.startsWith("*")) {
                curse = curse.substring(1);
                p = p + "([\\p{L}\\p{Digit}]*)";
                s = s + "$1";
            } else {
                p = p + "()";
            }
            s = s + " ";
            p = p + " ";
            if (curse.endsWith("*")) {
                curse = curse.substring(0, curse.length() - 1);
                p = p + "([\\p{L}\\p{Digit}]*)";
                s = s + "$3";
            }
            String pattern = "\\b" + p.replace(" ", "(" + curse + ")") + "\\b";
            Pattern pat = Pattern.compile(pattern, 66);
            this._matchers[ii] = pat.matcher("");
            this._replacements[ii] = s;
            this._vernacular[ii] = st2.nextToken().replace('_', ' ');
            this._comicLength[ii] = curse.codePointCount(0, curse.length());
        }
    }

    protected void configureStopWords(String stopWords) {
        StringTokenizer st = new StringTokenizer(stopWords);
        String pattern = "";
        while (st.hasMoreTokens()) {
            pattern = "".equals(pattern) ? pattern + "(" : pattern + "|";
            pattern = pattern + this.getStopWordRegexp(st.nextToken());
        }
        pattern = pattern + ")";
        this.setStopPattern(pattern);
    }

    protected void setStopPattern(String pattern) {
        this._stopMatcher = Pattern.compile(pattern, 2).matcher("");
    }

    protected String getStopWordRegexp(String word) {
        return "\\b" + word.replace("*", "[A-Za-z]*") + "\\b";
    }

    protected String comicChars(int length) {
        StringBuilder buf = new StringBuilder();
        for (int ii = 0; ii < length; ++ii) {
            buf.append((String)RandomUtil.pickRandom((Object[])COMIC_CHARS));
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        DROP,
        COMIC,
        VERNACULAR,
        UNFILTERED;

    }
}

