/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.web.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.inject.Inject;
import com.threerings.admin.Log;
import com.threerings.admin.server.ConfigRegistry;
import com.threerings.admin.web.gwt.ConfigField;
import com.threerings.admin.web.gwt.ConfigService;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.web.gwt.ServiceException;
import com.threerings.web.server.ServletWaiter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class ConfigServlet
extends RemoteServiceServlet
implements ConfigService {
    @Inject
    protected ConfigRegistry _confReg;
    @Inject
    protected RootDObjectManager _omgr;
    protected static Map<Class<?>, ConfigField.FieldType> TYPES = ImmutableMap.builder().put(Integer.class, (Object)ConfigField.FieldType.INTEGER).put(Integer.TYPE, (Object)ConfigField.FieldType.INTEGER).put(Short.class, (Object)ConfigField.FieldType.SHORT).put(Short.TYPE, (Object)ConfigField.FieldType.SHORT).put(Long.class, (Object)ConfigField.FieldType.LONG).put(Long.TYPE, (Object)ConfigField.FieldType.LONG).put(Float.class, (Object)ConfigField.FieldType.FLOAT).put(Float.TYPE, (Object)ConfigField.FieldType.FLOAT).put(Double.class, (Object)ConfigField.FieldType.DOUBLE).put(Double.TYPE, (Object)ConfigField.FieldType.DOUBLE).put(Boolean.class, (Object)ConfigField.FieldType.BOOLEAN).put(Boolean.TYPE, (Object)ConfigField.FieldType.BOOLEAN).put(String.class, (Object)ConfigField.FieldType.STRING).build();

    public ConfigService.ConfigurationResult getConfiguration() throws ServiceException {
        this.requireAdminUser();
        final ServletWaiter waiter = new ServletWaiter("getConfiguration");
        this._omgr.postRunnable(new Runnable(){

            public void run() {
                HashMap tabs = Maps.newHashMap();
                for (String key : ConfigServlet.this._confReg.getKeys()) {
                    ConfigService.ConfigurationRecord record = ConfigServlet.this.buildRecord(key);
                    if (record == null) {
                        waiter.requestFailed(new ServiceException("e.internal_error"));
                        return;
                    }
                    tabs.put(key, record);
                }
                ConfigService.ConfigurationResult result = new ConfigService.ConfigurationResult();
                result.records = tabs;
                waiter.requestCompleted(result);
            }
        });
        return (ConfigService.ConfigurationResult)waiter.waitForResult();
    }

    public ConfigService.ConfigurationRecord updateConfiguration(final String key, final ConfigField[] updates) throws ServiceException {
        this.requireAdminUser();
        final ServletWaiter waiter = new ServletWaiter("updateConfiguration");
        this._omgr.postRunnable(new Runnable(){

            public void run() {
                DObject object = ConfigServlet.this._confReg.getObject(key);
                object.startTransaction();
                int updateCount = 0;
                for (ConfigField update : updates) {
                    object.changeAttribute(update.name, update.type.toValue(update.valStr));
                    ++updateCount;
                }
                object.commitTransaction();
                ConfigService.ConfigurationRecord record = ConfigServlet.this.buildRecord(key);
                record.updates = updateCount;
                waiter.requestCompleted(record);
            }
        });
        return (ConfigService.ConfigurationRecord)waiter.waitForResult();
    }

    protected ConfigService.ConfigurationRecord buildRecord(String key) {
        Field[] fields;
        DObject object = this._confReg.getObject(key);
        ArrayList configFields = Lists.newArrayList();
        for (Field field : fields = object.getClass().getFields()) {
            if (field.getModifiers() != 1) continue;
            ConfigField.FieldType type = TYPES.get(field.getType());
            if (type == null) {
                Log.log.warning((Object)"Unknown field type", new Object[]{"field", field.getName(), "type", field.getType()});
                return null;
            }
            try {
                Object value = field.get(object);
                String valStr = type.toString(value);
                configFields.add(new ConfigField(field.getName(), type, valStr));
            }
            catch (IllegalAccessException e) {
                Log.log.warning((Object)"Failure reflecting on configuration object", new Object[]{"key", key, "object", object, "field", field, e});
                return null;
            }
        }
        ConfigService.ConfigurationRecord record = new ConfigService.ConfigurationRecord();
        record.fields = (ConfigField[])Iterables.toArray((Iterable)configFields, ConfigField.class);
        return record;
    }

    protected abstract void requireAdminUser() throws ServiceException;
}

