/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.google.common.base.Objects;
import com.threerings.admin.Log;
import com.threerings.admin.client.FieldEditor;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.util.PresentsContext;
import java.lang.reflect.Field;
import javax.swing.JComboBox;

public class PulldownFieldEditor
extends FieldEditor {
    protected JComboBox _value = new JComboBox();

    public PulldownFieldEditor(PresentsContext ctx, Field field, DObject obj) {
        super(ctx, field, obj);
        this.add(this._value);
    }

    public void addChoice(Choice choice) {
        this._value.addItem(choice);
    }

    public void addChoice(Object choice) {
        String name = choice == null ? "null" : choice.toString();
        this.addChoice(new Choice(name, choice));
    }

    public void addNotify() {
        super.addNotify();
        this._value.addActionListener(this);
    }

    public void removeNotify() {
        this._value.removeActionListener(this);
        super.removeNotify();
    }

    protected Object getDisplayValue() throws Exception {
        Object obj = this._value.getSelectedItem();
        if (obj == null) {
            return null;
        }
        return ((Choice)obj).value;
    }

    protected void displayValue(Object value) {
        for (int ii = this._value.getItemCount() - 1; ii >= 0; --ii) {
            Choice choice = (Choice)this._value.getItemAt(ii);
            if (!Objects.equal((Object)value, (Object)choice.value)) continue;
            this._value.setSelectedIndex(ii);
            return;
        }
        Log.log.warning((Object)"Value in dobj is not settable, disabling choice.", new Object[]{new Exception()});
        this._value.setEnabled(false);
    }

    public static class Choice {
        public Object value;
        protected String _name;

        public Choice(String displayName, Object val) {
            if (displayName == null) {
                throw new NullPointerException("displayName cannot be null.");
            }
            this._name = displayName;
            this.value = val;
        }

        public String toString() {
            return this._name;
        }
    }
}

