/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.samskivert.util.StringUtil;
import com.threerings.admin.Log;
import com.threerings.admin.client.FieldEditor;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.util.PresentsContext;
import java.lang.reflect.Field;
import javax.swing.JTextField;

public class AsStringFieldEditor
extends FieldEditor {
    protected JTextField _value = new JTextField();

    public AsStringFieldEditor(PresentsContext ctx, Field field, DObject object) {
        super(ctx, field, object);
        this.add(this._value);
        this._value.addActionListener(this);
        this._value.addFocusListener(this);
    }

    protected Object getDisplayValue() throws Exception {
        String text = this._value.getText();
        if (this._field.getType().equals(Integer.class) || this._field.getType().equals(Integer.TYPE)) {
            return new Integer(text);
        }
        if (this._field.getType().equals(Short.class) || this._field.getType().equals(Short.TYPE)) {
            return new Short(text);
        }
        if (this._field.getType().equals(Byte.class) || this._field.getType().equals(Byte.TYPE)) {
            return new Byte(text);
        }
        if (this._field.getType().equals(Long.class) || this._field.getType().equals(Long.TYPE)) {
            return new Long(text);
        }
        if (this._field.getType().equals(Float.class) || this._field.getType().equals(Float.TYPE)) {
            return new Float(text);
        }
        if (this._field.getType().equals(Double.class) || this._field.getType().equals(Double.TYPE)) {
            return new Double(text);
        }
        if (this._field.getType().equals(String.class)) {
            return text;
        }
        if (this._field.getType().equals(String[].class)) {
            return StringUtil.parseStringArray((String)this._value.getText());
        }
        if (this._field.getType().equals(int[].class)) {
            return StringUtil.parseIntArray((String)this._value.getText());
        }
        if (this._field.getType().equals(float[].class)) {
            return StringUtil.parseFloatArray((String)this._value.getText());
        }
        if (this._field.getType().equals(long[].class)) {
            return StringUtil.parseLongArray((String)this._value.getText());
        }
        if (this._field.getType().equals(Boolean.TYPE)) {
            return new Boolean(this._value.getText().equalsIgnoreCase("true"));
        }
        Log.log.warning((Object)("Unknown field type '" + this._field.getName() + "': " + this._field.getType().getName() + "."), new Object[0]);
        return null;
    }

    protected void displayValue(Object value) {
        this._value.setText(StringUtil.toString((Object)value, (String)"", (String)""));
    }

    protected boolean valueMatches(Object dvalue) {
        return StringUtil.toString((Object)dvalue).equals(StringUtil.toString((Object)this.getValue()));
    }
}

