/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.util;

import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileOperation {
    public static final boolean fileExists(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static final boolean deleteFile(String filePath) {
        if (filePath == null) {
            return true;
        }
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static final boolean deleteFile(File file) {
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static boolean isLegalFile(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isFile() && file.length() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSizes(File f) {
        if (f == null) {
            return 0L;
        }
        long size = 0L;
        if (f.exists() && f.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                size = fis.available();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return size;
    }

    public static final boolean deleteDir(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileOperation.deleteDir(files[i]);
            }
        }
        file.delete();
        return true;
    }

    public static void cleanDir(File dir) {
        if (dir.exists()) {
            FileOperation.deleteDir(dir);
            dir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResourceUsingStream(String name, File dest) throws IOException {
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        InputStream is = null;
        try {
            int length;
            is = FileOperation.class.getResourceAsStream("/" + name);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static boolean checkDirectory(String dir) {
        File dirObj = new File(dir);
        FileOperation.deleteDir(dirObj);
        if (!dirObj.exists()) {
            dirObj.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unZipAPk(String fileName, String filePath) throws IOException {
        FileOperation.checkDirectory(filePath);
        ZipFile zipFile = new ZipFile(fileName);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        try {
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.isDirectory()) {
                    new File(filePath, entry.getName()).mkdirs();
                    continue;
                }
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                File file = new File(filePath + File.separator + entry.getName());
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                FileOutputStream fos = null;
                BufferedOutputStream bos = null;
                try {
                    int len;
                    fos = new FileOutputStream(file);
                    bos = new BufferedOutputStream(fos, 16384);
                    byte[] buf = new byte[16384];
                    while ((len = bis.read(buf, 0, 16384)) != -1) {
                        fos.write(buf, 0, len);
                    }
                }
                finally {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                    if (bis == null) continue;
                    bis.close();
                }
            }
            return;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static void zipFiles(Collection<File> resFileList, File zipFile) throws IOException {
        ZipOutputStream zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 16384));
        for (File resFile : resFileList) {
            if (!resFile.exists()) continue;
            FileOperation.zipFile(resFile, zipout, "");
        }
        zipout.close();
    }

    private static void zipFile(File resFile, ZipOutputStream zipout, String rootpath) throws IOException {
        rootpath = rootpath + (rootpath.trim().length() == 0 ? "" : File.separator) + resFile.getName();
        if (resFile.isDirectory()) {
            File[] fileList;
            for (File file : fileList = resFile.listFiles()) {
                FileOperation.zipFile(file, zipout, rootpath);
            }
        } else {
            byte[] fileContents = FileOperation.readContents(resFile);
            if (rootpath.contains("\\")) {
                rootpath = rootpath.replace("\\", "/");
            }
            ZipEntry entry = new ZipEntry(rootpath);
            entry.setMethod(8);
            zipout.putNextEntry(entry);
            zipout.write(fileContents);
            zipout.flush();
            zipout.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readContents(File file) throws IOException {
        int bufferSize = 16384;
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int length;
            FileInputStream in = new FileInputStream(file);
            BufferedInputStream bIn = new BufferedInputStream(in);
            byte[] buffer = new byte[16384];
            while ((length = bIn.read(buffer, 0, 16384)) != -1) {
                byte[] bufferCopy = new byte[length];
                System.arraycopy(buffer, 0, bufferCopy, 0, length);
                output.write(bufferCopy);
            }
            bIn.close();
        }
        return output.toByteArray();
    }

    public static long getFileCrc32(File file) throws IOException {
        int cnt;
        FileInputStream inputStream = new FileInputStream(file);
        CRC32 crc = new CRC32();
        while ((cnt = ((InputStream)inputStream).read()) != -1) {
            crc.update(cnt);
        }
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZipEntryCrc(File file, String entryName) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                String string = null;
                return string;
            }
            String string = String.valueOf(entry.getCrc());
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZipEntryMd5(File file, String entryName) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                String string = null;
                return string;
            }
            String string = MD5.getMD5(zipFile.getInputStream(entry), 102400);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void zipInputDir(File inputDir, File outputFile) throws IOException {
        File[] unzipFiles = inputDir.listFiles();
        ArrayList<File> collectFiles = new ArrayList<File>();
        for (File f : unzipFiles) {
            collectFiles.add(f);
        }
        FileOperation.zipFiles(collectFiles, outputFile);
    }

    public static boolean sevenZipInputDir(File inputDir, File outputFile, Configuration config) {
        String outPath = inputDir.getAbsolutePath();
        String path = outPath + File.separator + "*";
        String cmd = config.mSevenZipPath;
        ProcessBuilder pb = new ProcessBuilder(cmd, "a", "-tzip", outputFile.getAbsolutePath(), path, "-mx9");
        try {
            Process pro = pb.start();
            InputStreamReader ir = new InputStreamReader(pro.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (input.readLine() != null) {
            }
            pro.waitFor();
            pro.destroy();
        }
        catch (IOException | InterruptedException e) {
            FileOperation.deleteFile(outputFile);
            Logger.e("7a patch file failed, you should set the zipArtifact, or set the path directly");
            return false;
        }
        return true;
    }
}

