/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.util;

import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dx.instruction.InstructionVisitor;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import java.util.Collection;

public class RefToRefAffectedClassInsnVisitor
extends InstructionVisitor {
    private static final String TAG = "RefToRefAffectedClassInsnVisitor";
    private final Dex methodOwner;
    private final ClassData.Method method;
    private final Collection<String> refAffectedClassDefs;
    private final DexPatcherLogger logger;
    public boolean isMethodReferencedToRefAffectedClass;

    RefToRefAffectedClassInsnVisitor(Dex methodOwner, ClassData.Method method, Collection<String> refAffectedClassDefs, DexPatcherLogger logger) {
        super(null);
        this.methodOwner = methodOwner;
        this.method = method;
        this.refAffectedClassDefs = refAffectedClassDefs;
        this.logger = logger;
        this.isMethodReferencedToRefAffectedClass = false;
    }

    public void visitZeroRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal) {
        this.processIndexByType(index, indexType);
    }

    public void visitOneRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a) {
        this.processIndexByType(index, indexType);
    }

    public void visitTwoRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b) {
        this.processIndexByType(index, indexType);
    }

    public void visitThreeRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c) {
        this.processIndexByType(index, indexType);
    }

    public void visitFourRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d) {
        this.processIndexByType(index, indexType);
    }

    public void visitFiveRegisterInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int b, int c, int d, int e) {
        this.processIndexByType(index, indexType);
    }

    public void visitRegisterRangeInsn(int currentAddress, int opcode, int index, int indexType, int target, long literal, int a, int registerCount) {
        this.processIndexByType(index, indexType);
    }

    private void processIndexByType(int index, int indexType) {
        MethodId methodId;
        String typeName = null;
        String refInfoInLog = null;
        switch (indexType) {
            case 2: {
                typeName = (String)this.methodOwner.typeNames().get(index);
                refInfoInLog = "init ref-changed class";
                break;
            }
            case 5: {
                FieldId fieldId = (FieldId)this.methodOwner.fieldIds().get(index);
                typeName = (String)this.methodOwner.typeNames().get(fieldId.declaringClassIndex);
                refInfoInLog = "referencing to field: " + (String)this.methodOwner.strings().get(fieldId.nameIndex);
                break;
            }
            case 4: {
                methodId = (MethodId)this.methodOwner.methodIds().get(index);
                typeName = (String)this.methodOwner.typeNames().get(methodId.declaringClassIndex);
                refInfoInLog = "invoking method: " + this.getMethodProtoTypeStr(methodId);
                break;
            }
        }
        if (typeName != null && this.refAffectedClassDefs.contains(typeName)) {
            methodId = (MethodId)this.methodOwner.methodIds().get(this.method.methodIndex);
            this.logger.i(TAG, "Method %s in class %s referenced ref-changed class %s by %s", new Object[]{this.getMethodProtoTypeStr(methodId), this.methodOwner.typeNames().get(methodId.declaringClassIndex), typeName, refInfoInLog});
            this.isMethodReferencedToRefAffectedClass = true;
        }
    }

    private String getMethodProtoTypeStr(MethodId methodId) {
        short[] paramTypeIds;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append((String)this.methodOwner.strings().get(methodId.nameIndex));
        ProtoId protoId = (ProtoId)this.methodOwner.protoIds().get(methodId.protoIndex);
        strBuilder.append('(');
        for (short typeId : paramTypeIds = this.methodOwner.parameterTypeIndicesFromMethodId(methodId)) {
            strBuilder.append((String)this.methodOwner.typeNames().get(typeId));
        }
        strBuilder.append(')').append((String)this.methodOwner.typeNames().get(protoId.returnTypeIndex));
        return strBuilder.toString();
    }
}

