/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.bsdiff.BSDiff;
import com.tencent.tinker.build.apkparser.AndroidParser;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ResDiffDecoder
extends BaseDecoder {
    private static final String TEMP_RES_ZIP = "temp_res.zip";
    private static final String TEMP_RES_7ZIP = "temp_res_7ZIP.zip";
    private final InfoWriter logWriter;
    private final InfoWriter metaWriter;
    private ArrayList<String> addedSet;
    private ArrayList<String> modifiedSet;
    private ArrayList<String> largeModifiedSet;
    private HashMap<String, LargeModeInfo> largeModifiedMap;
    private ArrayList<String> deletedSet;
    private boolean arscChanged;
    private File oldArscFile;
    private File newArscFile;

    public ResDiffDecoder(Configuration config, String metaPath, String logPath) throws IOException {
        super(config);
        this.metaWriter = metaPath != null ? new InfoWriter(config, config.mTempResultDir + File.separator + metaPath) : null;
        this.logWriter = logPath != null ? new InfoWriter(config, config.mOutFolder + File.separator + logPath) : null;
        this.addedSet = new ArrayList();
        this.modifiedSet = new ArrayList();
        this.largeModifiedSet = new ArrayList();
        this.largeModifiedMap = new HashMap();
        this.deletedSet = new ArrayList();
    }

    @Override
    public void clean() {
        this.metaWriter.close();
        this.logWriter.close();
    }

    private boolean checkLargeModFile(File file) {
        long length = file.length();
        return length > (long)(this.config.mLargeModSize * 1024);
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        if (newFile == null || !newFile.exists()) {
            String name = this.getRelativeStringByOldDir(oldFile);
            if (Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) {
                Logger.e("found delete resource: " + name + " ,but it match ignore change pattern, just ignore!");
                return false;
            }
            this.deletedSet.add(name);
            this.writeResLog(newFile, oldFile, 3);
            return true;
        }
        File outputFile = this.getOutputPath(newFile).toFile();
        if (oldFile == null || !oldFile.exists()) {
            String name = this.getRelativeString(newFile);
            if (Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) {
                Logger.e("found add resource: " + name + " ,but it match ignore change pattern, just ignore!");
                return false;
            }
            FileOperation.copyFileUsingStream(newFile, outputFile);
            this.addedSet.add(name);
            this.writeResLog(newFile, oldFile, 1);
            return true;
        }
        if (oldFile.length() == 0L && newFile.length() == 0L) {
            return false;
        }
        String newMd5 = MD5.getMD5(newFile);
        String oldMd5 = MD5.getMD5(oldFile);
        if (oldMd5 != null && oldMd5.equals(newMd5)) {
            return false;
        }
        String name = this.getRelativeString(newFile);
        if (Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) {
            Logger.d("found modify resource: " + name + ", but it match ignore change pattern, just ignore!");
            return false;
        }
        if (name.equals("AndroidManifest.xml")) {
            Logger.d("found modify resource: " + name + ", but it is AndroidManifest.xml, just ignore!");
            return false;
        }
        if (name.equals("resources.arsc")) {
            if (AndroidParser.resourceTableLogicalChange(this.config)) {
                Logger.d("found modify resource: " + name + ", but it is logically the same as original new resources.arsc, just ignore!");
                return false;
            }
            this.arscChanged = true;
            this.oldArscFile = oldFile;
            this.newArscFile = newFile;
            return true;
        }
        this.dealWithModeFile(name, newMd5, oldFile, newFile, outputFile);
        return true;
    }

    private boolean dealWithModeFile(String name, String newMd5, File oldFile, File newFile, File outputFile) throws IOException {
        if (this.checkLargeModFile(newFile)) {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            BSDiff.bsdiff((File)oldFile, (File)newFile, (File)outputFile);
            if (Utils.checkBsDiffFileSize(outputFile, newFile)) {
                LargeModeInfo largeModeInfo = new LargeModeInfo();
                largeModeInfo.path = newFile;
                largeModeInfo.crc = FileOperation.getFileCrc32(newFile);
                largeModeInfo.md5 = newMd5;
                this.largeModifiedSet.add(name);
                this.largeModifiedMap.put(name, largeModeInfo);
                this.writeResLog(newFile, oldFile, 4);
                return true;
            }
        }
        this.modifiedSet.add(name);
        FileOperation.copyFileUsingStream(newFile, outputFile);
        this.writeResLog(newFile, oldFile, 2);
        return false;
    }

    private void writeResLog(File newFile, File oldFile, int mode) throws IOException {
        if (this.logWriter != null) {
            String log = "";
            switch (mode) {
                case 1: {
                    String relative = this.getRelativeString(newFile);
                    Logger.d("Found add resource: " + relative);
                    log = "add resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
                case 2: {
                    String relative = this.getRelativeString(newFile);
                    Logger.d("Found modify resource: " + relative);
                    log = "modify resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
                case 3: {
                    String relative = this.getRelativeStringByOldDir(oldFile);
                    Logger.d("Found deleted resource: " + relative);
                    log = "deleted resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                    break;
                }
                case 4: {
                    String relative = this.getRelativeString(newFile);
                    Logger.d("Found large modify resource: " + relative + " size:" + newFile.length());
                    log = "large modify resource: " + relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newFile);
                }
            }
            this.logWriter.writeLineToInfoFile(log);
        }
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
    }

    private void modArscFileForTestResource() throws IOException {
        File tempArscFile = new File(this.config.mOutFolder + File.separator + "edited_resources.arsc");
        AndroidParser.editResourceTableString("only use for test tinker resource: a", "only use for test tinker resource: b", this.newArscFile, tempArscFile);
        this.dealWithModeFile("resources.arsc", MD5.getMD5(tempArscFile), this.oldArscFile, tempArscFile, this.getOutputPath(this.newArscFile).toFile());
        Logger.d("Edit resources.arsc file for test resource change, final path: " + tempArscFile.getAbsolutePath());
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
        if (this.addedSet.isEmpty() && this.modifiedSet.isEmpty() && this.largeModifiedSet.isEmpty() && !this.arscChanged) {
            return;
        }
        if (!this.config.mResRawPattern.contains("resources.arsc")) {
            throw new TinkerPatchException("resource must contain resources.arsc pattern");
        }
        if (!this.config.mResRawPattern.contains("AndroidManifest.xml")) {
            throw new TinkerPatchException("resource must contain AndroidManifest.xml pattern");
        }
        this.modArscFileForTestResource();
        if (this.config.mUsingGradle) {
            boolean ignoreWarning = this.config.mIgnoreWarning;
            if (this.arscChanged && !this.config.mUseApplyResource) {
                if (ignoreWarning) {
                    Logger.e("Warning:ignoreWarning is true, but resources.arsc is changed, you should use applyResourceMapping mode to build the new apk, otherwise, it may be crash at some times");
                } else {
                    Logger.e("Warning:ignoreWarning is false, but resources.arsc is changed, you should use applyResourceMapping mode to build the new apk, otherwise, it may be crash at some times");
                    throw new TinkerPatchException(String.format("ignoreWarning is false, but resources.arsc is changed, you should use applyResourceMapping mode to build the new apk, otherwise, it may be crash at some times", new Object[0]));
                }
            }
        }
        this.deletedSet.addAll(this.getDeletedResource(this.config.mTempUnzipOldDir, this.config.mTempUnzipNewDir));
        this.addedSet.remove("AndroidManifest.xml");
        this.deletedSet.remove("AndroidManifest.xml");
        this.modifiedSet.remove("AndroidManifest.xml");
        this.largeModifiedSet.remove("AndroidManifest.xml");
        this.removeIgnoreChangeFile(this.modifiedSet);
        this.removeIgnoreChangeFile(this.deletedSet);
        this.removeIgnoreChangeFile(this.addedSet);
        this.removeIgnoreChangeFile(this.largeModifiedSet);
        File tempResZip = new File(this.config.mOutFolder + File.separator + TEMP_RES_ZIP);
        File tempResFiles = this.config.mTempResultDir;
        FileOperation.zipInputDir(tempResFiles, tempResZip);
        File extractToZip = new File(this.config.mOutFolder + File.separator + "resources_out.zip");
        String resZipMd5 = Utils.genResOutputFile(extractToZip, tempResZip, this.config, this.addedSet, this.modifiedSet, this.deletedSet, this.largeModifiedSet, this.largeModifiedMap);
        Logger.e("final normal zip resource: %s, size=%d, md5=%s", extractToZip.getName(), extractToZip.length(), resZipMd5);
        this.logWriter.writeLineToInfoFile(String.format("final normal zip resource: %s, size=%d, md5=%s", extractToZip.getName(), extractToZip.length(), resZipMd5));
        FileOperation.deleteFile(tempResZip);
        File extractTo7Zip = new File(this.config.mOutFolder + File.separator + "resources_out_7z.zip");
        File tempRes7Zip = new File(this.config.mOutFolder + File.separator + TEMP_RES_7ZIP);
        if (FileOperation.sevenZipInputDir(tempResFiles, tempRes7Zip, this.config) && tempRes7Zip.exists()) {
            String res7zipMd5 = Utils.genResOutputFile(extractTo7Zip, tempRes7Zip, this.config, this.addedSet, this.modifiedSet, this.deletedSet, this.largeModifiedSet, this.largeModifiedMap);
            FileOperation.deleteFile(tempRes7Zip);
            Logger.e("final 7zip resource: %s, size=%d, md5=%s", extractTo7Zip.getName(), extractTo7Zip.length(), res7zipMd5);
            this.logWriter.writeLineToInfoFile(String.format("final 7zip resource: %s, size=%d, md5=%s", extractTo7Zip.getName(), extractTo7Zip.length(), res7zipMd5));
        }
        String arscBaseCrc = FileOperation.getZipEntryCrc(this.config.mOldApkFile, "resources.arsc");
        String arscMd5 = FileOperation.getZipEntryMd5(extractToZip, "resources.arsc");
        if (arscBaseCrc == null || arscMd5 == null) {
            throw new TinkerPatchException("can't find resources.arsc's base crc or md5");
        }
        String resourceMeta = Utils.getResourceMeta(arscBaseCrc, arscMd5);
        this.writeMetaFile(resourceMeta);
        String patternMeta = "pattern:";
        HashSet<String> patterns = new HashSet<String>(this.config.mResRawPattern);
        patterns.remove("AndroidManifest.xml");
        this.writeMetaFile(patternMeta + patterns.size());
        for (String item : patterns) {
            this.writeMetaFile(item);
        }
        this.writeMetaFile(this.largeModifiedSet, 4);
        this.writeMetaFile(this.modifiedSet, 2);
        this.writeMetaFile(this.addedSet, 1);
        this.writeMetaFile(this.deletedSet, 3);
    }

    private void removeIgnoreChangeFile(ArrayList<String> array) {
        ArrayList<String> removeList = new ArrayList<String>();
        for (String name : array) {
            if (!Utils.checkFileInPattern(this.config.mResIgnoreChangePattern, name)) continue;
            Logger.e("ignore change resource file: " + name);
            removeList.add(name);
        }
        array.removeAll(removeList);
    }

    private void writeMetaFile(String line) {
        this.metaWriter.writeLineToInfoFile(line);
    }

    private void writeMetaFile(ArrayList<String> set, int mode) {
        if (!set.isEmpty()) {
            String title = "";
            switch (mode) {
                case 1: {
                    title = "add:" + set.size();
                    break;
                }
                case 2: {
                    title = "modify:" + set.size();
                    break;
                }
                case 4: {
                    title = "large modify:" + set.size();
                    break;
                }
                case 3: {
                    title = "delete:" + set.size();
                }
            }
            this.metaWriter.writeLineToInfoFile(title);
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String name;
                String line = name = iterator.next();
                if (mode == 4) {
                    LargeModeInfo info = this.largeModifiedMap.get(name);
                    line = name + "," + info.md5 + "," + info.crc;
                }
                this.metaWriter.writeLineToInfoFile(line);
            }
        }
    }

    public ArrayList<String> getDeletedResource(File oldApkDir, File newApkDir) throws IOException {
        DeletedResVisitor deletedResVisitor = new DeletedResVisitor(this.config, newApkDir.toPath(), oldApkDir.toPath());
        Files.walkFileTree(oldApkDir.toPath(), deletedResVisitor);
        return deletedResVisitor.deletedFiles;
    }

    class DeletedResVisitor
    extends SimpleFileVisitor<Path> {
        Configuration config;
        Path newApkPath;
        Path oldApkPath;
        ArrayList<String> deletedFiles;

        DeletedResVisitor(Configuration config, Path newPath, Path oldPath) {
            this.config = config;
            this.newApkPath = newPath;
            this.oldApkPath = oldPath;
            this.deletedFiles = new ArrayList();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relativePath = this.oldApkPath.relativize(file);
            Path newPath = this.newApkPath.resolve(relativePath);
            String patternKey = relativePath.toString().replace("\\", "/");
            if (Utils.checkFileInPattern(this.config.mResFilePattern, patternKey)) {
                if (!newPath.toFile().exists()) {
                    this.deletedFiles.add(relativePath.toString());
                    ResDiffDecoder.this.writeResLog(newPath.toFile(), file.toFile(), 3);
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public class LargeModeInfo {
        public File path = null;
        public long crc;
        public String md5 = null;
    }
}

