/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.tencent.tinker.build.apkparser.AndroidParser;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.TinkerPatchException;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;

public class ManifestDecoder
extends BaseDecoder {
    public ManifestDecoder(Configuration config) throws IOException {
        super(config);
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        boolean ignoreWarning = this.config.mIgnoreWarning;
        try {
            AndroidParser oldAndroidManifest = AndroidParser.getAndroidManifest(oldFile);
            AndroidParser newAndroidManifest = AndroidParser.getAndroidManifest(newFile);
            int minSdkVersion = Integer.parseInt(oldAndroidManifest.apkMeta.getMinSdkVersion());
            if (minSdkVersion < 14 && this.config.mDexRaw) {
                if (ignoreWarning) {
                    Logger.e("Warning:ignoreWarning is true, but your old apk's minSdkVersion %d is below 14, you should set the dexMode to 'jar', otherwise, it will be crash at some times", minSdkVersion);
                } else {
                    Logger.e("Warning:ignoreWarning is false, but your old apk's minSdkVersion %d is below 14, you should set the dexMode to 'jar', otherwise, it will be crash at some times", minSdkVersion);
                    throw new TinkerPatchException(String.format("ignoreWarning is false, but your old apk's minSdkVersion %d is below 14, you should set the dexMode to 'jar', otherwise, it will be crash at some times", minSdkVersion));
                }
            }
            List<String> oldAndroidComponent = oldAndroidManifest.getComponents();
            List<String> newAndroidComponent = newAndroidManifest.getComponents();
            for (String newComponentName : newAndroidComponent) {
                boolean found = false;
                for (String oldComponentName : oldAndroidComponent) {
                    if (!newComponentName.equals(oldComponentName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (ignoreWarning) {
                    Logger.e("Warning:ignoreWarning is true, but we found a new AndroidComponent %s, it will be crash at some times", newComponentName);
                    continue;
                }
                Logger.e("Warning:ignoreWarning is false, but we found a new AndroidComponent %s, it will be crash at some times", newComponentName);
                throw new TinkerPatchException(String.format("ignoreWarning is false, but we found a new AndroidComponent %s, it will be crash at some times", newComponentName));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new TinkerPatchException("parse android manifest error!");
        }
        return false;
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
    }

    @Override
    public void onAllPatchesEnd() throws IOException, TinkerPatchException {
    }
}

