/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.decoder;

import com.google.common.io.Files;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dx.util.Hex;
import com.tencent.tinker.build.decoder.BaseDecoder;
import com.tencent.tinker.build.dexpatcher.DexPatchGenerator;
import com.tencent.tinker.build.dexpatcher.util.SmallDexClassInfoCollector;
import com.tencent.tinker.build.dexpatcher.util.SmallDexPatchGenerator;
import com.tencent.tinker.build.info.InfoWriter;
import com.tencent.tinker.build.patch.Configuration;
import com.tencent.tinker.build.util.DexClassesComparator;
import com.tencent.tinker.build.util.ExcludedClassModifiedChecker;
import com.tencent.tinker.build.util.FileOperation;
import com.tencent.tinker.build.util.Logger;
import com.tencent.tinker.build.util.MD5;
import com.tencent.tinker.build.util.TinkerPatchException;
import com.tencent.tinker.build.util.Utils;
import com.tencent.tinker.commons.dexpatcher.DexPatchApplier;
import com.tencent.tinker.commons.dexpatcher.DexPatcherLogger;
import com.tencent.tinker.commons.dexpatcher.struct.SmallPatchedDexItemFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.builder.BuilderMutableMethodImplementation;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;

public class DexDiffDecoder
extends BaseDecoder {
    private static final String TEST_DEX_NAME = "test.dex";
    private static final String PREGENERATED_PATCH_DEX_NAME = "changed_classes.dex";
    private final InfoWriter logWriter;
    private final InfoWriter metaWriter;
    private final ExcludedClassModifiedChecker excludedClassModifiedChecker;
    private final Map<String, String> addedClassDescToDexNameMap;
    private final Map<String, String> deletedClassDescToDexNameMap;
    private final List<AbstractMap.SimpleEntry<File, File>> oldAndNewDexFilePairList;
    private final Map<String, RelatedInfo> dexNameToRelatedInfoMap;
    private boolean hasDexChanged = false;
    private DexPatcherLoggerBridge dexPatcherLoggerBridge = null;

    public DexDiffDecoder(Configuration config, String metaPath, String logPath) throws IOException {
        super(config);
        this.metaWriter = metaPath != null ? new InfoWriter(config, config.mTempResultDir + File.separator + metaPath) : null;
        this.logWriter = logPath != null ? new InfoWriter(config, config.mOutFolder + File.separator + logPath) : null;
        if (this.logWriter != null) {
            this.dexPatcherLoggerBridge = new DexPatcherLoggerBridge(this.logWriter);
        }
        this.excludedClassModifiedChecker = new ExcludedClassModifiedChecker(config);
        this.addedClassDescToDexNameMap = new HashMap<String, String>();
        this.deletedClassDescToDexNameMap = new HashMap<String, String>();
        this.oldAndNewDexFilePairList = new ArrayList<AbstractMap.SimpleEntry<File, File>>();
        this.dexNameToRelatedInfoMap = new HashMap<String, RelatedInfo>();
    }

    @Override
    public void onAllPatchesStart() throws IOException, TinkerPatchException {
    }

    @Override
    public boolean patch(File oldFile, File newFile) throws IOException, TinkerPatchException {
        String oldMd5;
        Logger.d("Check for loader classes in dex: %s", oldFile == null ? this.getRelativeString(newFile) : this.getRelativeString(oldFile));
        try {
            this.excludedClassModifiedChecker.checkIfExcludedClassWasModifiedInNewDex(oldFile, newFile);
        }
        catch (IOException e) {
            throw new TinkerPatchException(e);
        }
        catch (TinkerPatchException e) {
            if (this.config.mIgnoreWarning) {
                Logger.e("Warning:ignoreWarning is true, but we found %s", e.getMessage());
            }
            Logger.e("Warning:ignoreWarning is false, but we found %s", e.getMessage());
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newFile == null || !newFile.exists() || newFile.length() == 0L) {
            return false;
        }
        File dexDiffOut = this.getOutputPath(newFile).toFile();
        String newMd5 = MD5.getMD5(newFile);
        if (oldFile == null || !oldFile.exists() || oldFile.length() == 0L) {
            this.hasDexChanged = true;
            if (!this.config.mUsePreGeneratedPatchDex) {
                this.copyNewDexAndMarkInMeta(newFile, newMd5, dexDiffOut);
                return true;
            }
        }
        if ((oldMd5 = MD5.getMD5(oldFile)) != null && !oldMd5.equals(newMd5) || oldMd5 == null && newMd5 != null) {
            this.hasDexChanged = true;
            if (oldMd5 != null) {
                this.checkAddedOrDeletedClasses(oldFile, newFile);
            }
        }
        RelatedInfo relatedInfo = new RelatedInfo();
        relatedInfo.oldMd5 = oldMd5;
        relatedInfo.newMd5 = newMd5;
        this.oldAndNewDexFilePairList.add(new AbstractMap.SimpleEntry<File, File>(oldFile, newFile));
        String dexName = oldFile != null ? oldFile.getName() : newFile.getName();
        this.dexNameToRelatedInfoMap.put(dexName, relatedInfo);
        return true;
    }

    @Override
    public void onAllPatchesEnd() throws Exception {
        if (!this.hasDexChanged) {
            Logger.d("No dexes were changed, nothing needs to be done next.");
            return;
        }
        if (this.config.mUsePreGeneratedPatchDex) {
            this.generateStubModePatchDex();
        } else {
            this.generatePatchInfoFile();
        }
    }

    private void generateStubModePatchDex() throws IOException {
        ArrayList<File> oldDexList = new ArrayList<File>();
        ArrayList<File> newDexList = new ArrayList<File>();
        for (AbstractMap.SimpleEntry<File, File> oldAndNewDexFilePair : this.oldAndNewDexFilePairList) {
            File oldDexFile = oldAndNewDexFilePair.getKey();
            File newDexFile = oldAndNewDexFilePair.getValue();
            if (oldDexFile != null) {
                oldDexList.add(oldDexFile);
            }
            if (newDexFile == null) continue;
            newDexList.add(newDexFile);
        }
        DexClassesComparator.DexGroup oldDexGroup = DexClassesComparator.DexGroup.wrap(oldDexList);
        DexClassesComparator.DexGroup newDexGroup = DexClassesComparator.DexGroup.wrap(newDexList);
        SmallDexClassInfoCollector smallDexClassInfoCollector = new SmallDexClassInfoCollector();
        smallDexClassInfoCollector.setLoaderClassPatterns(this.config.mDexLoaderPattern);
        smallDexClassInfoCollector.setLogger(this.dexPatcherLoggerBridge);
        Set<DexClassesComparator.DexClassInfo> classInfosInPatchedDex = smallDexClassInfoCollector.doCollect(oldDexGroup, newDexGroup);
        HashSet<String> classDescsInPatchedDex = new HashSet<String>();
        HashSet<Dex> newDexes = new HashSet<Dex>();
        DexBuilder dexBuilder = DexBuilder.makeDexBuilder((Opcodes)Opcodes.forApi((int)15));
        for (DexClassesComparator.DexClassInfo classInfo : classInfosInPatchedDex) {
            classDescsInPatchedDex.add(classInfo.classDesc);
            newDexes.add(classInfo.owner);
        }
        for (Dex newDex : newDexes) {
            DexBackedDexFile dexFile = new DexBackedDexFile(Opcodes.forApi((int)15), newDex.getBytes());
            for (org.jf.dexlib2.iface.ClassDef parsedClassDef : dexFile.getClasses()) {
                if (!classDescsInPatchedDex.contains(parsedClassDef.getType())) continue;
                ArrayList<BuilderField> builderFields = new ArrayList<BuilderField>();
                for (Field parsedField : parsedClassDef.getFields()) {
                    BuilderField builderField = dexBuilder.internField(parsedField.getDefiningClass(), parsedField.getName(), parsedField.getType(), parsedField.getAccessFlags(), parsedField.getInitialValue(), parsedField.getAnnotations());
                    builderFields.add(builderField);
                }
                ArrayList<BuilderMethod> builderMethods = new ArrayList<BuilderMethod>();
                for (Method parsedMethod : parsedClassDef.getMethods()) {
                    BuilderMethod builderMethod = dexBuilder.internMethod(parsedMethod.getDefiningClass(), parsedMethod.getName(), parsedMethod.getParameters(), parsedMethod.getReturnType(), parsedMethod.getAccessFlags(), parsedMethod.getAnnotations(), (MethodImplementation)new BuilderMutableMethodImplementation(dexBuilder, parsedMethod.getImplementation()));
                    builderMethods.add(builderMethod);
                }
                dexBuilder.internClassDef(parsedClassDef.getType(), parsedClassDef.getAccessFlags(), parsedClassDef.getSuperclass(), parsedClassDef.getInterfaces(), parsedClassDef.getSourceFile(), parsedClassDef.getAnnotations(), builderFields, builderMethods);
            }
        }
        String dexMode = this.config.mDexRaw ? "raw" : "jar";
        File dest = new File(this.config.mTempResultDir + "/" + PREGENERATED_PATCH_DEX_NAME);
        FileDataStore fileDataStore = new FileDataStore(dest);
        dexBuilder.writeTo((DexDataStore)fileDataStore);
        File tempPreGeneratedPatchDexPath = new File(this.config.mOutFolder + File.separator + "tempPatchedDexes" + File.separator + "pre-generated");
        this.ensureDirectoryExist(tempPreGeneratedPatchDexPath);
        Files.copy((File)dest, (File)new File(tempPreGeneratedPatchDexPath, PREGENERATED_PATCH_DEX_NAME));
        String md5 = MD5.getMD5(dest);
        String meta = "changed_classes.dex,," + md5 + "," + md5 + "," + 0 + "," + 0 + "," + dexMode;
        Logger.d("\nPre-generated patch dex: %s, size:%d", dest.getAbsolutePath(), dest.length());
        Logger.d("DexDecoder:write pre-generated patch dex meta file data: %s", meta);
        this.metaWriter.writeLineToInfoFile(meta);
        this.addTestDex();
    }

    private void generatePatchInfoFile() throws IOException {
        String dexName;
        File tempFullPatchDexPath = new File(this.config.mOutFolder + File.separator + "tempPatchedDexes" + File.separator + "full");
        this.ensureDirectoryExist(tempFullPatchDexPath);
        File tempSmallPatchDexPath = new File(this.config.mOutFolder + File.separator + "tempPatchedDexes" + File.separator + "small");
        this.ensureDirectoryExist(tempSmallPatchDexPath);
        for (AbstractMap.SimpleEntry<File, File> simpleEntry : this.oldAndNewDexFilePairList) {
            File file = simpleEntry.getKey();
            File newFile = simpleEntry.getValue();
            dexName = file.getName();
            RelatedInfo relatedInfo = this.dexNameToRelatedInfoMap.get(dexName);
            if (!relatedInfo.oldMd5.equals(relatedInfo.newMd5)) {
                File dexDiffOut = this.getOutputPath(newFile).toFile();
                this.ensureDirectoryExist(dexDiffOut.getParentFile());
                try {
                    DexPatchGenerator dexPatchGen = new DexPatchGenerator(file, newFile);
                    dexPatchGen.setAdditionalRemovingClassPatterns(this.config.mDexLoaderPattern);
                    this.logWriter.writeLineToInfoFile(String.format("Start diff between [%s] as old and [%s] as new:", this.getRelativeStringBy(file, this.config.mTempUnzipOldDir), this.getRelativeStringBy(newFile, this.config.mTempUnzipNewDir)));
                    dexPatchGen.executeAndSaveTo(dexDiffOut);
                }
                catch (Exception e) {
                    throw new TinkerPatchException(e);
                }
                if (!dexDiffOut.exists()) {
                    throw new TinkerPatchException("can not find the diff file:" + dexDiffOut.getAbsolutePath());
                }
                relatedInfo.dexDiffFile = dexDiffOut;
                relatedInfo.dexDiffMd5 = MD5.getMD5(dexDiffOut);
                Logger.d("\nGen %s patch file:%s, size:%d, md5:%s", dexName, relatedInfo.dexDiffFile.getAbsolutePath(), relatedInfo.dexDiffFile.length(), relatedInfo.dexDiffMd5);
                File tempFullPatchedDexFile = new File(tempFullPatchDexPath, dexName);
                try {
                    new DexPatchApplier(file, dexDiffOut).executeAndSaveTo(tempFullPatchedDexFile);
                    Logger.d(String.format("Verifying if patched new dex is logically the same as original new dex: %s ...", this.getRelativeStringBy(newFile, this.config.mTempUnzipNewDir)));
                    Dex origNewDex = new Dex(newFile);
                    Dex patchedNewDex = new Dex(tempFullPatchedDexFile);
                    this.checkDexChange(origNewDex, patchedNewDex);
                    relatedInfo.newOrFullPatchedFile = tempFullPatchedDexFile;
                    relatedInfo.newOrFullPatchedMd5 = MD5.getMD5(tempFullPatchedDexFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new TinkerPatchException("Failed to generate temporary patched dex, which makes MD5 generating procedure of new dex failed, either.", e);
                }
                if (!tempFullPatchedDexFile.exists()) {
                    throw new TinkerPatchException("can not find the temporary full patched dex file:" + tempFullPatchedDexFile.getAbsolutePath());
                }
                Logger.d("\nGen %s for dalvik full dex file:%s, size:%d, md5:%s", dexName, tempFullPatchedDexFile.getAbsolutePath(), tempFullPatchedDexFile.length(), relatedInfo.newOrFullPatchedMd5);
                continue;
            }
            relatedInfo.newOrFullPatchedFile = newFile;
            relatedInfo.newOrFullPatchedMd5 = relatedInfo.newMd5;
        }
        HashSet<File> classNOldDexFiles = new HashSet<File>();
        for (AbstractMap.SimpleEntry<File, File> simpleEntry : this.oldAndNewDexFilePairList) {
            File oldFile = simpleEntry.getKey();
            dexName = oldFile.getName();
            if (!this.isDexNameMatchesClassNPattern(dexName)) continue;
            classNOldDexFiles.add(oldFile);
        }
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (File classNOldDex : classNOldDexFiles) {
            hashMap.put(classNOldDex.getName(), classNOldDex);
        }
        boolean bl = false;
        for (int i = 0; i < classNOldDexFiles.size(); ++i) {
            boolean bl2;
            String expectedDexName;
            String string = expectedDexName = i == 0 ? "classes.dex" : "classes" + (i + 1) + ".dex";
            if (!hashMap.containsKey(expectedDexName)) {
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            File mistakenClassNOldDexFile = (File)hashMap.get(expectedDexName);
            classNOldDexFiles.remove(mistakenClassNOldDexFile);
        }
        File tempSmallPatchInfoFile = new File(this.config.mTempResultDir, "smallpatch_info.ddextra");
        this.ensureDirectoryExist(tempSmallPatchInfoFile.getParentFile());
        SmallDexPatchGenerator smallDexPatchGenerator = new SmallDexPatchGenerator();
        smallDexPatchGenerator.setLoaderClassPatterns(this.config.mDexLoaderPattern);
        smallDexPatchGenerator.setLogger(this.dexPatcherLoggerBridge);
        this.logWriter.writeLineToInfoFile("\nStart collecting old dex and full patched dex...");
        ArrayList<File> classNOldDexFileList = new ArrayList<File>();
        ArrayList<File> classNFullPatchedDexFileList = new ArrayList<File>();
        ArrayList<File> otherOldDexFileList = new ArrayList<File>();
        ArrayList<File> otherFullPatchedDexFileList = new ArrayList<File>();
        for (AbstractMap.SimpleEntry<File, File> simpleEntry : this.oldAndNewDexFilePairList) {
            File file = simpleEntry.getKey();
            String dexName2 = file.getName();
            File fullPatchedFile = this.dexNameToRelatedInfoMap.get((Object)dexName2).newOrFullPatchedFile;
            if (classNOldDexFiles.contains(file)) {
                classNOldDexFileList.add(file);
                classNFullPatchedDexFileList.add(fullPatchedFile);
                continue;
            }
            otherOldDexFileList.add(file);
            otherFullPatchedDexFileList.add(fullPatchedFile);
        }
        this.logWriter.writeLineToInfoFile(String.format("\nCollected class N old dexes: %s", classNOldDexFileList));
        this.logWriter.writeLineToInfoFile(String.format("Collected class N full patched dexes: %s", classNFullPatchedDexFileList));
        this.logWriter.writeLineToInfoFile(String.format("\nCollected other old dexes: %s", otherOldDexFileList));
        this.logWriter.writeLineToInfoFile(String.format("Collected other full patched dexes: %s", otherFullPatchedDexFileList));
        smallDexPatchGenerator.appendDexGroup(DexClassesComparator.DexGroup.wrap(classNOldDexFileList), DexClassesComparator.DexGroup.wrap(classNFullPatchedDexFileList));
        if (!otherOldDexFileList.isEmpty()) {
            smallDexPatchGenerator.appendDexGroup(DexClassesComparator.DexGroup.wrap(otherOldDexFileList), DexClassesComparator.DexGroup.wrap(otherFullPatchedDexFileList));
        }
        try {
            Logger.d("Start generating small patch info file...");
            smallDexPatchGenerator.executeAndSaveTo(tempSmallPatchInfoFile);
        }
        catch (Exception e) {
            throw new TinkerPatchException("\nFailed to generate small patch info file.", e);
        }
        if (!tempSmallPatchInfoFile.exists()) {
            throw new TinkerPatchException("can not find the small patch info file:" + tempSmallPatchInfoFile.getAbsolutePath());
        }
        SmallPatchedDexItemFile smallPatchedDexItemFile = new SmallPatchedDexItemFile(tempSmallPatchInfoFile);
        for (AbstractMap.SimpleEntry<File, File> simpleEntry : this.oldAndNewDexFilePairList) {
            File oldFile = simpleEntry.getKey();
            File newFile = simpleEntry.getValue();
            String dexName3 = oldFile.getName();
            String oldDexSignStr = Hex.toHexString((byte[])new Dex(oldFile).computeSignature(false));
            File tempSmallPatchedFile = new File(tempSmallPatchDexPath, dexName3);
            RelatedInfo relatedInfo = this.dexNameToRelatedInfoMap.get(dexName3);
            File dexDiffFile = relatedInfo.dexDiffFile;
            if (smallPatchedDexItemFile.isSmallPatchedDexEmpty(oldDexSignStr)) continue;
            try {
                new DexPatchApplier(oldFile, dexDiffFile, smallPatchedDexItemFile).executeAndSaveTo(tempSmallPatchedFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TinkerPatchException("Failed to generate temporary small patched dex, which makes MD5 generating procedure of small patched dex failed, either.", e);
            }
            if (!tempSmallPatchedFile.exists()) {
                throw new TinkerPatchException("can not find the temporary small patched dex file:" + tempSmallPatchInfoFile.getAbsolutePath());
            }
            relatedInfo.smallPatchedMd5 = MD5.getMD5(tempSmallPatchedFile);
            Logger.d("\nGen %s for art small dex file:%s, size:%d, md5:%s", dexName3, tempSmallPatchedFile.getAbsolutePath(), tempSmallPatchedFile.length(), relatedInfo.smallPatchedMd5);
            if (relatedInfo.oldMd5.equals(relatedInfo.newMd5)) {
                this.writeLogFiles(newFile, oldFile, relatedInfo.dexDiffFile, "0", relatedInfo.smallPatchedMd5, "0");
                continue;
            }
            this.writeLogFiles(newFile, oldFile, relatedInfo.dexDiffFile, relatedInfo.newOrFullPatchedMd5, relatedInfo.smallPatchedMd5, relatedInfo.dexDiffMd5);
        }
        this.addTestDex();
        HashSet<String> hashSet = new HashSet<String>(this.deletedClassDescToDexNameMap.keySet());
        HashSet<String> hashSet2 = new HashSet<String>(this.addedClassDescToDexNameMap.keySet());
        hashSet.retainAll(hashSet2);
        HashSet<String> movedCrossFilesClassDescs = hashSet;
        if (!movedCrossFilesClassDescs.isEmpty()) {
            Logger.e("Warning:Class Moved. Some classes are just moved from one dex to another. This behavior may leads to unnecessary enlargement of patch file. you should try to check them:");
            for (String classDesc : movedCrossFilesClassDescs) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                sb.append("classDesc:").append(classDesc).append(',');
                sb.append("from:").append(this.deletedClassDescToDexNameMap.get(classDesc)).append(',');
                sb.append("to:").append(this.addedClassDescToDexNameMap.get(classDesc));
                sb.append('}');
                Logger.e(sb.toString());
            }
        }
    }

    @Override
    public void clean() {
        this.metaWriter.close();
        this.logWriter.close();
    }

    private void ensureDirectoryExist(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new TinkerPatchException("failed to create directory: " + dir);
        }
    }

    private boolean isDexNameMatchesClassNPattern(String dexName) {
        return dexName.matches("^classes[0-9]*\\.dex$");
    }

    private void copyNewDexAndMarkInMeta(File newFile, String newMd5, File output) throws IOException {
        newMd5 = this.checkNewDexAndMd5(newMd5, newFile);
        FileOperation.copyFileUsingStream(newFile, output);
        this.writeLogFiles(newFile, null, null, newMd5, newMd5, "0");
    }

    private void checkAddedOrDeletedClasses(File oldFile, File newFile) throws IOException {
        Dex oldDex = new Dex(oldFile);
        Dex newDex = new Dex(newFile);
        HashSet oldClassDescs = new HashSet();
        for (Object oldClassDef : oldDex.classDefs()) {
            oldClassDescs.add(oldDex.typeNames().get(((ClassDef)oldClassDef).typeIndex));
        }
        HashSet newClassDescs = new HashSet();
        for (ClassDef newClassDef : newDex.classDefs()) {
            newClassDescs.add(newDex.typeNames().get(newClassDef.typeIndex));
        }
        HashSet addedClassDescs = new HashSet(newClassDescs);
        addedClassDescs.removeAll(oldClassDescs);
        HashSet deletedClassDescs = new HashSet(oldClassDescs);
        deletedClassDescs.removeAll(newClassDescs);
        for (String addedClassDesc : addedClassDescs) {
            if (this.addedClassDescToDexNameMap.containsKey(addedClassDesc)) {
                throw new TinkerPatchException(String.format("Class Duplicate. Class [%s] is added in both new dex: [%s] and [%s]. Please check your newly apk.", addedClassDesc, this.addedClassDescToDexNameMap.get(addedClassDesc), newFile.toString()));
            }
            this.addedClassDescToDexNameMap.put(addedClassDesc, newFile.toString());
        }
        for (String deletedClassDesc : deletedClassDescs) {
            if (this.deletedClassDescToDexNameMap.containsKey(deletedClassDesc)) {
                throw new TinkerPatchException(String.format("Class Duplicate. Class [%s] is deleted in both old dex: [%s] and [%s]. Please check your base apk.", deletedClassDesc, this.addedClassDescToDexNameMap.get(deletedClassDesc), oldFile.toString()));
            }
            this.deletedClassDescToDexNameMap.put(deletedClassDesc, newFile.toString());
        }
    }

    private void checkDexChange(Dex originDex, Dex newDex) {
        DexClassesComparator classesCmptor = new DexClassesComparator("*");
        classesCmptor.setIgnoredRemovedClassDescPattern(this.config.mDexLoaderPattern);
        classesCmptor.startCheck(originDex, newDex);
        List<DexClassesComparator.DexClassInfo> addedClassInfos = classesCmptor.getAddedClassInfos();
        boolean isNoClassesAdded = addedClassInfos.isEmpty();
        if (!isNoClassesAdded) {
            throw new TinkerPatchException("some classes was unexpectedly added in patched new dex, check if there's any bugs in patch algorithm. Related classes: " + Utils.collectionToString(addedClassInfos));
        }
        Map<String, DexClassesComparator.DexClassInfo[]> changedClassDescToClassInfosMap = classesCmptor.getChangedClassDescToInfosMap();
        boolean isNoClassesChanged = changedClassDescToClassInfosMap.isEmpty();
        if (isNoClassesChanged) {
            List<DexClassesComparator.DexClassInfo> deletedClassInfos = classesCmptor.getDeletedClassInfos();
            if (!deletedClassInfos.isEmpty()) {
                throw new TinkerPatchException("some classes that are not matched to loader class pattern was unexpectedly deleted in patched new dex, check if there's any bugs in patch algorithm. Related classes: " + Utils.collectionToString(deletedClassInfos));
            }
        } else {
            throw new TinkerPatchException("some classes was unexpectedly changed in patched new dex, check if there's any bugs in patch algorithm. Related classes: " + Utils.collectionToString(changedClassDescToClassInfosMap.keySet()));
        }
    }

    private void addTestDex() throws IOException {
        String dexMode = "jar";
        if (this.config.mDexRaw) {
            dexMode = "raw";
        }
        InputStream is = DexDiffDecoder.class.getResourceAsStream("/test.dex");
        String md5 = MD5.getMD5(is, 1024);
        is.close();
        String meta = "test.dex,," + md5 + "," + md5 + "," + 0 + "," + 0 + "," + dexMode;
        File dest = new File(this.config.mTempResultDir + "/" + TEST_DEX_NAME);
        FileOperation.copyResourceUsingStream(TEST_DEX_NAME, dest);
        Logger.d("\nAdd test install result dex: %s, size:%d", dest.getAbsolutePath(), dest.length());
        Logger.d("DexDecoder:write test dex meta file data: %s", meta);
        this.metaWriter.writeLineToInfoFile(meta);
    }

    private String checkNewDexAndMd5(String md5, File dexFile) {
        String name = dexFile.getName();
        if (name.endsWith(".dex")) {
            return md5;
        }
        try {
            JarFile dexJar = new JarFile(dexFile);
            ZipEntry classesDex = dexJar.getEntry("classes.dex");
            if (null == classesDex) {
                throw new TinkerPatchException(String.format("dex jar file %s do not contain 'classes.dex', it is not a correct dex jar file!", dexFile.getAbsolutePath()));
            }
            return MD5.getMD5(dexJar.getInputStream(classesDex), 102400);
        }
        catch (IOException e) {
            throw new TinkerPatchException(String.format("dex file %s is not end with '.dex', but it is not a correct dex jar file also!", dexFile.getAbsolutePath()), e);
        }
    }

    private String getRelativeStringBy(File file, File reference) {
        File actualReference = reference.getParentFile();
        if (actualReference == null) {
            actualReference = reference;
        }
        return actualReference.toPath().relativize(file.toPath()).toString().replace("\\", "/");
    }

    protected void writeLogFiles(File newOrFullPatchedFile, File oldFile, File dexDiffFile, String destMd5InDvm, String destMd5InArt, String dexDiffMd5) throws IOException {
        if (this.metaWriter == null && this.logWriter == null) {
            return;
        }
        String parentRelative = this.getParentRelativeString(newOrFullPatchedFile);
        String relative = this.getRelativeString(newOrFullPatchedFile);
        if (this.metaWriter != null) {
            String oldCrc;
            String fileName = newOrFullPatchedFile.getName();
            String dexMode = "jar";
            if (this.config.mDexRaw) {
                dexMode = "raw";
            }
            if (oldFile == null) {
                oldCrc = "0";
                Logger.d("DexDecoder:add newly dex file: %s", parentRelative);
            } else {
                oldCrc = FileOperation.getZipEntryCrc(this.config.mOldApkFile, relative);
                if (oldCrc == null || oldCrc.equals("0")) {
                    throw new TinkerPatchException(String.format("can't find zipEntry %s from old apk file %s", relative, this.config.mOldApkFile.getPath()));
                }
            }
            String meta = fileName + "," + parentRelative + "," + destMd5InDvm + "," + destMd5InArt + "," + dexDiffMd5 + "," + oldCrc + "," + dexMode;
            Logger.d("DexDecoder:write meta file data: %s", meta);
            this.metaWriter.writeLineToInfoFile(meta);
        }
        if (this.logWriter != null) {
            String log = relative + ", oldSize=" + FileOperation.getFileSizes(oldFile) + ", newSize=" + FileOperation.getFileSizes(newOrFullPatchedFile) + ", diffSize=" + FileOperation.getFileSizes(dexDiffFile);
            this.logWriter.writeLineToInfoFile(log);
        }
    }

    private final class DexPatcherLoggerBridge
    implements DexPatcherLogger.IDexPatcherLogger {
        private final InfoWriter logWritter;

        DexPatcherLoggerBridge(InfoWriter logWritter) {
            this.logWritter = logWritter;
        }

        public void v(String msg) {
            this.logWritter.writeLineToInfoFile(msg);
        }

        public void d(String msg) {
            this.logWritter.writeLineToInfoFile(msg);
        }

        public void i(String msg) {
            this.logWritter.writeLineToInfoFile(msg);
        }

        public void w(String msg) {
            this.logWritter.writeLineToInfoFile(msg);
        }

        public void e(String msg) {
            this.logWritter.writeLineToInfoFile(msg);
        }
    }

    private final class RelatedInfo {
        File newOrFullPatchedFile = null;
        File dexDiffFile = null;
        String oldMd5 = "0";
        String newMd5 = "0";
        String dexDiffMd5 = "0";
        String newOrFullPatchedMd5 = "0";
        String smallPatchedMd5 = "0";

        private RelatedInfo() {
        }
    }
}

