/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.SystemClock;
import android.util.Log;
import com.tencent.tinker.loader.AbstractTinkerLoader;
import com.tencent.tinker.loader.TinkerDexLoader;
import com.tencent.tinker.loader.TinkerResourceLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.TinkerSoLoader;
import com.tencent.tinker.loader.app.TinkerApplication;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.SharePatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.io.Serializable;

public class TinkerLoader
extends AbstractTinkerLoader {
    private static final String TAG = "Tinker.TinkerLoader";
    private SharePatchInfo patchInfo;

    @Override
    public Intent tryLoad(TinkerApplication app, int tinkerFlag, boolean tinkerLoadVerifyFlag) {
        Intent resultIntent = new Intent();
        long begin = SystemClock.elapsedRealtime();
        this.tryLoadPatchFilesInternal(app, tinkerFlag, tinkerLoadVerifyFlag, resultIntent);
        long cost = SystemClock.elapsedRealtime() - begin;
        ShareIntentUtil.setIntentPatchCostTime(resultIntent, cost);
        return resultIntent;
    }

    private void tryLoadPatchFilesInternal(TinkerApplication app, int tinkerFlag, boolean tinkerLoadVerifyFlag, Intent resultIntent) {
        boolean loadTinkerResources;
        boolean loadTinkerJars;
        boolean resourceCheck;
        boolean libCheck;
        boolean dexCheck;
        if (!ShareTinkerInternals.isTinkerEnabled(tinkerFlag)) {
            ShareIntentUtil.setIntentReturnCode(resultIntent, -1);
            return;
        }
        File patchDirectoryFile = SharePatchFileUtil.getPatchDirectory((Context)app);
        if (patchDirectoryFile == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:getPatchDirectory == null");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
            return;
        }
        String patchDirectoryPath = patchDirectoryFile.getAbsolutePath();
        if (!patchDirectoryFile.exists()) {
            Log.w((String)TAG, (String)("tryLoadPatchFiles:patch dir not exist:" + patchDirectoryPath));
            ShareIntentUtil.setIntentReturnCode(resultIntent, -2);
            return;
        }
        File patchInfoFile = SharePatchFileUtil.getPatchInfoFile(patchDirectoryPath);
        if (!patchInfoFile.exists()) {
            Log.w((String)TAG, (String)("tryLoadPatchFiles:patch info not exist:" + patchInfoFile.getAbsolutePath()));
            ShareIntentUtil.setIntentReturnCode(resultIntent, -3);
            return;
        }
        File patchInfoLockFile = SharePatchFileUtil.getPatchInfoLockFile(patchDirectoryPath);
        this.patchInfo = SharePatchInfo.readAndCheckPropertyWithLock(patchInfoFile, patchInfoLockFile);
        if (this.patchInfo == null) {
            ShareIntentUtil.setIntentReturnCode(resultIntent, -4);
            return;
        }
        String oldVersion = this.patchInfo.oldVersion;
        String newVersion = this.patchInfo.newVersion;
        if (oldVersion == null || newVersion == null) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchInfoCorrupted");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -4);
            return;
        }
        resultIntent.putExtra("intent_patch_old_version", oldVersion);
        resultIntent.putExtra("intent_patch_new_version", newVersion);
        boolean mainProcess = ShareTinkerInternals.isInMainProcess((Context)app);
        boolean versionChanged = !oldVersion.equals(newVersion);
        String version = oldVersion;
        if (versionChanged && mainProcess) {
            version = newVersion;
        }
        if (ShareTinkerInternals.isNullOrNil(version)) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:version is blank, wait main process to restart");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -5);
            return;
        }
        String patchName = SharePatchFileUtil.getPatchVersionDirectory(version);
        String patchVersionDirectory = patchDirectoryPath + "/" + patchName;
        File patchVersionDirectoryFile = new File(patchVersionDirectory);
        if (!patchVersionDirectoryFile.exists()) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchVersionDirectoryNotFound");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -6);
            return;
        }
        File patchVersionFile = new File(patchVersionDirectoryFile.getAbsolutePath(), SharePatchFileUtil.getPatchVersionFile(version));
        if (!patchVersionFile.exists()) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchVersionFileNotFound");
            ShareIntentUtil.setIntentReturnCode(resultIntent, -7);
            return;
        }
        ShareSecurityCheck securityCheck = new ShareSecurityCheck((Context)app);
        int returnCode = ShareTinkerInternals.checkTinkerPackage((Context)app, tinkerFlag, patchVersionFile, securityCheck);
        if (returnCode != 0) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:checkTinkerPackage");
            resultIntent.putExtra("intent_patch_package_patch_check", returnCode);
            ShareIntentUtil.setIntentReturnCode(resultIntent, -9);
            return;
        }
        resultIntent.putExtra("intent_patch_package_config", securityCheck.getPackagePropertiesIfPresent());
        boolean isEnabledForDex = ShareTinkerInternals.isTinkerEnabledForDex(tinkerFlag);
        if (isEnabledForDex && !(dexCheck = TinkerDexLoader.checkComplete(patchVersionDirectory, securityCheck, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:dex check fail");
            return;
        }
        boolean isEnabledForNativeLib = ShareTinkerInternals.isTinkerEnabledForNativeLib(tinkerFlag);
        if (isEnabledForNativeLib && !(libCheck = TinkerSoLoader.checkComplete(patchVersionDirectory, securityCheck, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:native lib check fail");
            return;
        }
        boolean isEnabledForResource = ShareTinkerInternals.isTinkerEnabledForResource(tinkerFlag);
        Log.w((String)TAG, (String)("tryLoadPatchFiles:isEnabledForResource:" + isEnabledForResource));
        if (isEnabledForResource && !(resourceCheck = TinkerResourceLoader.checkComplete((Context)app, patchVersionDirectory, securityCheck, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:resource check fail");
            return;
        }
        if (mainProcess && versionChanged) {
            this.patchInfo.oldVersion = version;
            if (!SharePatchInfo.rewritePatchInfoFileWithLock(patchInfoFile, this.patchInfo, patchInfoLockFile)) {
                ShareIntentUtil.setIntentReturnCode(resultIntent, -18);
                Log.w((String)TAG, (String)"tryLoadPatchFiles:onReWritePatchInfoCorrupted");
                return;
            }
        }
        if (!this.checkSafeModeCount(app)) {
            resultIntent.putExtra("intent_patch_exception", (Serializable)new TinkerRuntimeException("checkSafeModeCount fail"));
            ShareIntentUtil.setIntentReturnCode(resultIntent, -24);
            Log.w((String)TAG, (String)"tryLoadPatchFiles:checkSafeModeCount fail");
            return;
        }
        if (isEnabledForDex && !(loadTinkerJars = TinkerDexLoader.loadTinkerJars(app, tinkerLoadVerifyFlag, patchVersionDirectory, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchLoadDexesFail");
            return;
        }
        if (isEnabledForResource && !(loadTinkerResources = TinkerResourceLoader.loadTinkerResources((Context)app, tinkerLoadVerifyFlag, patchVersionDirectory, resultIntent))) {
            Log.w((String)TAG, (String)"tryLoadPatchFiles:onPatchLoadResourcesFail");
            return;
        }
        ShareIntentUtil.setIntentReturnCode(resultIntent, 0);
        Log.i((String)TAG, (String)"tryLoadPatchFiles: load end, ok!");
    }

    private boolean checkSafeModeCount(TinkerApplication application) {
        String processName = ShareTinkerInternals.getProcessName((Context)application);
        String preferName = "tinker_own_config_" + processName;
        SharedPreferences sp = application.getSharedPreferences(preferName, 0);
        int count = sp.getInt("safe_mode_count", 0);
        Log.w((String)TAG, (String)("tinker safe mode preferName:" + preferName + " count:" + count));
        if (count >= 3) {
            sp.edit().putInt("safe_mode_count", 0).commit();
            return false;
        }
        application.setUseSafeMode(true);
        sp.edit().putInt("safe_mode_count", ++count).commit();
        Log.w((String)TAG, (String)("after tinker safe mode count:" + count));
        return true;
    }
}

