/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=14)
class AndroidNClassLoader
extends PathClassLoader {
    static ArrayList<DexFile> oldDexFiles = new ArrayList();
    PathClassLoader originClassLoader;

    private AndroidNClassLoader(String dexPath, PathClassLoader parent) {
        super(dexPath, parent.getParent());
        this.originClassLoader = parent;
    }

    private static AndroidNClassLoader createAndroidNClassLoader(PathClassLoader original) throws Exception {
        Object[] originDexElements;
        AndroidNClassLoader androidNClassLoader = new AndroidNClassLoader("", original);
        Field originPathList = ShareReflectUtil.findField(original, "pathList");
        Object originPathListObject = originPathList.get(original);
        Field originClassloader = ShareReflectUtil.findField(originPathListObject, "definingContext");
        originClassloader.set(originPathListObject, (Object)androidNClassLoader);
        Field pathListField = ShareReflectUtil.findField((Object)androidNClassLoader, "pathList");
        pathListField.set((Object)androidNClassLoader, originPathListObject);
        ArrayList<File> additionalClassPathEntries = new ArrayList<File>();
        Field dexElement = ShareReflectUtil.findField(originPathListObject, "dexElements");
        for (Object element : originDexElements = (Object[])dexElement.get(originPathListObject)) {
            DexFile dexFile = (DexFile)ShareReflectUtil.findField(element, "dexFile").get(element);
            additionalClassPathEntries.add(new File(dexFile.getName()));
            oldDexFiles.add(dexFile);
        }
        Method makePathElements = ShareReflectUtil.findMethod(originPathListObject, "makePathElements", List.class, File.class, List.class);
        ArrayList suppressedExceptions = new ArrayList();
        Object[] newDexElements = (Object[])makePathElements.invoke(originPathListObject, additionalClassPathEntries, null, suppressedExceptions);
        dexElement.set(originPathListObject, newDexElements);
        return androidNClassLoader;
    }

    private static void reflectPackageInfoClassloader(Application application, ClassLoader reflectClassLoader) throws Exception {
        String defBase = "mBase";
        String defPackageInfo = "mPackageInfo";
        String defClassLoader = "mClassLoader";
        Context baseContext = (Context)ShareReflectUtil.findField(application, defBase).get(application);
        Object basePackageInfo = ShareReflectUtil.findField(baseContext, defPackageInfo).get(baseContext);
        Field classLoaderField = ShareReflectUtil.findField(basePackageInfo, defClassLoader);
        Thread.currentThread().setContextClassLoader(reflectClassLoader);
        classLoaderField.set(basePackageInfo, reflectClassLoader);
    }

    public static AndroidNClassLoader inject(PathClassLoader originClassLoader, Application application) throws Exception {
        AndroidNClassLoader classLoader = AndroidNClassLoader.createAndroidNClassLoader(originClassLoader);
        AndroidNClassLoader.reflectPackageInfoClassloader(application, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    public String findLibrary(String name) {
        return super.findLibrary(name);
    }
}

