/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.TinkerResourcePatcher;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareResPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.File;
import java.io.Serializable;

public class TinkerResourceLoader {
    protected static final String RESOURCE_META_FILE = "assets/res_meta.txt";
    protected static final String RESOURCE_FILE = "resources.apk";
    protected static final String RESOURCE_PATH = "res";
    private static final String TAG = "Tinker.ResourceLoader";
    private static ShareResPatchInfo resPatchInfo = new ShareResPatchInfo();

    private TinkerResourceLoader() {
    }

    public static boolean loadTinkerResources(Context context, boolean tinkerLoadVerifyFlag, String directory, Intent intentResult) {
        if (resPatchInfo == null || TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        String resourceString = directory + "/" + RESOURCE_PATH + "/" + RESOURCE_FILE;
        File resourceFile = new File(resourceString);
        long start = System.currentTimeMillis();
        if (tinkerLoadVerifyFlag) {
            if (!SharePatchFileUtil.checkResourceArscMd5(resourceFile, TinkerResourceLoader.resPatchInfo.resArscMd5)) {
                Log.e((String)TAG, (String)("Failed to load resource file, path: " + resourceFile.getPath() + ", expect md5: " + TinkerResourceLoader.resPatchInfo.resArscMd5));
                ShareIntentUtil.setIntentReturnCode(intentResult, -23);
                return false;
            }
            Log.i((String)TAG, (String)("verify resource file:" + resourceFile.getPath() + " md5, use time: " + (System.currentTimeMillis() - start)));
        }
        try {
            TinkerResourcePatcher.monkeyPatchExistingResources(context, resourceString);
            Log.i((String)TAG, (String)("monkeyPatchExistingResources resource file:" + resourceString + ", use time: " + (System.currentTimeMillis() - start)));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"install resources failed");
            try {
                SystemClassLoaderAdder.uninstallPatchDex(context.getClassLoader());
            }
            catch (Throwable throwable) {
                Log.e((String)TAG, (String)"uninstallPatchDex failed", (Throwable)e);
            }
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -22);
            return false;
        }
        return true;
    }

    public static boolean checkComplete(Context context, String directory, ShareSecurityCheck securityCheck, Intent intentResult) {
        String meta = securityCheck.getMetaContentMap().get(RESOURCE_META_FILE);
        if (meta == null) {
            return true;
        }
        ShareResPatchInfo.parseResPatchInfoFirstLine(meta, resPatchInfo);
        if (TinkerResourceLoader.resPatchInfo.resArscMd5 == null) {
            return true;
        }
        if (!ShareResPatchInfo.checkResPatchInfo(resPatchInfo)) {
            intentResult.putExtra("intent_patch_package_patch_check", -8);
            ShareIntentUtil.setIntentReturnCode(intentResult, -9);
            return false;
        }
        String resourcePath = directory + "/" + RESOURCE_PATH + "/";
        File resourceDir = new File(resourcePath);
        if (!resourceDir.exists() || !resourceDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -20);
            return false;
        }
        File resourceFile = new File(resourcePath + RESOURCE_FILE);
        if (!resourceFile.exists()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -21);
            return false;
        }
        try {
            TinkerResourcePatcher.isResourceCanPatch(context);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"resource hook check failed.", (Throwable)e);
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -22);
            return false;
        }
        return true;
    }
}

