/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Intent;
import com.tencent.tinker.loader.shareutil.ShareBsDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class TinkerSoLoader {
    protected static final String SO_MEAT_FILE = "assets/so_meta.txt";
    protected static final String SO_PATH = "lib";
    private static final String TAG = "Tinker.TinkerSoLoader";

    public static boolean checkComplete(String directory, ShareSecurityCheck securityCheck, Intent intentResult) {
        String meta = securityCheck.getMetaContentMap().get(SO_MEAT_FILE);
        if (meta == null) {
            return true;
        }
        ArrayList<ShareBsDiffPatchInfo> libraryList = new ArrayList<ShareBsDiffPatchInfo>();
        ShareBsDiffPatchInfo.parseDiffPatchInfo(meta, libraryList);
        if (libraryList.isEmpty()) {
            return true;
        }
        String libraryPath = directory + "/" + SO_PATH + "/";
        HashMap<String, String> libs = new HashMap<String, String>();
        for (ShareBsDiffPatchInfo info : libraryList) {
            if (!ShareBsDiffPatchInfo.checkDiffPatchInfo(info)) {
                intentResult.putExtra("intent_patch_package_patch_check", -4);
                ShareIntentUtil.setIntentReturnCode(intentResult, -9);
                return false;
            }
            String middle = info.path + "/" + info.name;
            libs.put(middle, info.md5);
        }
        File libraryDir = new File(libraryPath);
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -16);
            return false;
        }
        for (String relative : libs.keySet()) {
            File libFile = new File(libraryPath + relative);
            if (libFile.exists()) continue;
            ShareIntentUtil.setIntentReturnCode(intentResult, -17);
            intentResult.putExtra("intent_patch_missing_lib_path", libFile.getAbsolutePath());
            return false;
        }
        intentResult.putExtra("intent_patch_libs_path", libs);
        return true;
    }
}

