/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.ArrayMap;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;

class TinkerResourcePatcher {
    private static Collection<WeakReference<Resources>> references;
    private static AssetManager newAssetManager;
    private static Method addAssetPathMethod;
    private static Method ensureStringBlocksMethod;
    private static Field assetsFiled;
    private static Field resourcesImplFiled;

    TinkerResourcePatcher() {
    }

    public static void isResourceCanPatch(Context context) throws Throwable {
        newAssetManager = (AssetManager)AssetManager.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        addAssetPathMethod = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        addAssetPathMethod.setAccessible(true);
        ensureStringBlocksMethod = AssetManager.class.getDeclaredMethod("ensureStringBlocks", new Class[0]);
        ensureStringBlocksMethod.setAccessible(true);
        if (Build.VERSION.SDK_INT >= 19) {
            Class<?> resourcesManagerClass = Class.forName("android.app.ResourcesManager");
            Method mGetInstance = resourcesManagerClass.getDeclaredMethod("getInstance", new Class[0]);
            mGetInstance.setAccessible(true);
            Object resourcesManager = mGetInstance.invoke(null, new Object[0]);
            try {
                Field fMActiveResources = resourcesManagerClass.getDeclaredField("mActiveResources");
                fMActiveResources.setAccessible(true);
                ArrayMap arrayMap = (ArrayMap)fMActiveResources.get(resourcesManager);
                references = arrayMap.values();
            }
            catch (NoSuchFieldException ignore) {
                Field mResourceReferences = resourcesManagerClass.getDeclaredField("mResourceReferences");
                mResourceReferences.setAccessible(true);
                references = (Collection)mResourceReferences.get(resourcesManager);
            }
        } else {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Field fMActiveResources = activityThread.getDeclaredField("mActiveResources");
            fMActiveResources.setAccessible(true);
            Object thread = TinkerResourcePatcher.getActivityThread(context, activityThread);
            HashMap map = (HashMap)fMActiveResources.get(thread);
            references = map.values();
        }
        if (references == null || references.isEmpty()) {
            throw new IllegalStateException("resource references is null or empty");
        }
        try {
            assetsFiled = Resources.class.getDeclaredField("mAssets");
            assetsFiled.setAccessible(true);
        }
        catch (Throwable ignore) {
            resourcesImplFiled = Resources.class.getDeclaredField("mResourcesImpl");
            resourcesImplFiled.setAccessible(true);
        }
    }

    public static void monkeyPatchExistingResources(String externalResourceFile) throws Throwable {
        if (externalResourceFile == null) {
            return;
        }
        if ((Integer)addAssetPathMethod.invoke((Object)newAssetManager, externalResourceFile) == 0) {
            throw new IllegalStateException("Could not create new AssetManager");
        }
        ensureStringBlocksMethod.invoke((Object)newAssetManager, new Object[0]);
        for (WeakReference<Resources> wr : references) {
            Resources resources = (Resources)wr.get();
            if (resources == null) continue;
            try {
                assetsFiled.set(resources, newAssetManager);
            }
            catch (Throwable ignore) {
                Object resourceImpl = resourcesImplFiled.get(resources);
                Field implAssets = resourceImpl.getClass().getDeclaredField("mAssets");
                implAssets.setAccessible(true);
                implAssets.set(resourceImpl, newAssetManager);
            }
            resources.updateConfiguration(resources.getConfiguration(), resources.getDisplayMetrics());
        }
    }

    private static Object getActivityThread(Context context, Class<?> activityThread) {
        try {
            if (activityThread == null) {
                activityThread = Class.forName("android.app.ActivityThread");
            }
            Method m = activityThread.getMethod("currentActivityThread", new Class[0]);
            m.setAccessible(true);
            Object currentActivityThread = m.invoke(null, new Object[0]);
            if (currentActivityThread == null && context != null) {
                Field mLoadedApk = context.getClass().getField("mLoadedApk");
                mLoadedApk.setAccessible(true);
                Object apk = mLoadedApk.get(context);
                Field mActivityThreadField = apk.getClass().getDeclaredField("mActivityThread");
                mActivityThreadField.setAccessible(true);
                currentActivityThread = mActivityThreadField.get(apk);
            }
            return currentActivityThread;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    static {
        newAssetManager = null;
        addAssetPathMethod = null;
        ensureStringBlocksMethod = null;
        assetsFiled = null;
        resourcesImplFiled = null;
    }
}

