/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Field;

@TargetApi(value=14)
class AndroidNClassLoader
extends PathClassLoader {
    PathClassLoader originClassLoader;

    private AndroidNClassLoader(String dexPath, PathClassLoader parent) {
        super(dexPath, parent.getParent());
        this.originClassLoader = parent;
    }

    private static AndroidNClassLoader createAndroidNClassLoader(PathClassLoader original) throws Exception {
        AndroidNClassLoader androidNClassLoader = new AndroidNClassLoader("", original);
        Field originPathList = AndroidNClassLoader.findField(original, "pathList");
        Object originPathListObject = originPathList.get(original);
        Field originClassloader = AndroidNClassLoader.findField(originPathListObject, "definingContext");
        originClassloader.set(originPathListObject, (Object)androidNClassLoader);
        Field pathListField = AndroidNClassLoader.findField((Object)androidNClassLoader, "pathList");
        pathListField.set((Object)androidNClassLoader, originPathListObject);
        return androidNClassLoader;
    }

    private static Field findField(Object instance, String name) throws NoSuchFieldException {
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(name);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field " + name + " not found in " + instance.getClass());
    }

    private static void reflectPackageInfoClassloader(Application application, ClassLoader reflectClassLoader) throws Exception {
        String defBase = "mBase";
        String defPackageInfo = "mPackageInfo";
        String defClassLoader = "mClassLoader";
        Context baseContext = (Context)AndroidNClassLoader.findField(application, defBase).get(application);
        Object basePackageInfo = AndroidNClassLoader.findField(baseContext, defPackageInfo).get(baseContext);
        Field classLoaderField = AndroidNClassLoader.findField(basePackageInfo, defClassLoader);
        Thread.currentThread().setContextClassLoader(reflectClassLoader);
        classLoaderField.set(basePackageInfo, reflectClassLoader);
    }

    public static AndroidNClassLoader inject(PathClassLoader originClassLoader, Application application) throws Exception {
        AndroidNClassLoader classLoader = AndroidNClassLoader.createAndroidNClassLoader(originClassLoader);
        AndroidNClassLoader.reflectPackageInfoClassloader(application, (ClassLoader)((Object)classLoader));
        return classLoader;
    }

    public Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    public String findLibrary(String name) {
        return super.findLibrary(name);
    }
}

