/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.util;

import android.util.Log;

public class TinkerLog {
    private static final String TAG = "Tinker.TinkerLog";
    private static TinkerLogImp debugLog;
    private static TinkerLogImp tinkerLogImp;

    public static void setTinkerLogImp(TinkerLogImp imp) {
        tinkerLogImp = imp;
    }

    public static TinkerLogImp getImpl() {
        return tinkerLogImp;
    }

    public static void v(String tag, String msg, Object ... obj) {
        if (tinkerLogImp != null) {
            tinkerLogImp.v(tag, msg, obj);
        }
    }

    public static void e(String tag, String msg, Object ... obj) {
        if (tinkerLogImp != null) {
            tinkerLogImp.e(tag, msg, obj);
        }
    }

    public static void w(String tag, String msg, Object ... obj) {
        if (tinkerLogImp != null) {
            tinkerLogImp.w(tag, msg, obj);
        }
    }

    public static void i(String tag, String msg, Object ... obj) {
        if (tinkerLogImp != null) {
            tinkerLogImp.i(tag, msg, obj);
        }
    }

    public static void d(String tag, String msg, Object ... obj) {
        if (tinkerLogImp != null) {
            tinkerLogImp.d(tag, msg, obj);
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (tinkerLogImp != null) {
            tinkerLogImp.printErrStackTrace(tag, tr, format, obj);
        }
    }

    static {
        tinkerLogImp = debugLog = new TinkerLogImp(){

            @Override
            public void v(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                Log.v((String)tag, (String)log);
            }

            @Override
            public void i(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                Log.i((String)tag, (String)log);
            }

            @Override
            public void d(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                Log.d((String)tag, (String)log);
            }

            @Override
            public void w(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                Log.w((String)tag, (String)log);
            }

            @Override
            public void e(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                Log.e((String)tag, (String)log);
            }

            @Override
            public void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
                String log;
                String string = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                log = log + "  " + Log.getStackTraceString((Throwable)tr);
                Log.e((String)tag, (String)log);
            }
        };
    }

    public static interface TinkerLogImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);
    }
}

