/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.bsdiff;

import com.tencent.tinker.bsdiff.BSUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class BSPatch {
    public static final int RETURN_SUCCESS = 1;
    public static final int RETURN_DIFF_FILE_ERR = 2;
    public static final int RETURN_OLD_FILE_ERR = 3;
    public static final int RETURN_NEW_FILE_ERR = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int patchLessMemory(RandomAccessFile oldFile, File newFile, File diffFile, int extLen) throws IOException {
        if (oldFile == null || oldFile.length() <= 0L) {
            return 3;
        }
        if (newFile == null) {
            return 4;
        }
        if (diffFile == null || diffFile.length() <= 0L) {
            return 2;
        }
        byte[] diffBytes = new byte[(int)diffFile.length()];
        try (FileInputStream diffInputStream = new FileInputStream(diffFile);){
            BSUtil.readFromStream(diffInputStream, diffBytes, 0, diffBytes.length);
        }
        return BSPatch.patchLessMemory(oldFile, (int)oldFile.length(), diffBytes, diffBytes.length, newFile, extLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int patchLessMemory(RandomAccessFile oldFile, int oldsize, byte[] diffBuf, int diffSize, File newFile, int extLen) throws IOException {
        if (oldFile == null || oldsize <= 0) {
            return 3;
        }
        if (newFile == null) {
            return 4;
        }
        if (diffBuf == null || diffSize <= 0) {
            return 2;
        }
        int commentLenPos = oldsize - extLen - 2;
        if (commentLenPos <= 2) {
            return 3;
        }
        DataInputStream diffIn = new DataInputStream(new ByteArrayInputStream(diffBuf, 0, diffSize));
        diffIn.skip(8L);
        long ctrlBlockLen = diffIn.readLong();
        long diffBlockLen = diffIn.readLong();
        int newsize = (int)diffIn.readLong();
        diffIn.close();
        ByteArrayInputStream in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(32L);
        DataInputStream ctrlBlockIn = new DataInputStream(new GZIPInputStream(in));
        in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(ctrlBlockLen + 32L);
        GZIPInputStream diffBlockIn = new GZIPInputStream(in);
        in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(diffBlockLen + ctrlBlockLen + 32L);
        GZIPInputStream extraBlockIn = new GZIPInputStream(in);
        FileOutputStream outStream = new FileOutputStream(newFile);
        try {
            int oldpos = 0;
            int[] ctrl = new int[3];
            for (int newpos = 0; newpos < newsize; newpos += ctrl[1]) {
                int n;
                int i;
                for (i = 0; i <= 2; ++i) {
                    ctrl[i] = ctrlBlockIn.readInt();
                }
                if (newpos + ctrl[0] > newsize) {
                    ((OutputStream)outStream).close();
                    i = 2;
                    return i;
                }
                byte[] buffer = new byte[ctrl[0]];
                if (!BSUtil.readFromStream(diffBlockIn, buffer, 0, ctrl[0])) {
                    ((OutputStream)outStream).close();
                    int n2 = 2;
                    return n2;
                }
                byte[] oldBuffer = new byte[ctrl[0]];
                if (oldFile.read(oldBuffer, 0, ctrl[0]) < ctrl[0]) {
                    ((OutputStream)outStream).close();
                    n = 2;
                    return n;
                }
                for (int i2 = 0; i2 < ctrl[0]; ++i2) {
                    if (oldpos + i2 == commentLenPos) {
                        oldBuffer[i2] = 0;
                        oldBuffer[i2 + 1] = 0;
                    }
                    if (oldpos + i2 < 0 || oldpos + i2 >= oldsize) continue;
                    int n3 = i2;
                    buffer[n3] = (byte)(buffer[n3] + oldBuffer[i2]);
                }
                ((OutputStream)outStream).write(buffer);
                oldpos += ctrl[0];
                if ((newpos += ctrl[0]) + ctrl[1] > newsize) {
                    ((OutputStream)outStream).close();
                    n = 2;
                    return n;
                }
                buffer = new byte[ctrl[1]];
                if (!BSUtil.readFromStream(extraBlockIn, buffer, 0, ctrl[1])) {
                    ((OutputStream)outStream).close();
                    n = 2;
                    return n;
                }
                ((OutputStream)outStream).write(buffer);
                outStream.flush();
                oldFile.seek(oldpos += ctrl[2]);
            }
            ctrlBlockIn.close();
            ((InputStream)diffBlockIn).close();
            ((InputStream)extraBlockIn).close();
        }
        finally {
            oldFile.close();
            ((OutputStream)outStream).close();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int patchFast(File oldFile, File newFile, File diffFile, int extLen) throws IOException {
        if (oldFile == null || oldFile.length() <= 0L) {
            return 3;
        }
        if (newFile == null) {
            return 4;
        }
        if (diffFile == null || diffFile.length() <= 0L) {
            return 2;
        }
        BufferedInputStream oldInputStream = new BufferedInputStream(new FileInputStream(oldFile));
        byte[] diffBytes = new byte[(int)diffFile.length()];
        try (FileInputStream diffInputStream = new FileInputStream(diffFile);){
            BSUtil.readFromStream(diffInputStream, diffBytes, 0, diffBytes.length);
        }
        byte[] newBytes = BSPatch.patchFast(oldInputStream, (int)oldFile.length(), diffBytes, extLen);
        try (FileOutputStream newOutputStream = new FileOutputStream(newFile);){
            ((OutputStream)newOutputStream).write(newBytes);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int patchFast(InputStream oldInputStream, InputStream diffInputStream, File newFile) throws IOException {
        if (oldInputStream == null) {
            return 3;
        }
        if (newFile == null) {
            return 4;
        }
        if (diffInputStream == null) {
            return 2;
        }
        byte[] oldBytes = BSUtil.inputStreamToByte(oldInputStream);
        byte[] diffBytes = BSUtil.inputStreamToByte(diffInputStream);
        byte[] newBytes = BSPatch.patchFast(oldBytes, oldBytes.length, diffBytes, diffBytes.length, 0);
        try (FileOutputStream newOutputStream = new FileOutputStream(newFile);){
            ((OutputStream)newOutputStream).write(newBytes);
        }
        return 1;
    }

    public static byte[] patchFast(InputStream oldInputStream, InputStream diffInputStream) throws IOException {
        if (oldInputStream == null) {
            return null;
        }
        if (diffInputStream == null) {
            return null;
        }
        byte[] oldBytes = BSUtil.inputStreamToByte(oldInputStream);
        byte[] diffBytes = BSUtil.inputStreamToByte(diffInputStream);
        byte[] newBytes = BSPatch.patchFast(oldBytes, oldBytes.length, diffBytes, diffBytes.length, 0);
        return newBytes;
    }

    public static byte[] patchFast(InputStream oldInputStream, int oldsize, byte[] diffBytes, int extLen) throws IOException {
        byte[] oldBuf = new byte[oldsize];
        BSUtil.readFromStream(oldInputStream, oldBuf, 0, oldsize);
        oldInputStream.close();
        return BSPatch.patchFast(oldBuf, oldsize, diffBytes, diffBytes.length, extLen);
    }

    public static byte[] patchFast(byte[] oldBuf, int oldsize, byte[] diffBuf, int diffSize, int extLen) throws IOException {
        DataInputStream diffIn = new DataInputStream(new ByteArrayInputStream(diffBuf, 0, diffSize));
        diffIn.skip(8L);
        long ctrlBlockLen = diffIn.readLong();
        long diffBlockLen = diffIn.readLong();
        int newsize = (int)diffIn.readLong();
        diffIn.close();
        ByteArrayInputStream in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(32L);
        DataInputStream ctrlBlockIn = new DataInputStream(new GZIPInputStream(in));
        in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(ctrlBlockLen + 32L);
        GZIPInputStream diffBlockIn = new GZIPInputStream(in);
        in = new ByteArrayInputStream(diffBuf, 0, diffSize);
        ((InputStream)in).skip(diffBlockLen + ctrlBlockLen + 32L);
        GZIPInputStream extraBlockIn = new GZIPInputStream(in);
        byte[] newBuf = new byte[newsize];
        int oldpos = 0;
        int newpos = 0;
        int[] ctrl = new int[3];
        while (newpos < newsize) {
            int i;
            for (i = 0; i <= 2; ++i) {
                ctrl[i] = ctrlBlockIn.readInt();
            }
            if (newpos + ctrl[0] > newsize) {
                throw new IOException("Corrupt by wrong patch file.");
            }
            if (!BSUtil.readFromStream(diffBlockIn, newBuf, newpos, ctrl[0])) {
                throw new IOException("Corrupt by wrong patch file.");
            }
            for (i = 0; i < ctrl[0]; ++i) {
                if (oldpos + i < 0 || oldpos + i >= oldsize) continue;
                int n = newpos + i;
                newBuf[n] = (byte)(newBuf[n] + oldBuf[oldpos + i]);
            }
            oldpos += ctrl[0];
            if ((newpos += ctrl[0]) + ctrl[1] > newsize) {
                throw new IOException("Corrupt by wrong patch file.");
            }
            if (!BSUtil.readFromStream(extraBlockIn, newBuf, newpos, ctrl[1])) {
                throw new IOException("Corrupt by wrong patch file.");
            }
            newpos += ctrl[1];
            oldpos += ctrl[2];
        }
        ctrlBlockIn.close();
        ((InputStream)diffBlockIn).close();
        ((InputStream)extraBlockIn).close();
        return newBuf;
    }
}

