/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.queue;

import com.stoyanr.evictor.EvictionQueue;
import com.stoyanr.evictor.map.EvictibleEntry;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public class PriorityEvictionQueue<K, V>
implements EvictionQueue<K, V> {
    private final Queue<EvictibleEntry<K, V>> queue;

    public PriorityEvictionQueue(int initialCapacity) {
        this(new PriorityBlockingQueue<EvictibleEntry<K, V>>(initialCapacity, new EvictibleEntryComparator()));
    }

    public PriorityEvictionQueue(Queue<EvictibleEntry<K, V>> queue) {
        if (queue == null) {
            throw new NullPointerException("Queue instance cannot be null");
        }
        this.queue = queue;
    }

    @Override
    public boolean hasEntries() {
        return !this.queue.isEmpty();
    }

    @Override
    public long getNextEvictionTime() {
        try {
            return !this.queue.isEmpty() ? this.queue.peek().getEvictionTime() : 0L;
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    @Override
    public void putEntry(EvictibleEntry<K, V> e) {
        this.queue.add(e);
    }

    @Override
    public void removeEntry(EvictibleEntry<K, V> e) {
        this.queue.remove(e);
    }

    @Override
    public boolean evictEntries() {
        boolean result = false;
        try {
            while (!this.queue.isEmpty() && this.queue.peek().getEvictionTime() < System.nanoTime()) {
                this.queue.poll().evict(false);
                result = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    public static class EvictibleEntryComparator<K, V>
    implements Comparator<EvictibleEntry<K, V>> {
        @Override
        public int compare(EvictibleEntry<K, V> entry1, EvictibleEntry<K, V> entry2) {
            long time2;
            long time1 = entry1.getEvictionTime();
            if (time1 > (time2 = entry2.getEvictionTime())) {
                return 1;
            }
            if (time1 < time2) {
                return -1;
            }
            return 0;
        }
    }
}

