/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.auth.gcr;

import com.google.api.client.util.Clock;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerRegistryAuthSupplier
implements RegistryAuthSupplier {
    private static final Logger log = LoggerFactory.getLogger(ContainerRegistryAuthSupplier.class);
    private static final Set<String> GCR_REGISTRIES = ImmutableSet.of((Object)"gcr.io", (Object)"us.gcr.io", (Object)"eu.gcr.io", (Object)"asia.gcr.io", (Object)"b.gcr.io", (Object)"bucket.gcr.io", (Object[])new String[]{"l.gcr.io", "launcher.gcr.io", "appengine.gcr.io", "us-mirror.gcr.io", "eu-mirror.gcr.io", "asia-mirror.gcr.io", "mirror.gcr.io"});
    private final GoogleCredentials credentials;
    private final Clock clock;
    private final long minimumExpiryMillis;
    private final CredentialRefresher credentialRefresher;

    public static Builder fromStream(InputStream credentialsStream) throws IOException {
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
        return new Builder(credentials);
    }

    public static Builder forApplicationDefaultCredentials() throws IOException {
        return new Builder(GoogleCredentials.getApplicationDefault());
    }

    public static Builder forCredentials(GoogleCredentials credentials) {
        return new Builder(credentials);
    }

    @VisibleForTesting
    ContainerRegistryAuthSupplier(GoogleCredentials credentials, Clock clock, long minimumExpiryMillis, CredentialRefresher credentialRefresher) {
        this.credentials = credentials;
        this.clock = clock;
        this.minimumExpiryMillis = minimumExpiryMillis;
        this.credentialRefresher = credentialRefresher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessToken getAccessToken() throws IOException {
        GoogleCredentials googleCredentials = this.credentials;
        synchronized (googleCredentials) {
            if (this.needsRefresh(this.credentials.getAccessToken())) {
                this.credentialRefresher.refresh(this.credentials);
            }
        }
        return this.credentials.getAccessToken();
    }

    private boolean needsRefresh(AccessToken accessToken) {
        if (accessToken == null) {
            return true;
        }
        long expiresIn = this.credentials.getAccessToken().getExpirationTime().getTime() - this.clock.currentTimeMillis();
        return expiresIn <= this.minimumExpiryMillis;
    }

    @Override
    public RegistryAuth authFor(String imageName) throws DockerException {
        AccessToken accessToken;
        String[] imageParts = imageName.split("/", 2);
        if (imageParts.length < 2 || !GCR_REGISTRIES.contains(imageParts[0])) {
            return null;
        }
        try {
            accessToken = this.getAccessToken();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        return this.authForAccessToken(accessToken);
    }

    private RegistryAuth authForAccessToken(AccessToken accessToken) {
        return RegistryAuth.builder().username("oauth2accesstoken").password(accessToken.getTokenValue()).build();
    }

    @Override
    public RegistryAuth authForSwarm() throws DockerException {
        AccessToken accessToken;
        try {
            accessToken = this.getAccessToken();
        }
        catch (IOException e) {
            log.warn("unable to get access token for Google Container Registry due to exception, configuration for Swarm will not contain RegistryAuth for GCR", (Throwable)e);
            return null;
        }
        return this.authForAccessToken(accessToken);
    }

    @Override
    public RegistryConfigs authForBuild() throws DockerException {
        AccessToken accessToken;
        try {
            accessToken = this.getAccessToken();
        }
        catch (IOException e) {
            log.warn("unable to get access token for Google Container Registry, configuration for building image will not contain RegistryAuth for GCR", (Throwable)e);
            return RegistryConfigs.empty();
        }
        HashMap<String, RegistryAuth> configs = new HashMap<String, RegistryAuth>(GCR_REGISTRIES.size());
        for (String serverName : GCR_REGISTRIES) {
            configs.put(serverName, this.authForAccessToken(accessToken));
        }
        return RegistryConfigs.create(configs);
    }

    private static class DefaultCredentialRefresher
    implements CredentialRefresher {
        private DefaultCredentialRefresher() {
        }

        @Override
        public void refresh(GoogleCredentials credentials) throws IOException {
            credentials.refresh();
        }
    }

    @VisibleForTesting
    static interface CredentialRefresher {
        public void refresh(GoogleCredentials var1) throws IOException;
    }

    public static class Builder {
        private final GoogleCredentials credentials;
        private Collection<String> scopes = ImmutableList.of((Object)"https://www.googleapis.com/auth/devstorage.read_write");
        private long minimumExpiryMillis = TimeUnit.MINUTES.toMillis(1L);

        public Builder(GoogleCredentials credentials) {
            this.credentials = credentials;
        }

        public Builder withScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder withMinimumExpiry(long duration, TimeUnit timeUnit) {
            this.minimumExpiryMillis = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
            return this;
        }

        public ContainerRegistryAuthSupplier build() {
            GoogleCredentials credentials = this.credentials.createScoped(this.scopes);
            if (credentials instanceof ServiceAccountCredentials) {
                String clientEmail = ((ServiceAccountCredentials)credentials).getClientEmail();
                log.info("loaded credentials for service account with clientEmail={}", (Object)clientEmail);
            } else if (credentials instanceof UserCredentials) {
                String clientId = ((UserCredentials)credentials).getClientId();
                log.info("loaded credentials for user account with clientId={}", (Object)clientId);
            }
            Clock clock = Clock.SYSTEM;
            DefaultCredentialRefresher refresher = new DefaultCredentialRefresher();
            return new ContainerRegistryAuthSupplier(credentials, clock, this.minimumExpiryMillis, refresher);
        }
    }
}

