/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptorUtil;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Collections;
import java.util.Set;

public abstract class MethodFilterInterceptor
extends AbstractInterceptor {
    protected transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected Set excludeMethods = Collections.EMPTY_SET;
    protected Set includeMethods = Collections.EMPTY_SET;

    public void setExcludeMethods(String excludeMethods) {
        this.excludeMethods = TextParseUtil.commaDelimitedStringToSet(excludeMethods);
    }

    public Set getExcludeMethodsSet() {
        return this.excludeMethods;
    }

    public void setIncludeMethods(String includeMethods) {
        this.includeMethods = TextParseUtil.commaDelimitedStringToSet(includeMethods);
    }

    public Set getIncludeMethodsSet() {
        return this.includeMethods;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (this.applyInterceptor(invocation)) {
            return this.doIntercept(invocation);
        }
        return invocation.invoke();
    }

    protected boolean applyInterceptor(ActionInvocation invocation) {
        String method = invocation.getProxy().getMethod();
        boolean applyMethod = MethodFilterInterceptorUtil.applyMethod(this.excludeMethods, this.includeMethods, method);
        if (this.log.isDebugEnabled() && !applyMethod) {
            this.log.debug("Skipping Interceptor... Method [" + method + "] found in exclude list.", new String[0]);
        }
        return applyMethod;
    }

    protected abstract String doIntercept(ActionInvocation var1) throws Exception;
}

