/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class ActionChainResult
implements Result {
    private static final Logger LOG = LoggerFactory.getLogger(ActionChainResult.class);
    public static final String DEFAULT_PARAM = "actionName";
    private static final String CHAIN_HISTORY = "CHAIN_HISTORY";
    public static final String SKIP_ACTIONS_PARAM = "skipActions";
    private ActionProxy proxy;
    private String actionName;
    private String namespace;
    private String methodName;
    private String skipActions;
    private ActionProxyFactory actionProxyFactory;

    public ActionChainResult() {
    }

    public ActionChainResult(String namespace, String actionName, String methodName) {
        this.namespace = namespace;
        this.actionName = actionName;
        this.methodName = methodName;
    }

    public ActionChainResult(String namespace, String actionName, String methodName, String skipActions) {
        this.namespace = namespace;
        this.actionName = actionName;
        this.methodName = methodName;
        this.skipActions = skipActions;
    }

    @Inject
    public void setActionProxyFactory(ActionProxyFactory actionProxyFactory) {
        this.actionProxyFactory = actionProxyFactory;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSkipActions(String actions) {
        this.skipActions = actions;
    }

    public void setMethod(String method) {
        this.methodName = method;
    }

    public ActionProxy getProxy() {
        return this.proxy;
    }

    public static LinkedList getChainHistory() {
        LinkedList chainHistory = (LinkedList)ActionContext.getContext().get(CHAIN_HISTORY);
        if (chainHistory == null) {
            chainHistory = new LinkedList();
            ActionContext.getContext().put(CHAIN_HISTORY, chainHistory);
        }
        return chainHistory;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        String finalMethodName;
        if (this.namespace == null) {
            this.namespace = invocation.getProxy().getNamespace();
        }
        ValueStack stack = ActionContext.getContext().getValueStack();
        String finalNamespace = TextParseUtil.translateVariables(this.namespace, stack);
        String finalActionName = TextParseUtil.translateVariables(this.actionName, stack);
        String string = finalMethodName = this.methodName != null ? TextParseUtil.translateVariables(this.methodName, stack) : null;
        if (this.isInChainHistory(finalNamespace, finalActionName, finalMethodName)) {
            this.addToHistory(finalNamespace, finalActionName, finalMethodName);
            throw new XWorkException("Infinite recursion detected: " + ActionChainResult.getChainHistory().toString());
        }
        if (ActionChainResult.getChainHistory().isEmpty() && invocation != null && invocation.getProxy() != null) {
            this.addToHistory(finalNamespace, invocation.getProxy().getActionName(), invocation.getProxy().getMethod());
        }
        this.addToHistory(finalNamespace, finalActionName, finalMethodName);
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", ActionContext.getContext().getValueStack());
        extraContext.put("com.opensymphony.xwork2.ActionContext.parameters", ActionContext.getContext().getParameters());
        extraContext.put(CHAIN_HISTORY, ActionChainResult.getChainHistory());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Chaining to action " + finalActionName, new String[0]);
        }
        this.proxy = this.actionProxyFactory.createActionProxy(finalNamespace, finalActionName, finalMethodName, extraContext);
        this.proxy.execute();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionChainResult that = (ActionChainResult)o;
        if (this.actionName != null ? !this.actionName.equals(that.actionName) : that.actionName != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return !(this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null);
    }

    public int hashCode() {
        int result = this.actionName != null ? this.actionName.hashCode() : 0;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        return result;
    }

    private boolean isInChainHistory(String namespace, String actionName, String methodName) {
        LinkedList chainHistory = ActionChainResult.getChainHistory();
        if (chainHistory == null) {
            return false;
        }
        HashSet skipActionsList = new HashSet();
        if (this.skipActions != null && this.skipActions.length() > 0) {
            ValueStack stack = ActionContext.getContext().getValueStack();
            String finalSkipActions = TextParseUtil.translateVariables(this.skipActions, stack);
            skipActionsList.addAll(TextParseUtil.commaDelimitedStringToSet(finalSkipActions));
        }
        if (!skipActionsList.contains(actionName)) {
            return chainHistory.contains(this.makeKey(namespace, actionName, methodName));
        }
        return false;
    }

    private void addToHistory(String namespace, String actionName, String methodName) {
        LinkedList chainHistory = ActionChainResult.getChainHistory();
        chainHistory.add(this.makeKey(namespace, actionName, methodName));
    }

    private String makeKey(String namespace, String actionName, String methodName) {
        if (null == methodName) {
            return namespace + "/" + actionName;
        }
        return namespace + "/" + actionName + "!" + methodName;
    }
}

