/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.filter;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Request;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterContext<T> {
    private final AsyncHandler<T> asyncHandler;
    private final Request request;
    private final HttpResponseStatus responseStatus;
    private final boolean replayRequest;
    private final IOException ioException;

    public FilterContext(AsyncHandler<T> asyncHandler, Request request) {
        this(asyncHandler, request, null, false, null);
    }

    public FilterContext(AsyncHandler<T> asyncHandler, Request request, IOException ioException) {
        this(asyncHandler, request, null, false, ioException);
    }

    public FilterContext(AsyncHandler<T> asyncHandler, Request request, HttpResponseStatus responseStatus) {
        this(asyncHandler, request, responseStatus, false, null);
    }

    private FilterContext(AsyncHandler<T> asyncHandler, Request request, HttpResponseStatus responseStatus, boolean replayRequest, IOException ioException) {
        this.asyncHandler = asyncHandler;
        this.request = request;
        this.responseStatus = responseStatus;
        this.replayRequest = replayRequest;
        this.ioException = ioException;
    }

    public FilterContext(AsyncHandler<T> asyncHandler, Request request, boolean replayRequest) {
        this(asyncHandler, request, null, replayRequest, null);
    }

    public AsyncHandler<T> getAsyncHandler() {
        return this.asyncHandler;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public boolean replayRequest() {
        return this.replayRequest;
    }

    public IOException getIOException() {
        return this.ioException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterContextBuilder<T> {
        private AsyncHandler<T> asyncHandler = null;
        private Request request = null;
        private HttpResponseStatus responseStatus = null;
        private boolean replayRequest = false;
        private IOException ioException = null;

        public FilterContextBuilder() {
        }

        public FilterContextBuilder(FilterContext clone) {
            this.asyncHandler = clone.getAsyncHandler();
            this.request = clone.getRequest();
            this.responseStatus = clone.getResponseStatus();
            this.replayRequest = clone.replayRequest();
            this.ioException = clone.getIOException();
        }

        public AsyncHandler<T> getAsyncHandler() {
            return this.asyncHandler;
        }

        public FilterContextBuilder asyncHandler(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
            return this;
        }

        public Request getRequest() {
            return this.request;
        }

        public FilterContextBuilder request(Request request) {
            this.request = request;
            return this;
        }

        public HttpResponseStatus getResponseStatus() {
            return this.responseStatus;
        }

        public FilterContextBuilder responseStatus(HttpResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public boolean replayRequest() {
            return this.replayRequest;
        }

        public FilterContextBuilder replayRequest(boolean replayRequest) {
            this.replayRequest = replayRequest;
            return this;
        }

        public IOException getIoException() {
            return this.ioException;
        }

        public FilterContextBuilder ioException(IOException ioException) {
            this.ioException = ioException;
            return this;
        }

        public FilterContext build() {
            return new FilterContext(this.asyncHandler, this.request, this.responseStatus, this.replayRequest, this.ioException);
        }
    }
}

