/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.ReadText;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.lang.jnaerator.runtime.JNAeratorRuntime;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Callback;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaGenerator
implements Result.ClassWritingNotifiable {
    Map<String, ScalaClassFile> outByLib = new LinkedHashMap<String, ScalaClassFile>();
    Result result;
    static final String SCALA_JNAERATOR_RT_CLASS_NAME = "ScalaJNAerator";
    static final String SCALA_JNA_RT_CLASS_NAME = "ScalaJNA";
    static final String SCALA_ROCOCOA_RT_CLASS_NAME = "ScalaRococoa";

    public ScalaGenerator(Result result) throws FileNotFoundException {
        this.result = result;
        result.classWritingNotifiables.add(this);
    }

    @Override
    public Struct writingClass(Identifier fullClassName, Struct interf, Signatures signatures, String currentLibrary) {
        try {
            this.visit(fullClassName, (Element)interf, currentLibrary);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return interf;
    }

    PrintWriter openFile(File f) throws FileNotFoundException {
        File p = f.getAbsoluteFile().getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
        this.result.feedback.setStatus("Generating " + f);
        return new PrintWriter(f);
    }

    StringWriter getLibOut(String pack, String lib) throws FileNotFoundException {
        ScalaClassFile out = this.outByLib.get(lib);
        if (out == null) {
            out = new ScalaClassFile();
            this.outByLib.put(lib, out);
            out.name = this.getLibScalaClassName(lib);
            out.path = pack.replace('.', '/').replace('\\', '/') + '/' + StringUtils.capitalize((String)lib) + ".scala";
        }
        return out.content;
    }

    private String getLibScalaClassName(String lib) {
        return lib;
    }

    private void visit(Identifier fullClassName, Element interf, String currentLibrary) throws FileNotFoundException {
        final Identifier pack = fullClassName.resolveAllButLastIdentifier();
        String spack = this.result.getLibraryPackage(currentLibrary).toString();
        final PrintWriter out = new PrintWriter(this.getLibOut(spack, currentLibrary));
        interf.accept((Visitor)new Scanner(){
            Stack<Identifier> path = new Stack();
            {
                this.path.add(pack);
            }

            public void visitStruct(Struct struct) {
                this.path.push(ElementsHelper.ident((Identifier)this.path.peek(), (Identifier[])new Identifier[]{struct.getTag()}));
                super.visitStruct(struct);
                this.path.pop();
            }

            public void visitJavaInterface(Struct struct) {
                super.visitJavaInterface(struct);
                if (struct.getParents().contains(ElementsHelper.ident(Callback.class, (Expression[])new Expression[0]))) {
                    Function f = null;
                    for (Declaration d : struct.getDeclarations()) {
                        if (!(d instanceof Function)) continue;
                        f = (Function)d;
                        break;
                    }
                    if (f != null) {
                        List args = f.getArgs();
                        ArrayList<String> argTypes = new ArrayList<String>();
                        ArrayList<String> argNames = new ArrayList<String>();
                        ArrayList<String> argDefs = new ArrayList<String>();
                        String rt = ScalaGenerator.this.getScalaType(f.getValueType());
                        for (Arg a : args) {
                            String vt = ScalaGenerator.this.getScalaType(a.getValueType());
                            String n = a.getName();
                            argTypes.add(vt);
                            argNames.add(n);
                            argDefs.add(n + ": " + vt);
                        }
                        String cbClassName = struct.getTag().toString();
                        String scbClassName = cbClassName + "_scala";
                        String cbClassPath = this.path.peek().toString();
                        int ac = argTypes.size();
                        String fsig = (ac == 0 ? "" : (ac == 1 ? (String)argTypes.get(0) : "(" + StringUtils.implode(argTypes, (Object)", ") + ")")) + " => " + rt;
                        out.println("class " + scbClassName + "(scala_func: " + fsig + ") extends " + cbClassPath + " {");
                        out.println("\toverride def " + f.getName() + "(" + StringUtils.implode(argDefs, (Object)", ") + "): " + rt + " = {");
                        out.println("\t\tscala_func(" + StringUtils.implode(argNames, (Object)", ") + ")");
                        out.println("\t}");
                        out.println("}");
                        out.println("implicit def scala_func2" + scbClassName + "(scala_func: " + fsig + ") = {");
                        out.println("\tnew " + scbClassName + "(scala_func)");
                        out.println("}");
                    }
                }
            }
        });
        out.flush();
    }

    protected String getScalaType(TypeRef valueType) {
        String vt = valueType.toString();
        if (vt.equals("void")) {
            vt = "Unit";
        }
        return vt;
    }

    public void jnaerationCompleted() throws IOException {
        ArrayList<String> availableLibs = new ArrayList<String>();
        for (Map.Entry<String, ScalaClassFile> e : this.outByLib.entrySet()) {
            ScalaClassFile f = e.getValue();
            String lib = e.getKey();
            f.content.close();
            String s = f.content.toString().trim();
            if (s.length() == 0) continue;
            availableLibs.add(lib);
            PrintWriter out = this.openFile(new File(this.result.config.scalaOut, f.path));
            out.println("trait " + f.name + " extends " + this.result.getLibraryClassFullName(lib) + " {");
            out.println(s);
            out.println("}");
            out.close();
        }
        this.outputSampleScalaSource(availableLibs);
        this.outputScalaRuntime(availableLibs);
    }

    URL getScalaPartResource(String name) throws IOException {
        String path = "com/ochafik/lang/jnaerator/runtime/scala/" + name + ".scala.part";
        URL url = JNAeratorRuntime.class.getClassLoader().getResource(path);
        return url;
    }

    private void outputScalaRuntime(List<String> availableLibs) throws IOException {
        PrintWriter out = this.openFile(new File(this.result.config.scalaOut, "ScalaJNAerator.scala"));
        out.println(ReadText.readText((URL)this.getScalaPartResource(SCALA_JNA_RT_CLASS_NAME)));
        boolean objc = this.result.hasObjectiveC();
        if (objc) {
            out.println(ReadText.readText((URL)this.getScalaPartResource(SCALA_ROCOCOA_RT_CLASS_NAME)));
        }
        out.print("trait ScalaJNAerator extends ScalaJNA");
        if (objc) {
            out.print(" with ScalaRococoa");
        }
        out.close();
    }

    private void outputSampleScalaSource(List<String> availableLibs) throws FileNotFoundException {
        PrintWriter out = this.openFile(new File(this.result.config.scalaOut, "JNAeratorSample.scala"));
        out.println("import com.sun.jna._;");
        out.println("import com.sun.jna.ptr._;");
        if (this.result.hasObjectiveC()) {
            out.println("import org.rococoa._;");
        }
        out.println();
        out.println("import com.ochafik.lang.jnaerator.runtime._;");
        out.println("import com.ochafik.lang.jnaerator.runtime.globals._;");
        out.println();
        out.println("import ScalaJNAerator._;");
        for (String lib : availableLibs) {
            String scn = this.getLibScalaClassName(lib);
            out.println("import " + scn + "._;");
        }
        out.println();
        out.println("object ExampleApp extends Application {");
        out.println("  override def main(args : Array[String]) : Unit = {");
        out.println("    ");
        out.println("  }");
        out.println("}");
        out.close();
    }

    class ScalaClassFile {
        public String path;
        public String name;
        public StringWriter content = new StringWriter();

        ScalaClassFile() {
        }
    }
}

