/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.BridJer;
import com.ochafik.lang.jnaerator.ClassOutputter;
import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.GlobalsGenerator;
import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.ObjectiveCGenerator;
import com.ochafik.lang.jnaerator.Reifier;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.Symbols;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UniversalReconciliator;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Namespace;
import com.ochafik.lang.jnaerator.parser.Printer;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.SystemUtils;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Platform;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rococoa.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends Scanner {
    public final JNAeratorConfig config;
    public final JNAerator.Feedback feedback;
    public final ClassOutputter classOutputter;
    public TypeConversion typeConverter;
    public DeclarationsConverter declarationsConverter;
    public GlobalsGenerator globalsGenerator;
    public ObjectiveCGenerator objectiveCGenerator;
    public UniversalReconciliator universalReconciliator;
    public Reifier reifier;
    public BridJer bridjer;
    public Symbols symbols;
    public boolean hasCPlusPlus;
    public final Set<Identifier> structsFullNames = new HashSet<Identifier>();
    public final Set<Identifier> enumsFullNames = new HashSet<Identifier>();
    public final Set<Identifier> unionsFullNames = new HashSet<Identifier>();
    public final Set<Identifier> callbacksFullNames = new HashSet<Identifier>();
    public final Set<Identifier> objectiveCClassesFullNames = new HashSet<Identifier>();
    Set<Identifier> javaPackages = new TreeSet<Identifier>();
    Map<Struct.Type, Map<Identifier, Struct>> classes = new TreeMap<Struct.Type, Map<Identifier, Struct>>();
    Map<Identifier, Map<String, Struct>> objCCategoriesByTargetType = new LinkedHashMap<Identifier, Map<String, Struct>>();
    Map<String, Struct> objCCategoriesByName = new LinkedHashMap<String, Struct>();
    Map<String, Map<String, String>> stringConstants = new LinkedHashMap<String, Map<String, String>>();
    Map<String, Map<String, Boolean>> retainedRetValFunctions = new LinkedHashMap<String, Map<String, Boolean>>();
    public Map<String, List<String>> missingPointersByUsingLibrary = new LinkedHashMap<String, List<String>>();
    public Map<String, List<Struct>> structsByLibrary = new LinkedHashMap<String, List<Struct>>();
    public Map<String, List<TypeRef.FunctionSignature>> callbacksByLibrary = new LinkedHashMap<String, List<TypeRef.FunctionSignature>>();
    public Map<String, List<VariablesDeclaration>> globalsByLibrary = new LinkedHashMap<String, List<VariablesDeclaration>>();
    public Map<Identifier, VariablesDeclaration> globalVariablesByName = new LinkedHashMap<Identifier, VariablesDeclaration>();
    public Map<Identifier, Struct> structsByName = new LinkedHashMap<Identifier, Struct>();
    public Map<Identifier, TypeRef.FunctionSignature> callbacksByName = new LinkedHashMap<Identifier, TypeRef.FunctionSignature>();
    public Map<String, List<Enum>> enumsByLibrary = new LinkedHashMap<String, List<Enum>>();
    public Map<Identifier, Enum> enumsByName = new LinkedHashMap<Identifier, Enum>();
    public Map<String, Enum.EnumItem> enumItems = new LinkedHashMap<String, Enum.EnumItem>();
    public Map<String, Define> defines = new LinkedHashMap<String, Define>();
    public Map<String, List<Define>> definesByLibrary = new LinkedHashMap<String, List<Define>>();
    public Map<String, Set<String>> fakePointersByLibrary = new LinkedHashMap<String, Set<String>>();
    public Map<String, Set<String>> undefinedTypesByLibrary = new LinkedHashMap<String, Set<String>>();
    public Map<String, List<Function>> functionsByLibrary = new LinkedHashMap<String, List<Function>>();
    public Map<Identifier, Signatures> signaturesByOutputClass = new LinkedHashMap<Identifier, Signatures>();
    public Map<String, Pair<StoredDeclarations.TypeDef, Declarator>> typeDefs = new LinkedHashMap<String, Pair<StoredDeclarations.TypeDef, Declarator>>();
    Map<Identifier, List<Pair<Identifier, Function>>> functionsReifiableInFakePointers = new LinkedHashMap<Identifier, List<Pair<Identifier, Function>>>();
    Set<Identifier> resolvedFakePointers = new HashSet<Identifier>();
    Set<Identifier> resolvedUndefinedTypes = new HashSet<Identifier>();
    private static Pattern frameworkPathPattern = Pattern.compile(".*/(\\w+)\\.framework/(?:.*/)?Headers/(?:.*/)?([^/]+)\\.[^/.]+$");
    private static Pattern bridgesupportFrameworkPattern = Pattern.compile("(?:^|/)(\\w+?)(?:Full)?\\.bridgesupport$");
    Stack<Identifier> currentNamespace = new Stack();
    Set<String> libraries = new HashSet<String>();
    Map<String, Identifier> javaPackageByLibrary = new LinkedHashMap<String, Identifier>();
    public Set<Identifier> enumItemsFullName = new HashSet<Identifier>();
    Class<?>[] overwrittenClassesThatNeedToKeepAllTheirMethods = new Class[]{NSObject.class};
    public List<ClassWritingNotifiable> classWritingNotifiables = new ArrayList<ClassWritingNotifiable>();
    public final Map<String, TypeRef> weakTypeDefs = new LinkedHashMap<String, TypeRef>();
    Map<String, TypeRef> manualTypeDefs = new LinkedHashMap<String, TypeRef>();
    Map<String, TypeConversion.JavaPrim> javaPrims = new TreeMap<String, TypeConversion.JavaPrim>();

    public Result(JNAeratorConfig config, ClassOutputter classOutputter, JNAerator.Feedback feedback) {
        if (config == null) {
            throw new IllegalArgumentException("No config in result !");
        }
        this.config = config;
        this.classOutputter = classOutputter;
        this.feedback = feedback;
        this.init();
    }

    public void init() {
        this.declarationsConverter = this.config.runtime.createDeclarationsConverter(this);
        this.globalsGenerator = this.config.runtime.createGlobalsGenerator(this);
        this.typeConverter = this.config.runtime.createTypeConversion(this);
        this.reifier = new Reifier(this);
        this.objectiveCGenerator = new ObjectiveCGenerator(this);
        this.universalReconciliator = new UniversalReconciliator();
        this.bridjer = new BridJer(this);
    }

    static <T> List<T> getList(Map<String, List<T>> m, String key) {
        List<T> list = m.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            m.put(key, list);
        }
        return list;
    }

    static <T, U, V> Map<U, V> getMap(Map<T, Map<U, V>> m, T key) {
        Map<U, V> map = m.get(key);
        if (map == null) {
            map = new LinkedHashMap<U, V>();
            m.put(key, map);
        }
        return map;
    }

    public Identifier findFakePointer(Identifier name) {
        if ((name = this.getFakePointerName(name)) == null) {
            return null;
        }
        String s = name.toString();
        for (Map.Entry<String, Set<String>> e : this.fakePointersByLibrary.entrySet()) {
            if (!e.getValue().contains(s)) continue;
            return ElementsHelper.ident((Identifier)ElementsHelper.ident((String[])new String[]{e.getKey()}), (Identifier[])new Identifier[]{name});
        }
        return null;
    }

    public Identifier findUndefinedType(Identifier name) {
        if ((name = this.getUndefinedTypeName(name)) == null) {
            return null;
        }
        String s = name.toString();
        for (Map.Entry<String, Set<String>> e : this.undefinedTypesByLibrary.entrySet()) {
            if (!e.getValue().contains(s)) continue;
            return ElementsHelper.ident((Identifier)ElementsHelper.ident((String[])new String[]{e.getKey()}), (Identifier[])new Identifier[]{name});
        }
        return null;
    }

    public boolean isFakePointer(Identifier id) {
        return this.resolvedFakePointers.contains(id);
    }

    public boolean isUndefinedType(Identifier id) {
        return this.resolvedUndefinedTypes.contains(id);
    }

    public boolean isUndefinedType(TypeRef tpe) {
        return tpe instanceof TypeRef.SimpleTypeRef && this.isUndefinedType(((TypeRef.SimpleTypeRef)tpe).getName());
    }

    public Identifier getFakePointer(Identifier libraryToUseIfNotDefinedYet, Identifier name) {
        Identifier lib = this.findFakePointer(name);
        if (lib != null) {
            return lib;
        }
        name = this.getFakePointerName(name);
        Set<String> set = this.fakePointersByLibrary.get(libraryToUseIfNotDefinedYet);
        if (set == null && libraryToUseIfNotDefinedYet != null) {
            set = new HashSet<String>();
            this.fakePointersByLibrary.put(libraryToUseIfNotDefinedYet.toString(), set);
        }
        set.add(name.toString());
        Identifier id = libraryToUseIfNotDefinedYet == null ? ElementsHelper.ident((Identifier)name, (Identifier[])new Identifier[0]) : ElementsHelper.ident((Identifier)libraryToUseIfNotDefinedYet, (Identifier[])new Identifier[]{name});
        this.resolvedFakePointers.add(id);
        return id;
    }

    public Identifier getUndefinedType(Identifier libraryToUseIfNotDefinedYet, Identifier name) {
        Identifier lib = this.findUndefinedType(name);
        if (lib != null) {
            return lib;
        }
        name = this.getUndefinedTypeName(name);
        Set<String> set = this.undefinedTypesByLibrary.get(libraryToUseIfNotDefinedYet);
        if (set == null) {
            set = new HashSet<String>();
            this.undefinedTypesByLibrary.put(libraryToUseIfNotDefinedYet.toString(), set);
        }
        set.add(name.toString());
        Identifier id = ElementsHelper.ident((Identifier)libraryToUseIfNotDefinedYet, (Identifier[])new Identifier[]{name});
        this.resolvedUndefinedTypes.add(id);
        return id;
    }

    private Identifier getFakePointerName(Identifier name) {
        TypeRef targetType;
        String target;
        String nicerName;
        Pair<StoredDeclarations.TypeDef, Declarator> pair;
        String nameStr = name == null ? null : name.toString();
        String trimmed = StringUtils.trimUnderscores((String)nameStr);
        if (trimmed != null && !nameStr.equals(trimmed) && (pair = this.typeDefs.get(nicerName = trimmed)) != null && ((target = (targetType = ((StoredDeclarations.TypeDef)pair.getFirst()).getValueType()).toString()).equals(nameStr + "*") || target.equals(nameStr))) {
            nameStr = nicerName;
            name = ElementsHelper.ident((String[])new String[]{nameStr});
        }
        return name;
    }

    private Identifier getUndefinedTypeName(Identifier name) {
        String target;
        String nicerName;
        Pair<StoredDeclarations.TypeDef, Declarator> pair;
        String nameStr = name == null ? null : name.toString();
        String trimmed = StringUtils.trimUnderscores((String)nameStr);
        if (trimmed != null && !nameStr.equals(trimmed) && (pair = this.typeDefs.get(nicerName = trimmed)) != null && (target = ((StoredDeclarations.TypeDef)pair.getFirst()).getValueType().toString()).equals(nameStr)) {
            nameStr = nicerName;
            name = ElementsHelper.ident((String[])new String[]{nameStr});
        }
        return name;
    }

    public Signatures getSignaturesForOutputClass(Identifier name) {
        Signatures s = this.signaturesByOutputClass.get(name);
        if (s == null) {
            s = new Signatures();
            this.signaturesByOutputClass.put(name, s);
        }
        return s;
    }

    public void visitDefine(Define define) {
        super.visitDefine(define);
        this.defines.put(define.getName(), define);
        Result.getList(this.definesByLibrary, this.getLibrary((Element)define)).add(define);
    }

    public void visitEnum(Enum e) {
        String simpleTypeStr;
        StoredDeclarations.TypeDef typeDef;
        TypeRef type;
        Element nextDeclaration;
        super.visitEnum(e);
        if (e.getTag() == null && (nextDeclaration = e.getNextSibling()) != null && nextDeclaration instanceof StoredDeclarations.TypeDef && (type = (typeDef = (StoredDeclarations.TypeDef)nextDeclaration).getValueType()) instanceof TypeRef.SimpleTypeRef && ((simpleTypeStr = ((TypeRef.SimpleTypeRef)type).getName().toString()).equals("NSUInteger") || simpleTypeStr.equals("NSInteger") || simpleTypeStr.equals("CFIndex"))) {
            Declarator bestPlainStorage = null;
            for (Declarator st : typeDef.getDeclarators()) {
                if (!(st instanceof Declarator.DirectDeclarator)) continue;
                String name = st.resolveName();
                boolean niceName = StringUtils.trimUnderscores((String)name).equals(name);
                if (bestPlainStorage != null && !niceName) continue;
                bestPlainStorage = st;
                if (!niceName) continue;
                break;
            }
            if (bestPlainStorage != null) {
                String name = bestPlainStorage.resolveName();
                System.err.println("Automatic struct name matching : " + name);
                e.setTag(ElementsHelper.ident((String[])new String[]{name}));
            }
        }
        Identifier name = e.getTag();
        String lib = this.getLibrary((Element)e);
        if (name == null) {
            Result.getList(this.enumsByLibrary, lib).add(e);
        } else {
            Enum oldEnum = this.enumsByName.get(name);
            if (Result.declarativePower((TypeRef.TaggedTypeRef)e) > Result.declarativePower((TypeRef.TaggedTypeRef)oldEnum)) {
                Identifier originalName;
                this.enumsByName.put(name, e);
                e.setResolvedJavaIdentifier(this.typeConverter.computeTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)e));
                if (!this.currentNamespace.isEmpty()) {
                    e.setParentNamespace(this.currentNamespace.peek().clone());
                }
                if ((originalName = e.getOriginalTag()) != null) {
                    this.enumsByName.put(originalName, e);
                }
                Result.getList(this.enumsByLibrary, lib).add(e);
                Identifier identifier = this.typeConverter.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)e);
                if (identifier != null) {
                    this.enumsFullNames.add(identifier);
                }
            }
        }
    }

    static int declarativePower(TypeRef.TaggedTypeRef e) {
        if (e == null) {
            return 0;
        }
        int base = e.isForwardDeclaration() ? 0 : 10;
        Element p = e.getParentElement();
        if (p instanceof StoredDeclarations.TypeDef) {
            return base + 4;
        }
        if (p instanceof TaggedTypeRefDeclaration) {
            return base + 3;
        }
        return base + 1;
    }

    public void visitEnumItem(Enum.EnumItem enumItem) {
        super.visitEnumItem(enumItem);
        this.enumItems.put(enumItem.getName(), enumItem);
        String library = this.getLibrary((Element)enumItem);
        if (library == null) {
            return;
        }
        Element parent = enumItem.getParentElement();
        if (parent == null || !(parent instanceof Enum)) {
            return;
        }
        Enum e = (Enum)parent;
        Identifier ident = ElementsHelper.ident((Identifier)this.getLibraryClassFullName(library), (Identifier[])new Identifier[]{this.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)e), ElementsHelper.ident((String[])new String[]{enumItem.getName()})});
        this.enumItemsFullName.add(ident);
    }

    public void visitVariablesDeclaration(VariablesDeclaration v) {
        super.visitVariablesDeclaration(v);
        if (v.findParentOfTypes(new Class[]{Struct.class, Function.class, Enum.class}) != null) {
            return;
        }
        for (Declarator d : v.getDeclarators()) {
            this.globalVariablesByName.put(ElementsHelper.ident((String[])new String[]{d.resolveName()}), v);
        }
        Result.getList(this.globalsByLibrary, this.getLibrary((Element)v)).add(v);
    }

    public void visitTypeDef(StoredDeclarations.TypeDef typeDef) {
        super.visitTypeDef(typeDef);
        for (Declarator vs : typeDef.getDeclarators()) {
            this.typeDefs.put(vs.resolveName(), (Pair<StoredDeclarations.TypeDef, Declarator>)new Pair((Object)typeDef, (Object)vs));
        }
    }

    String guessFramework(String file) {
        Matcher matcher = frameworkPathPattern.matcher(file);
        if (matcher.find() || (matcher = bridgesupportFrameworkPattern.matcher(file)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    String getLibrary(Element decl) {
        SourceFile f;
        String file = this.resolveFile(decl);
        String library = this.config.getLibrary(file, Element.getName((Element)decl));
        if (library == null && (f = (SourceFile)decl.findParentOfType(SourceFile.class)) != null && (library = this.guessFramework(file)) == null) {
            library = f.getLibrary();
        }
        return library;
    }

    public String resolveFile(Element e) {
        String file = null;
        while (e != null && (file = e.getElementFile()) == null) {
            e = e.getParentElement();
        }
        return file;
    }

    public void visitFunction(Function function) {
        super.visitFunction(function);
        Element parent = function.getParentElement();
        if (parent != null) {
            if (parent instanceof TypeRef.FunctionSignature) {
                return;
            }
            if (parent instanceof Struct) {
                Struct parentStruct = (Struct)parent;
                switch (parentStruct.getType()) {
                    case CPPClass: 
                    case JavaClass: 
                    case JavaInterface: 
                    case ObjCClass: 
                    case ObjCProtocol: 
                    case CStruct: {
                        return;
                    }
                }
            }
        }
        Result.getList(this.functionsByLibrary, this.getLibrary((Element)function)).add(function);
    }

    public Expression getLibraryInstanceReferenceExpression(String libraryName) {
        String fieldName;
        Identifier classIdent;
        Identifier hub = this.getHubFullClassName();
        if (hub != null) {
            classIdent = hub;
            fieldName = libraryName;
        } else {
            classIdent = this.getLibraryClassFullName(libraryName);
            fieldName = "INSTANCE";
        }
        return ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)classIdent)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)fieldName);
    }

    public Identifier getHubFullClassName() {
        return this.config.entryName == null ? null : ElementsHelper.ident((String[])new String[]{this.config.entryName.toLowerCase(), this.config.entryName});
    }

    public void visitNamespace(Namespace ns) {
        if (this.currentNamespace.isEmpty()) {
            this.currentNamespace.push(ns.getName());
        } else {
            this.currentNamespace.push((Identifier)this.currentNamespace.peek().derive(Identifier.QualificationSeparator.Colons, new Identifier[]{ns.getName()}));
        }
        try {
            super.visitNamespace(ns);
        }
        finally {
            this.currentNamespace.pop();
        }
    }

    public void visitStruct(Struct struct) {
        Identifier name = struct.getTag();
        if (name != null) {
            switch (struct.getType()) {
                case CPPClass: {
                    if (!this.config.runtime.equals((Object)JNAeratorConfig.Runtime.BridJ) && !this.config.genCPlusPlus) break;
                }
                case CStruct: 
                case CUnion: {
                    Identifier identifier;
                    String lib;
                    Struct p;
                    List parents;
                    boolean isFwd;
                    if (!this.currentNamespace.isEmpty()) {
                        struct.setParentNamespace(this.currentNamespace.peek().clone());
                    }
                    if (!(isFwd = struct.isForwardDeclaration()) && struct.getDeclarations().isEmpty() && this.config.treatEmptyStructsAsForwardDecls && ((parents = struct.getParents()).isEmpty() || parents.size() == 1 && ((p = this.structsByName.get(parents.get(0))) == null || p.isForwardDeclaration()))) {
                        isFwd = true;
                    }
                    if (isFwd || this.config.skipIncludedFrameworks && (lib = this.getLibrary((Element)struct)) != null && !this.config.frameworks.contains(lib)) break;
                    Struct oldStruct = this.structsByName.get(name);
                    if (Result.declarativePower((TypeRef.TaggedTypeRef)struct) <= Result.declarativePower((TypeRef.TaggedTypeRef)oldStruct)) break;
                    this.structsByName.put(name, struct);
                    Identifier originalName = struct.getOriginalTag();
                    if (originalName != null) {
                        this.structsByName.put(originalName, struct);
                    }
                    Identifier resolvedJavaIdentifier = this.typeConverter.computeTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)struct);
                    struct.setResolvedJavaIdentifier(resolvedJavaIdentifier);
                    if (struct.findParentOfType(Struct.class) == null) {
                        Result.getList(this.structsByLibrary, this.getLibrary((Element)struct)).add(struct);
                    }
                    if ((identifier = this.typeConverter.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)struct)) == null) break;
                    if (struct.getType() == Struct.Type.CUnion) {
                        this.unionsFullNames.add(identifier);
                    }
                    this.structsFullNames.add(identifier);
                    break;
                }
                case ObjCClass: 
                case ObjCProtocol: {
                    if (struct.isForwardDeclaration()) break;
                    if (struct.getCategoryName() != null) {
                        Result.getMap(this.objCCategoriesByTargetType, struct.getTag()).put(struct.getCategoryName(), struct);
                        this.objCCategoriesByName.put(struct.getCategoryName(), struct);
                    } else {
                        Result.getMap(this.classes, struct.getType()).put(struct.getTag(), struct);
                    }
                    Identifier fullName = this.objectiveCGenerator.getFullClassName(struct);
                    this.objectiveCClassesFullNames.add(fullName);
                    struct.setResolvedJavaIdentifier(fullName);
                    break;
                }
                default: {
                    struct = null;
                }
            }
        }
        super.visitStruct(struct);
    }

    public void visitFunctionSignature(TypeRef.FunctionSignature functionSignature) {
        super.visitFunctionSignature(functionSignature);
        Function function = functionSignature.getFunction();
        Identifier name = this.typeConverter.inferCallBackName(functionSignature, false, false, null);
        Identifier identifier = this.typeConverter.computeCallbackIdentifierInJava(functionSignature);
        functionSignature.setResolvedJavaIdentifier(identifier);
        if (function != null) {
            if (functionSignature.findParentOfType(Struct.class) == null) {
                Result.getList(this.callbacksByLibrary, this.getLibrary((Element)functionSignature)).add(functionSignature);
            }
            if (name != null) {
                this.callbacksByName.put(name, functionSignature);
                if (identifier != null) {
                    this.callbacksFullNames.add(identifier);
                }
            }
        }
    }

    static String camelCase(String name) {
        StringBuilder out = new StringBuilder();
        for (String s : name.split("[^\\w]+")) {
            String t = s.trim();
            if (t.length() <= 0) continue;
            out.append(StringUtils.capitalize((String)t));
        }
        return out.toString();
    }

    public Identifier getLibraryClassSimpleName(String library) {
        return ElementsHelper.ident((String[])new String[]{Result.camelCase(library) + "Library"});
    }

    public Identifier getLibraryClassFullName(String library) {
        return ElementsHelper.ident((Identifier)this.getLibraryPackage(library), (Identifier[])new Identifier[]{this.getLibraryClassSimpleName(library)});
    }

    public Identifier getLibraryDeclarationsClassSimpleName(String library) {
        if (this.config.runtime != JNAeratorConfig.Runtime.BridJ) {
            return null;
        }
        String name = this.config.extractedLibraries.get(library);
        if (name == null) {
            return null;
        }
        return ElementsHelper.ident((String[])new String[]{name});
    }

    public Identifier getLibraryDeclarationsClassFullName(String library) {
        Identifier name = this.getLibraryDeclarationsClassSimpleName(library);
        return name == null ? null : ElementsHelper.ident((Identifier)this.getLibraryPackage(library), (Identifier[])new Identifier[]{name});
    }

    public String getLibraryFileExpression(String library) {
        Class platformClass;
        Class clazz = platformClass = this.config.runtime.hasJNA ? Platform.class : SystemUtils.class;
        if (library.equals("c")) {
            return "(" + platformClass.getName() + ".isWindows() ? \"msvcrt\" : \"c\")";
        }
        return "\"" + library + "\"";
    }

    public Identifier getLibraryPackage(String library) {
        if (library == null) {
            return null;
        }
        return this.config.packageName == null ? ElementsHelper.ident((Identifier)ElementsHelper.ident((String[])new String[]{this.config.rootPackageName}), (String)library.toLowerCase().replaceAll("[^\\w.]", "")) : ElementsHelper.ident((String[])new String[]{this.config.packageName.replaceAll("[^\\w.]", "")});
    }

    public void chooseLibraryClasses(String packageName, String rootPackageName) {
        this.libraries.clear();
        this.javaPackages.clear();
        this.javaPackageByLibrary.clear();
        this.libraries.addAll(this.structsByLibrary.keySet());
        this.libraries.addAll(this.callbacksByLibrary.keySet());
        this.libraries.addAll(this.functionsByLibrary.keySet());
        this.libraries.addAll(this.enumsByLibrary.keySet());
        this.libraries.addAll(this.globalsByLibrary.keySet());
        this.libraries.addAll(this.definesByLibrary.keySet());
        this.libraries.addAll(this.stringConstants.keySet());
        for (String library : this.libraries) {
            Identifier javaPackage = this.getLibraryPackage(library);
            if (javaPackage == null) continue;
            this.javaPackageByLibrary.put(library, javaPackage);
        }
        this.javaPackages.addAll(this.javaPackageByLibrary.values());
    }

    public Struct resolveObjCClass(Identifier name) {
        if (name == null) {
            return null;
        }
        Struct s = Result.getMap(this.classes, Struct.Type.ObjCClass).get(name);
        if (s == null) {
            s = Result.getMap(this.classes, Struct.Type.ObjCProtocol).get(name);
        }
        if (s == null) {
            s = this.objCCategoriesByName.get(name.toString());
        }
        return s;
    }

    public void addFunctionReifiableInFakePointer(Identifier resolvedFakePointer, Identifier libraryClassName, Function f) {
        List<Pair<Identifier, Function>> list = this.functionsReifiableInFakePointers.get(resolvedFakePointer);
        if (list == null) {
            list = new ArrayList<Pair<Identifier, Function>>();
            this.functionsReifiableInFakePointers.put(resolvedFakePointer, list);
        }
        list.add((Pair<Identifier, Function>)new Pair((Object)libraryClassName, (Object)f));
    }

    public List<Pair<Identifier, Function>> getFunctionsReifiableInFakePointer(Identifier resolvedFakePointer) {
        return this.functionsReifiableInFakePointers.get(resolvedFakePointer);
    }

    public TypeConversion.JavaPrim resolvePrimitive(String name) {
        return name == null ? null : this.javaPrims.get(name);
    }

    private boolean isPrimitive(TypeRef tr) {
        return tr != null && this.javaPrims.containsKey(tr.toString());
    }

    public TypeRef.TaggedTypeRef resolveFullTaggedTypeRef(TypeRef.TaggedTypeRef s) {
        Identifier tag = s.getTag();
        if (tag != null && s.getResolvedJavaIdentifier() == null) {
            TypeRef.TaggedTypeRef rep = null;
            if (s instanceof Struct) {
                rep = (TypeRef.TaggedTypeRef)this.structsByName.get(tag);
            } else if (s instanceof Enum) {
                rep = (TypeRef.TaggedTypeRef)this.enumsByName.get(tag);
            }
            if (rep != null && rep != s) {
                s = rep;
            }
        }
        return s;
    }

    public Struct notifyBeforeWritingClass(Identifier fullClassName, Struct interf, Signatures signatures, String currentLibrary) {
        for (Class<?> c : this.overwrittenClassesThatNeedToKeepAllTheirMethods) {
            if (!fullClassName.equals((Object)c.getName())) continue;
            this.declarationsConverter.addMissingMethods(c, signatures, interf);
            break;
        }
        if (fullClassName.resolveLastSimpleIdentifier().equals((Object)"char")) {
            return null;
        }
        String runtimeSpecificHelp = this.config.runtime == JNAeratorConfig.Runtime.BridJ ? "or <a href=\"http://bridj.googlecode.com/\">BridJ</a> " : ", <a href=\"http://rococoa.dev.java.net/\">Rococoa</a>, or <a href=\"http://jna.dev.java.net/\">JNA</a>";
        interf.addToCommentBefore(new String[]{"This file was autogenerated by <a href=\"http://jnaerator.googlecode.com/\">JNAerator</a>, ", "a tool written by <a href=\"http://ochafik.com/\">Olivier Chafik</a> that <a href=\"http://code.google.com/p/jnaerator/wiki/CreditsAndLicense\">uses a few opensource projects.</a>.", "For help, please visit <a href=\"http://nativelibs4java.googlecode.com/\">NativeLibs4Java</a> " + runtimeSpecificHelp + "."});
        for (ClassWritingNotifiable n : this.classWritingNotifiables) {
            interf = n.writingClass(fullClassName, interf, signatures, currentLibrary);
            if (interf != null) continue;
            return null;
        }
        return interf;
    }

    public void printJavaClass(Identifier javaPackage, Struct javaClass, PrintWriter out) {
        if (javaPackage != null) {
            out.println("package " + javaPackage + ";");
        }
        if (this.config.noAutoImports) {
            out.println(javaClass);
        } else {
            Printer.printJava((Identifier)javaPackage, (Identifier)ElementsHelper.ident((Identifier)(javaPackage == null ? null : javaPackage.clone()), (Identifier[])new Identifier[]{javaClass.getTag().clone()}), (Element)javaClass, (PrintWriter)out);
        }
    }

    public boolean hasObjectiveC() {
        if (!this.objCCategoriesByName.isEmpty()) {
            return true;
        }
        Map<Identifier, Struct> m = this.classes.get(Struct.Type.ObjCClass);
        if (m != null && !m.isEmpty()) {
            return true;
        }
        m = this.classes.get(Struct.Type.ObjCProtocol);
        return m != null && !m.isEmpty();
    }

    public void addWeakTypeDef(TypeRef clone, String sn) {
        this.weakTypeDefs.put(sn, clone);
    }

    public void rehabilitateWeakTypeDefs() {
        for (Map.Entry<String, TypeRef> e : this.weakTypeDefs.entrySet()) {
            if (this.typeDefs.get(e.getKey()) != null) continue;
            Declarator.DirectDeclarator dd = new Declarator.DirectDeclarator(e.getKey());
            StoredDeclarations.TypeDef td = new StoredDeclarations.TypeDef(e.getValue(), new Declarator[]{dd});
            this.typeDefs.put(e.getKey(), (Pair<StoredDeclarations.TypeDef, Declarator>)new Pair((Object)td, (Object)dd));
        }
    }

    public TypeRef getTypeDef(Identifier nameId) {
        Declarator.MutableByDeclarator mt;
        String rname;
        if (nameId == null) {
            return null;
        }
        String name = nameId.toString();
        Pair<StoredDeclarations.TypeDef, Declarator> p = this.typeDefs.get(name);
        if (p == null) {
            return this.manualTypeDefs.get(name);
        }
        Declarator value = (Declarator)p.getValue();
        String string = rname = value == null ? null : value.resolveName();
        if (rname != null) {
            if (name.equals("id")) {
                return null;
            }
            if (name.equals("SEL")) {
                return null;
            }
            if (name.equals("IMP")) {
                return null;
            }
            if (name.equals("Class")) {
                return null;
            }
            if (name.equals("BOOL") && rname.equals("byte")) {
                return null;
            }
        }
        return (mt = ((Declarator)p.getValue()).mutateType((Declarator.MutableByDeclarator)((StoredDeclarations.TypeDef)p.getFirst()).getValueType())) instanceof TypeRef ? (TypeRef)mt : null;
    }

    public void addManualTypeDef(String name, TypeRef tr) {
        this.manualTypeDefs.put(name, tr);
    }

    public TypeRef resolveType(TypeRef tr, boolean keepUnresolvedIdentifiers) {
        return this.resolveType(tr, keepUnresolvedIdentifiers, new HashSet<Identifier>());
    }

    protected TypeRef resolveType(TypeRef tr, boolean keepUnresolvedIdentifiers, Set<Identifier> resolvedTypeDefs) {
        TypeRef resolved;
        TypeRef.TaggedTypeRef ttr;
        if (tr instanceof TypeRef.TaggedTypeRef && (ttr = (TypeRef.TaggedTypeRef)tr).isForwardDeclaration() && ttr.getTag() != null) {
            Enum resolved2 = null;
            if (ttr instanceof Enum) {
                resolved2 = this.resolveEnum(ttr.getTag());
            } else if (ttr instanceof Struct) {
                resolved2 = this.resolveStruct(ttr.getTag());
            }
            return resolved2 != null ? resolved2 : tr;
        }
        if (tr instanceof TypeRef.TargettedTypeRef) {
            ttr = (TypeRef.TargettedTypeRef)tr;
            TypeRef originalTarget = ttr.getTarget();
            TypeRef resolvedTarget = this.resolveType(originalTarget, keepUnresolvedIdentifiers, resolvedTypeDefs);
            if (resolvedTarget == null) {
                return null;
            }
            ttr.setTarget(null);
            TypeRef.TargettedTypeRef clone = (TypeRef.TargettedTypeRef)ttr.clone();
            ttr.setTarget(originalTarget);
            clone.setTarget(resolvedTarget.clone());
            clone.setParentElement((Element)ttr.findParentOfType(Struct.class));
            return clone;
        }
        if (this.isPrimitive(tr)) {
            return tr;
        }
        if (tr instanceof TypeRef.SimpleTypeRef && ((resolved = this.resolveType(((TypeRef.SimpleTypeRef)tr).getName(), keepUnresolvedIdentifiers, resolvedTypeDefs)) != null || !keepUnresolvedIdentifiers)) {
            return resolved;
        }
        return tr;
    }

    protected TypeRef resolveType(Identifier name, boolean keepUnresolvedIdentifiers, Set<Identifier> resolvedTypeDefs) {
        Struct res = this.resolveStruct(name);
        if (res != null) {
            return res;
        }
        res = this.resolveEnum(name);
        if (res != null) {
            return res;
        }
        res = this.resolveCallback(name);
        if (res != null) {
            return res;
        }
        res = this.resolveObjCClass(name);
        if (res != null) {
            return res;
        }
        if (resolvedTypeDefs.add(name) && (res = this.getTypeDef(name)) != null) {
            return this.resolveType((TypeRef)res, keepUnresolvedIdentifiers, resolvedTypeDefs);
        }
        return null;
    }

    public TypeRef.FunctionSignature resolveCallback(Identifier name) {
        return this.callbacksByName.get(name);
    }

    public Enum resolveEnum(Identifier name) {
        return this.enumsByName.get(name);
    }

    public Struct resolveStruct(Identifier name) {
        return this.structsByName.get(name);
    }

    public boolean isObjCppPrimitive(String s) {
        return this.javaPrims.containsKey(s);
    }

    protected void prim(String from, TypeConversion.JavaPrim to) {
        this.javaPrims.put(from, to);
    }

    public static interface ClassWritingNotifiable {
        public Struct writingClass(Identifier var1, Struct var2, Signatures var3, String var4);
    }
}

