/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.string.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bridj.ann.Ptr;

public class Reifier {
    final Result result;

    public Reifier(Result result) {
        this.result = result;
    }

    void toDirectFakePointer(Result result, Declaration decl) {
        decl.setValueType(ElementsHelper.typeRef(Long.TYPE));
        decl.addAnnotation(new Annotation(ElementsHelper.typeRef(Ptr.class)));
    }

    boolean isFakePointerRef(Result result, TypeRef tr) {
        Identifier id;
        return tr instanceof TypeRef.SimpleTypeRef && result.isFakePointer(id = ((TypeRef.SimpleTypeRef)tr).getName());
    }

    private void privatize(Declaration d) {
        ArrayList<ModifierType> modifiers = new ArrayList<ModifierType>(d.getModifiers());
        modifiers.remove(ModifierType.Public);
        modifiers.remove(ModifierType.Protected);
        modifiers.add(0, ModifierType.Private);
        d.setModifiers(modifiers);
    }

    static String trimAny(String s, String[] prefixes, String[] suffixes) {
        String l = s.toLowerCase();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!l.startsWith(prefix.toLowerCase())) continue;
                s = s.substring(prefix.length());
                break;
            }
        }
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!l.endsWith(suffix.toLowerCase())) continue;
                s = s.substring(0, s.length() - suffix.length());
                break;
            }
        }
        return s;
    }

    public String reifyFunctionName(Result result, String fakePointerName, String functionName) {
        String simplifiedPointerName = StringUtils.trimUnderscores((String)Reifier.trimAny(fakePointerName, result.config.libraryNamingPrefixes, null));
        ArrayList<String> prefs = new ArrayList<String>();
        if (result.config.libraryNamingPrefixes != null) {
            prefs.addAll(Arrays.asList(result.config.libraryNamingPrefixes));
        }
        prefs.add(fakePointerName);
        prefs.add(simplifiedPointerName);
        String s = StringUtils.uncapitalize((String)StringUtils.trimUnderscores((String)Reifier.trimAny(functionName, prefs.toArray(new String[prefs.size()]), new String[]{simplifiedPointerName, simplifiedPointerName.replaceAll("_", "")})));
        if (s.length() == 0 || result.typeConverter.isJavaKeyword(s)) {
            return functionName;
        }
        return s;
    }

    public void reifyFakePointer(Struct ptClass, Identifier fullLibraryClassName, String fakePointerName, Signatures signatures) {
        Identifier resolvedFakePointer = this.result.getFakePointer(fullLibraryClassName, ElementsHelper.ident((String[])new String[]{fakePointerName}));
        List<Pair<Identifier, Function>> functionsReifiableInFakePointers = this.result.getFunctionsReifiableInFakePointer(resolvedFakePointer);
        String thisFakePtrRefStr = ElementsHelper.typeRef((Identifier)resolvedFakePointer).toString();
        if (functionsReifiableInFakePointers == null) {
            return;
        }
        for (Pair<Identifier, Function> p : functionsReifiableInFakePointers) {
            Function original = (Function)p.getSecond();
            Function fDirect = original.clone();
            int thisLocation = -1;
            ArrayList<Integer> fakePointersLocations = new ArrayList<Integer>();
            int iArg = 0;
            for (Arg arg : fDirect.getArgs()) {
                if (this.isFakePointerRef(this.result, arg.getValueType())) {
                    if (iArg == 0 && arg.getValueType().toString().equals(thisFakePtrRefStr)) {
                        thisLocation = iArg;
                    }
                    fakePointersLocations.add(iArg);
                    this.toDirectFakePointer(this.result, (Declaration)arg);
                }
                ++iArg;
            }
            String indirectRetVarName = "$";
            boolean returnsFakePointer = this.isFakePointerRef(this.result, fDirect.getValueType());
            boolean needsDirect = !fakePointersLocations.isEmpty() || returnsFakePointer;
            Expression.New finalCall = null;
            String directFunctionName = null;
            if (needsDirect) {
                if (returnsFakePointer) {
                    finalCall = new Expression.New(fDirect.getValueType(), new Expression[]{ElementsHelper.varRef((String)indirectRetVarName)});
                    this.toDirectFakePointer(this.result, (Declaration)fDirect);
                }
                this.privatize((Declaration)fDirect);
                if (signatures.addMethod(fDirect)) {
                    ((DeclarationsHolder)original.getParentElement()).addDeclaration((Declaration)fDirect);
                }
                if (original.computeSignature(Function.SignatureType.JavaStyle).equals(fDirect.computeSignature(Function.SignatureType.JavaStyle))) {
                    fDirect.setName(ElementsHelper.ident((String[])new String[]{original.getName() + "$direct"}));
                }
                directFunctionName = fDirect.getName().toString();
            }
            Function f = original.clone();
            ArrayList args = new ArrayList(f.getArgs());
            f.setModifiers(Collections.EMPTY_LIST);
            f.addModifiers(new Modifier[]{ModifierType.Public});
            if (thisLocation < 0) {
                f.addModifiers(new Modifier[]{ModifierType.Static});
            }
            String functionName = f.getName().toString();
            f.setName(ElementsHelper.ident((String[])new String[]{this.reifyFunctionName(this.result, fakePointerName, functionName)}));
            Identifier id = (Identifier)p.getFirst();
            ArrayList<Object> followedArgs = new ArrayList<Object>();
            iArg = 0;
            for (Arg arg : args) {
                if (iArg == thisLocation) {
                    followedArgs.add(ElementsHelper.methodCall((Expression)ElementsHelper.thisRef(), (String)"getPeer", (Expression[])new Expression[0]));
                } else if (fakePointersLocations.contains(iArg)) {
                    followedArgs.add(ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)arg.getName()), (String)"getPeer", (Expression[])new Expression[0]));
                } else {
                    followedArgs.add(ElementsHelper.varRef((String)arg.getName()));
                }
                ++iArg;
            }
            if (thisLocation >= 0) {
                args.remove(thisLocation);
            }
            f.setArgs(args);
            Expression nlib = ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)((Identifier)p.getFirst()).clone()));
            Expression.FunctionCall x = ElementsHelper.methodCall((Expression)nlib, (String)(needsDirect ? directFunctionName : functionName), (Expression[])followedArgs.toArray(new Expression[followedArgs.size()]));
            boolean retVoid = "void".equals(String.valueOf(f.getValueType()));
            if (retVoid) {
                f.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)x)}));
            } else if (needsDirect && finalCall != null) {
                VariablesDeclaration vd = new VariablesDeclaration(ElementsHelper.typeRef(Long.TYPE), new Declarator[]{new Declarator.DirectDeclarator(indirectRetVarName, (Expression)x)});
                Expression.ConditionalExpression ce = new Expression.ConditionalExpression();
                ce.setTest(ElementsHelper.expr((Expression)ElementsHelper.varRef((String)indirectRetVarName), (Expression.BinaryOperator)Expression.BinaryOperator.IsEqual, (Expression)ElementsHelper.expr((int)0)));
                ce.setThenValue(ElementsHelper.nullExpr());
                ce.setElseValue((Expression)finalCall);
                f.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Declaration)vd), new Statement.Return((Expression)ce)}));
            } else {
                f.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)x)}));
            }
            ptClass.addDeclaration((Declaration)f);
        }
    }
}

