/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.ReadText;
import com.ochafik.io.WriteText;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorParser;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.util.string.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anarres.cpp.CppReader;
import org.anarres.cpp.Feature;
import org.anarres.cpp.FileLexerSource;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Macro;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;
import org.anarres.cpp.VirtualFile;
import org.anarres.cpp.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessorUtils {
    static Pattern macroFuncNamePattern = Pattern.compile("(\\w+)\\(([^)]+)\\)");

    public static String preprocessSources(JNAeratorConfig config, List<Define> defines, boolean verbose, TypeConversion typeConverter, MacroUseCallback macrosDependenciesOut) throws IOException, LexerException {
        return PreprocessorUtils.preprocessSources(config, config.preprocessorConfig.includeStrings, config.getFiles(), defines, verbose, typeConverter, macrosDependenciesOut, null);
    }

    public static String preprocessSources(JNAeratorConfig config, Collection<String> includeStrings, Collection<File> files, List<Define> defines, boolean verbose, TypeConversion typeConverter, MacroUseCallback macrosDependenciesOut, Map<String, Macro> macros) throws IOException, LexerException {
        boolean isTopLevel;
        Preprocessor preProcessor = PreprocessorUtils.createPreProcessor(config.preprocessorConfig, macrosDependenciesOut);
        for (String string : includeStrings) {
            preProcessor.addInput((Source)new StringLexerSource(string, true));
        }
        for (File file : files) {
            preProcessor.addInput(file);
        }
        boolean bl = isTopLevel = macros == null;
        if (!isTopLevel) {
            for (Macro macro : macros.values()) {
                preProcessor.addMacro(macro);
            }
        }
        String string = ReadText.readText((Reader)new CppReader(preProcessor));
        preProcessor.close();
        macros = preProcessor.getMacros();
        if (isTopLevel) {
            if (config.preprocessingOutFile != null) {
                if (config.verbose) {
                    System.out.println("Writing preprocessor output to '" + config.preprocessingOutFile + "'");
                }
                WriteText.writeText((String)string, (File)config.preprocessingOutFile);
            }
            if (config.macrosOutFile != null) {
                if (config.verbose) {
                    System.out.println("Writing preprocessor macros to '" + config.macrosOutFile + "'");
                }
                WriteText.writeText((String)StringUtils.implode(macros.entrySet(), (Object)"\n"), (File)config.macrosOutFile);
            }
        }
        for (String k : config.preprocessorConfig.getAllMacros().keySet()) {
            macros.remove(k);
        }
        if (defines != null) {
            PreprocessorUtils.addDefines(config, macros, defines, verbose, typeConverter);
        }
        return string;
    }

    public static Preprocessor createPreProcessor(final JNAeratorConfig.PreprocessorConfig config, final MacroUseCallback macrosDependenciesOut) throws IOException, LexerException {
        Preprocessor preprocessor = new Preprocessor(){
            HashSet<VirtualFile> filesAlreadyIncluded = new HashSet();
            Set<String> pragmaOnces = new HashSet<String>();

            protected boolean include(VirtualFile file) throws IOException, LexerException {
                if (!this.filesAlreadyIncluded.add(file)) {
                    return true;
                }
                return super.include(file);
            }

            protected void pragma(Token name, List<Token> value) throws IOException, LexerException {
                if ("once".equals(name.getText())) {
                    if (!this.pragmaOnces.add(this.getSource().toString())) {
                        this.pop_source();
                    }
                } else {
                    super.pragma(name, value);
                }
            }

            protected void pop_source() throws IOException {
                if (this.getSource() instanceof FileLexerSource) {
                    // empty if block
                }
                super.pop_source();
            }

            protected Map<String, Macro> createMacro() {
                return new LinkedHashMap<String, Macro>(){

                    @Override
                    public boolean containsKey(Object key) {
                        if (key instanceof String) {
                            this.used((String)key);
                        }
                        return super.containsKey(key);
                    }

                    @Override
                    public Macro get(Object key) {
                        if (key instanceof String) {
                            this.used((String)key);
                        }
                        return (Macro)super.get(key);
                    }

                    @Override
                    public void clear() {
                        super.clear();
                    }

                    @Override
                    public Macro put(String key, Macro value) {
                        if (key != null) {
                            this.used(key);
                        }
                        if (config.forcedTypeDefs.containsKey(key)) {
                            return null;
                        }
                        return super.put(key, value);
                    }
                };
            }

            void used(String name) {
                if (macrosDependenciesOut != null) {
                    Source src = this.getSource();
                    macrosDependenciesOut.macroUsed(src == null ? null : src.getPath(), name);
                }
            }
        };
        preprocessor.setProperStringTokensInLinePragmas(true);
        if (config.preprocess) {
            preprocessor.addFeature(Feature.KEEPCOMMENTS);
            preprocessor.addFeature(Feature.DIGRAPHS);
            preprocessor.addFeature(Feature.INCLUDENEXT);
            preprocessor.addFeature(Feature.OBJCSYNTAX);
            preprocessor.addFeature(Feature.TRIGRAPHS);
            preprocessor.addFeature(Feature.LINEMARKERS);
            preprocessor.addWarning(Warning.IMPORT);
        } else {
            preprocessor.getFeatures().clear();
        }
        preprocessor.setListener(new PreprocessorListener(){

            public void handleWarning(Source source, int line, int column, String msg) throws LexerException {
                if (msg.contains("Unnecessary escape character ")) {
                    return;
                }
                if (msg.contains("#pragma")) {
                    return;
                }
                super.handleWarning(source, line, column, msg);
            }
        });
        List<String> includes = config.getAllIncludes();
        preprocessor.getSystemIncludePath().addAll(includes);
        preprocessor.getQuoteIncludePath().addAll(includes);
        preprocessor.getFrameworksPath().addAll(config.frameworksPath);
        for (Map.Entry<String, String> e : config.getAllMacros().entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            Matcher matcher = macroFuncNamePattern.matcher(name);
            if (matcher.matches()) {
                name = matcher.group(1);
                Macro macro = new Macro((Source)new StringLexerSource(value), name);
                String argsStr = matcher.group(2);
                ArrayList<String> args = new ArrayList<String>();
                for (String arg : argsStr.split(",")) {
                    args.add(arg.trim());
                }
                macro.setArgs(args);
                preprocessor.addMacro(macro);
                continue;
            }
            if (e.getValue() != null) {
                preprocessor.addMacro(name, value);
                continue;
            }
            preprocessor.addMacro(name);
        }
        return preprocessor;
    }

    public static String removePreprocessorDirectives(String s) {
        s = s.replaceAll(";#line", ";\n#line");
        s = s.replaceAll("(?s)#\\s*(pragma|if|endif|error|ifdef|ifndef|else|elif|define|undef).*?\n", "\n");
        s = s.replaceAll("(?s)#\\s*(import|include).*?\n", "\n");
        return s;
    }

    public static String removeNastyDefines(String s) {
        s = s.replaceAll("DEPRECATED_IN_MAC_OS_X_VERSION_[A-Z0-9_]+_AND_LATER", " ");
        s = s.replaceAll("AVAILABLE_MAC_OS_X_VERSION_[A-Z0-9_]+_AND_LATER(_BUT_DEPRECATED_IN_MAC_OS_X_VERSION_[A-Z0-9_]+)?", " ");
        s = s.replaceAll("NS_REQUIRES_NIL_TERMINATION", " ");
        s = s.replaceAll("__MATH_H_ALWAYS_INLINE__", " ");
        s = s.replace("CSEXTERN", "extern");
        s = s.replace("__inner_fallthrough_dec", " ");
        return s;
    }

    static void addDefines(JNAeratorConfig config, Map<String, Macro> macros, List<Define> defines, boolean verbose, TypeConversion typeConverter) {
        for (Map.Entry<String, Macro> e : macros.entrySet()) {
            Macro macro = e.getValue();
            if (macro.getText() == null || macro.isFunctionLike() && macro.getArgs() > 0) continue;
            try {
                String preprocessedMacro = PreprocessorUtils.preprocessSources(config, Collections.singletonList(macro.getText()), Collections.EMPTY_LIST, null, verbose, typeConverter, null, macros);
                Expression expression = new JNAeratorParser().newObjCppParser(typeConverter, preprocessedMacro, verbose, null).expression();
                if (expression == null) continue;
                Define define = new Define(e.getKey(), expression);
                if (macro.getSource() != null) {
                    define.setElementFile(macro.getSource().getPath());
                }
                defines.add(define);
            }
            catch (Exception ex) {
                if (!verbose) continue;
                System.err.println("Failed to convert define '" + e.getValue() + ":\n" + ex);
            }
        }
    }

    public static interface MacroUseCallback {
        public void macroUsed(String var1, String var2);
    }
}

