/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.string.StringUtils;

public class ObjectiveCToJavaPreScanner
extends Scanner {
    Result result;

    public ObjectiveCToJavaPreScanner(Result result) {
        this.result = result;
    }

    public void visitEnum(Enum e) {
        String comment;
        Enum base;
        Element next;
        Element parent = e.getParentElement();
        if (e.getTag() == null && !(parent instanceof StoredDeclarations.TypeDef) && !this.handleAppleEnumTypeDef(next = (base = parent instanceof Declaration ? e.getParentElement() : e).getNextSibling(), e)) {
            Element beforePrevious;
            Element previous = base.getPreviousSibling();
            Element element = beforePrevious = previous == null ? null : previous.getPreviousSibling();
            if (!(previous == null || beforePrevious instanceof TaggedTypeRefDeclaration && ((TaggedTypeRefDeclaration)beforePrevious).getTaggedTypeRef() instanceof Enum)) {
                this.handleAppleEnumTypeDef(previous, e);
            }
        }
        if ((comment = e.getCommentBefore()) != null) {
            // empty if block
        }
        super.visitEnum(e);
    }

    public void visitVariablesDeclaration(VariablesDeclaration v) {
        if (v.getDeclarators().isEmpty() && v.getValueType() instanceof TypeRef.TaggedTypeRef) {
            TaggedTypeRefDeclaration d = new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)v.getValueType());
            d.importComments((Element)v, new String[0]);
            v.replaceBy((Element)d);
            d.accept((Visitor)this);
        } else {
            super.visitVariablesDeclaration(v);
        }
    }

    private boolean handleAppleEnumTypeDef(Element nextDeclaration, Enum e) {
        if (!(nextDeclaration instanceof StoredDeclarations.TypeDef)) {
            return false;
        }
        StoredDeclarations.TypeDef typeDef = (StoredDeclarations.TypeDef)nextDeclaration;
        if (typeDef.getDeclarators().size() != 1) {
            return false;
        }
        Declarator decl = (Declarator)typeDef.getDeclarators().get(0);
        if (!(decl instanceof Declarator.DirectDeclarator)) {
            return false;
        }
        TypeRef type = typeDef.getValueType();
        if (!(type instanceof TypeRef.SimpleTypeRef)) {
            return false;
        }
        Identifier simpleType = ((TypeRef.SimpleTypeRef)type).getName();
        if (!(simpleType != null && (simpleType.equals((Object)"NSUInteger") || simpleType.equals((Object)"NSInteger") || simpleType.equals((Object)"int32_t") || simpleType.equals((Object)"uint32_t") || simpleType.equals((Object)"CFIndex")))) {
            return false;
        }
        String name = decl.resolveName();
        if (e.getTag() != null && !StringUtils.trimUnderscores((String)e.getTag().toString()).equals(name)) {
            return false;
        }
        Element ep = e.getParentElement();
        ep.addToCommentBefore(new String[]{typeDef.getCommentBefore()});
        ep.addToCommentBefore(new String[]{typeDef.getCommentAfter()});
        typeDef.importDetails(ep, true);
        ep.replaceBy(null);
        typeDef.setValueType((TypeRef)e);
        if (this.result.config.verbose) {
            System.err.println("Inferred enum name : " + name);
        }
        return false;
    }
}

