/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.GYPUtils;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Include;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NodeJSDeclarationsConverter
extends DeclarationsConverter {
    static final String argsName = "_arguments_";
    static final String returnValueName = "_return_";
    static final String scopeName = "_scope_";
    static final String initTarget = "_target_";
    static final String dummyNodeBufferFreeCallbackName = "_dummy_node_buffer_free_callback_";

    public NodeJSDeclarationsConverter(Result result) {
        super(result);
    }

    protected void configureCallbackStruct(Struct callbackStruct) {
    }

    public void convertCallback(TypeRef.FunctionSignature functionSignature, Signatures signatures, DeclarationsHolder out, Identifier callerLibraryName) {
    }

    protected void outputNSString(String name, String value, DeclarationsHolder out, Signatures signatures, Element ... elementsToTakeCommentsFrom) {
    }

    protected void convertConstant(String name, TypeConversion.JavaPrim prim, TypeRef mutatedType, Expression defaultValue, VariablesDeclaration v, Declarator decl, DeclarationsHolder out, Signatures signatures, Identifier libraryClassName) {
        this.convertConstant(name, defaultValue, out, signatures);
    }

    Expression.Constant.Type getValueConstantType(Expression value) {
        if (value instanceof Expression.Cast) {
            return this.getValueConstantType(((Expression.Cast)value).getTarget());
        }
        if (value instanceof Expression.BinaryOp) {
            return this.getValueConstantType(((Expression.BinaryOp)value).getFirstOperand());
        }
        if (value instanceof Expression.Constant) {
            return ((Expression.Constant)value).getType();
        }
        throw new UnsupportedConversionException((Element)value, "Unknown value type");
    }

    protected void convertDefine(Define define, DeclarationsHolder out, Signatures signatures, Identifier libraryClassName) {
        Expression value = define.getValue();
        this.convertConstant(define.getName(), value, out, signatures);
    }

    protected void convertConstant(String name, Expression value, DeclarationsHolder out, Signatures signatures) {
        Expression.FunctionCall expr;
        Statement.Block initBlock = this.getInitMethodBody(out);
        Expression.Constant.Type valueType = this.getValueConstantType(value);
        switch (valueType) {
            case Int: 
            case UInt: 
            case IntegerString: 
            case Long: 
            case ULong: 
            case LongString: 
            case Short: 
            case Byte: {
                expr = ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Integer", "New"), (Expression[])new Expression[]{value.clone()});
                break;
            }
            case Double: 
            case Float: {
                expr = ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Number", "New"), (Expression[])new Expression[]{value.clone()});
                break;
            }
            case Bool: {
                expr = ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Boolean", "New"), (Expression[])new Expression[]{value.clone()});
                break;
            }
            case Char: 
            case String: {
                expr = ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "String", "New"), (Expression[])new Expression[]{new Expression.Constant(valueType, (Object)(value + ""), null)});
                break;
            }
            case Null: {
                expr = ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Null"), (Expression[])new Expression[0]);
                break;
            }
            default: {
                throw new UnsupportedConversionException((Element)value, "Constant type not supported yet");
            }
        }
        initBlock.addStatement(ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)initTarget), (Expression.MemberRefStyle)Expression.MemberRefStyle.Arrow, (String)"Set", (Expression[])new Expression[]{ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "String", "NewSymbol"), (Expression[])new Expression[]{ElementsHelper.expr((String)name)}), expr})));
    }

    Statement.Block getInitMethodBody(DeclarationsHolder decls) {
        for (Declaration decl : decls.getDeclarations()) {
            if (!(decl instanceof Function)) continue;
            return ((Function)decl).getBody();
        }
        throw new RuntimeException("Init method not found in " + decls);
    }

    static Identifier ident(String ... components) {
        return ElementsHelper.ident((Identifier.QualificationSeparator)Identifier.QualificationSeparator.Colons, (String[])components);
    }

    static Expression newV8String(String s) {
        return ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "String", "New"), (Expression[])new Expression[]{ElementsHelper.expr((String)s)});
    }

    static Expression arrowMethodCall(Expression target, String name, Expression ... args) {
        return ElementsHelper.methodCall((Expression)target, (Expression.MemberRefStyle)Expression.MemberRefStyle.Arrow, (String)name, (Expression[])args);
    }

    private TypeRef resolveTypeDef(TypeRef typeRef) {
        TypeRef tr = this.result.typeConverter.normalizeTypeRef(typeRef);
        return tr;
    }

    private NodeType getNodeType(TypeRef tr) {
        if (tr instanceof TypeRef.TargettedTypeRef) {
            TypeRef.TargettedTypeRef ttr = (TypeRef.TargettedTypeRef)tr;
            if (ttr.getTarget().toString().matches("(const\\s+)?char")) {
                return NodeType.String;
            }
            return NodeType.Pointer;
        }
        if (tr instanceof TypeRef.SimpleTypeRef) {
            TypeRef.SimpleTypeRef str = (TypeRef.SimpleTypeRef)tr;
            String n = str + "";
            if (n.matches("bool|BOOL")) {
                return NodeType.Boolean;
            }
            if (n.matches("void")) {
                return NodeType.Void;
            }
            if (n.equals("va_list") || n.equals("__builtin_va_list")) {
                return NodeType.VAList;
            }
            return NodeType.Number;
        }
        if (tr instanceof TypeRef.FunctionSignature) {
            return NodeType.Pointer;
        }
        return NodeType.Unknown;
    }

    protected void convertFunction(Function function, Signatures signatures, boolean callback, DeclarationsHolder declarations, DeclarationsHolder implementations, Identifier libraryClassName, String sig, Identifier functionName, String library, int iConstructor) {
        assert (implementations == declarations || declarations == null);
        String methodName = library + "_" + (function.getParentElement() instanceof Struct ? ((Struct)function.getParentElement()).getTag() + "_" : "") + function.getName();
        Function method = new Function(Function.Type.CppMethod, NodeJSDeclarationsConverter.ident(methodName), (TypeRef)ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.v8Ident("Handle", NodeJSDeclarationsConverter.v8Ident("Value", new Identifier[0]))));
        method.addArg(new Arg(argsName, new TypeRef.Pointer((TypeRef)ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.v8Ident("Arguments", new Identifier[0])), Declarator.PointerStyle.Reference).addModifiers(new Modifier[]{ModifierType.Const})));
        Statement.Block body = new Statement.Block();
        List args = function.getArgs();
        int argCount = args.size();
        body.addStatement((Statement)new Statement.If(ElementsHelper.expr((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)argsName), (String)"Length", (Expression[])new Expression[0]), (Expression.BinaryOperator)Expression.BinaryOperator.IsDifferent, (Expression)ElementsHelper.expr((int)argCount)), (Statement)new Statement.Return((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.v8Ident("ThrowException", new Identifier[0]), (Expression[])new Expression[]{NodeJSDeclarationsConverter.newV8String(functionName + "() requires " + argCount + " arguments!")}))));
        ArrayList<Expression> params = new ArrayList<Expression>();
        for (int iArg = 0; iArg < argCount; ++iArg) {
            Arg arg = (Arg)args.get(iArg);
            if (arg.isVarArg()) {
                throw new UnsupportedConversionException((Element)function, "varargs not supported yet");
            }
            TypeRef tr = this.resolveTypeDef(arg.getValueType());
            NodeType argNodeType = this.getNodeType(tr);
            Expression typeTest = null;
            String typeErrorMessage = null;
            Expression.ArrayAccess argExpr = new Expression.ArrayAccess(ElementsHelper.varRef((String)argsName), ElementsHelper.expr((int)iArg));
            Expression argDeclExpr = null;
            TypeRef.SimpleTypeRef argType = null;
            Expression argUsageExpr = null;
            switch (argNodeType) {
                case String: {
                    typeTest = NodeJSDeclarationsConverter.arrowMethodCall((Expression)argExpr, "IsString", new Expression[0]);
                    typeErrorMessage = "expected a String";
                    argDeclExpr = NodeJSDeclarationsConverter.arrowMethodCall(argExpr.clone(), "ToString", new Expression[0]);
                    argType = ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.v8Ident("Handle", NodeJSDeclarationsConverter.v8Ident("String", new Identifier[0])));
                    argUsageExpr = ElementsHelper.cast((TypeRef)this.transformTypeForCast(arg.getValueType()), (Expression)ElementsHelper.expr((Expression.UnaryOperator)Expression.UnaryOperator.Dereference, (Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "String", "AsciiValue"), (Expression[])new Expression[]{ElementsHelper.varRef((String)arg.getName())})));
                    break;
                }
                case Pointer: {
                    typeTest = ElementsHelper.expr((Expression)ElementsHelper.methodCall((Expression)argExpr.clone(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Arrow, (String)"IsNull", (Expression[])new Expression[0]), (Expression.BinaryOperator)Expression.BinaryOperator.Or, (Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("node", "Buffer", "HasInstance"), (Expression[])new Expression[]{argExpr}));
                    typeErrorMessage = "expected a Buffer";
                    argDeclExpr = new Expression.ConditionalExpression((Expression)ElementsHelper.methodCall((Expression)argExpr.clone(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Arrow, (String)"IsNull", (Expression[])new Expression[0]), ElementsHelper.varRef((String)"NULL"), (Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("node", "Buffer", "Data"), (Expression[])new Expression[]{ElementsHelper.methodCall((Expression)argExpr.clone(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.templateIdent((Identifier)NodeJSDeclarationsConverter.ident("As"), (Expression[])new Expression[]{ElementsHelper.varRef((Identifier)NodeJSDeclarationsConverter.v8Ident("Object", new Identifier[0]))}), (Expression[])new Expression[0])}));
                    argType = new TypeRef.Pointer((TypeRef)ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.ident("char")), Declarator.PointerStyle.Pointer);
                    argUsageExpr = ElementsHelper.cast((TypeRef)this.transformTypeForCast(arg.getValueType()), (Expression)ElementsHelper.varRef((String)arg.getName()));
                    break;
                }
                case Boolean: 
                case Number: {
                    String t = argNodeType.name();
                    typeTest = NodeJSDeclarationsConverter.arrowMethodCall((Expression)argExpr, "Is" + t, new Expression[0]);
                    typeErrorMessage = "expected a " + t;
                    argDeclExpr = NodeJSDeclarationsConverter.arrowMethodCall(argExpr.clone(), "To" + t, new Expression[0]);
                    argType = ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.v8Ident("Handle", NodeJSDeclarationsConverter.v8Ident(t, new Identifier[0])));
                    argUsageExpr = ElementsHelper.cast((TypeRef)arg.getValueType().clone(), (Expression)NodeJSDeclarationsConverter.arrowMethodCall(ElementsHelper.expr((Expression.UnaryOperator)Expression.UnaryOperator.Dereference, (Expression)ElementsHelper.varRef((String)arg.getName())), "Value", new Expression[0]));
                    break;
                }
                case VAList: {
                    throw new UnsupportedConversionException((Element)function, "va_list not supported yet");
                }
                case Unknown: 
                case Void: {
                    throw new UnsupportedConversionException((Element)arg, "Cannot convert arguments of type " + tr);
                }
            }
            if (typeTest != null) {
                body.addStatement((Statement)new Statement.If(ElementsHelper.expr((Expression.UnaryOperator)Expression.UnaryOperator.Not, (Expression)typeTest), (Statement)new Statement.Return((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.v8Ident("ThrowException", new Identifier[0]), (Expression[])new Expression[]{ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Exception", "TypeError"), (Expression[])new Expression[]{NodeJSDeclarationsConverter.newV8String("Invalid value for argument '" + arg.getName() + "' at index " + iArg + (typeErrorMessage == null ? "" : ": " + typeErrorMessage))})}))));
            }
            if (argDeclExpr != null) {
                body.addStatement(ElementsHelper.stat((Declaration)new VariablesDeclaration(argType, new Declarator[]{new Declarator.DirectDeclarator(arg.getName(), argDeclExpr)})));
            }
            if (argUsageExpr == null) continue;
            params.add(argUsageExpr);
        }
        TypeRef retTr = this.resolveTypeDef(function.getValueType());
        NodeType retNodeType = this.getNodeType(retTr);
        body.addStatement((Statement)new VariablesDeclaration((TypeRef)ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.v8Ident("HandleScope", new Identifier[0])), new Declarator[]{new Declarator.DirectDeclarator(scopeName)}));
        Expression.FunctionCall call = ElementsHelper.methodCall((Identifier)function.getName(), (Expression[])params.toArray(new Expression[params.size()]));
        if (retNodeType == NodeType.Void) {
            body.addStatement(ElementsHelper.stat((Expression)call));
        } else {
            VariablesDeclaration retDecl = new VariablesDeclaration(function.getValueType().clone(), new Declarator[]{new Declarator.DirectDeclarator(returnValueName, (Expression)call)});
            body.addStatement((Statement)retDecl);
        }
        switch (retNodeType) {
            case Number: {
                body.addStatement((Statement)new Statement.Return(this.scopeClose((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Number", "New"), (Expression[])new Expression[]{ElementsHelper.varRef((String)returnValueName)}))));
                break;
            }
            case Boolean: {
                body.addStatement((Statement)new Statement.Return(this.scopeClose((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Boolean", "New"), (Expression[])new Expression[]{ElementsHelper.varRef((String)returnValueName)}))));
                break;
            }
            case Pointer: {
                body.addStatement((Statement)new Statement.If(ElementsHelper.varRef((String)returnValueName), (Statement)new Statement.Return(this.scopeClose(ElementsHelper.memberRef((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("node", "Buffer", "New"), (Expression[])new Expression[]{ElementsHelper.cast((TypeRef)new TypeRef.Pointer((TypeRef)ElementsHelper.typeRef((String)"char"), Declarator.PointerStyle.Pointer), (Expression)ElementsHelper.varRef((String)returnValueName)), ElementsHelper.expr((int)1), ElementsHelper.varRef((String)dummyNodeBufferFreeCallbackName), ElementsHelper.varRef((String)"NULL")}), (Expression.MemberRefStyle)Expression.MemberRefStyle.Arrow, (String)"handle_"))), (Statement)new Statement.Return(this.scopeClose((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.ident("v8", "Null"), (Expression[])new Expression[0])))));
                break;
            }
            case Void: {
                body.addStatement((Statement)new Statement.Return(this.scopeClose((Expression)ElementsHelper.methodCall((Identifier)NodeJSDeclarationsConverter.v8Ident("Undefined", new Identifier[0]), (Expression[])new Expression[0]))));
                break;
            }
            default: {
                throw new UnsupportedConversionException((Element)function, "Return type not handled: " + retTr + " (" + (Object)((Object)retNodeType) + ")");
            }
        }
        method.setBody(body);
        implementations.addDeclaration((Declaration)method);
        Statement.Block initBlock = this.getInitMethodBody(implementations);
        initBlock.addStatement(ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"NODE_SET_METHOD", (Expression[])new Expression[]{ElementsHelper.varRef((String)initTarget), ElementsHelper.expr((String)functionName.toString()), ElementsHelper.varRef((String)methodName)})));
    }

    private Expression scopeClose(Expression content) {
        return ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)scopeName), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"Close", (Expression[])new Expression[]{content});
    }

    private TypeRef transformTypeForCast(TypeRef tr) {
        if (tr instanceof TypeRef.TargettedTypeRef) {
            TypeRef.TargettedTypeRef ttr = (TypeRef.TargettedTypeRef)tr;
            return new TypeRef.Pointer(this.transformTypeForCast(ttr.getTarget()), Declarator.PointerStyle.Pointer);
        }
        return tr.clone();
    }

    protected Struct createFakePointerClass(Identifier fakePointer) {
        return null;
    }

    public void convertEnum(Enum e, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
    }

    public Struct convertStruct(Struct struct, Signatures signatures, Identifier callerLibraryClass, String callerLibrary, boolean onlyFields) throws IOException {
        return null;
    }

    public boolean convertVariablesDeclaration(VariablesDeclaration v, Signatures signatures, DeclarationsHolder out, int[] iChild, boolean isGlobal, Identifier holderName, Identifier callerLibraryClass, String callerLibrary) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static Identifier v8Ident(String name, Identifier ... args) {
        Expression[] exprArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            exprArgs[i] = ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)args[i]));
        }
        return ElementsHelper.templateIdent((Identifier)NodeJSDeclarationsConverter.ident("v8", name), (Expression[])exprArgs);
    }

    public void generateLibraryFiles(SourceFiles sourceFiles, Result result, JNAeratorConfig config) throws IOException {
        ArrayList<Map<String, Object>> gypTargets = new ArrayList<Map<String, Object>>();
        for (String library : result.libraries) {
            Object librarySourceFiles;
            if (library == null) continue;
            boolean isFramework = config.frameworks.contains(library);
            String moduleName = library;
            String sourcePath = "src/" + library + "_module.cc";
            ArrayList<String> sources = new ArrayList<String>();
            ArrayList dependencies = new ArrayList();
            sources.add(sourcePath);
            SourceFile sourceFile = new SourceFile();
            sourceFile.setElementFile(sourcePath);
            for (String inc : new String[]{"v8.h", "node.h", "node_buffer.h"}) {
                sourceFile.addDeclaration((Declaration)new Include(Include.Type.CInclude, inc));
            }
            if (!isFramework && (librarySourceFiles = config.sourceFilesByLibrary.get(library)) != null) {
                Iterator iterator = librarySourceFiles.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    sourceFile.addDeclaration((Declaration)new Include(Include.Type.CInclude, file.toString()));
                }
            }
            librarySourceFiles = config.frameworks.iterator();
            while (librarySourceFiles.hasNext()) {
                String otherFramework = (String)librarySourceFiles.next();
                sourceFile.addDeclaration((Declaration)new Include(Include.Type.ObjCImport, otherFramework + "/" + otherFramework + ".h"));
            }
            String initFunctionName = library + "_init";
            Function initMethod = new Function(Function.Type.CppMethod, NodeJSDeclarationsConverter.ident(initFunctionName), ElementsHelper.typeRef(Void.TYPE));
            initMethod.addArg(new Arg(initTarget, (TypeRef)ElementsHelper.typeRef((Identifier)NodeJSDeclarationsConverter.v8Ident("Handle", NodeJSDeclarationsConverter.v8Ident("Object", new Identifier[0])))));
            initMethod.setBody(new Statement.Block());
            sourceFile.addDeclaration((Declaration)initMethod);
            Function dummyNodeBufferFreeCallback = new Function(Function.Type.CFunction, NodeJSDeclarationsConverter.ident(dummyNodeBufferFreeCallbackName), ElementsHelper.typeRef(Void.TYPE), new Arg[]{new Arg("data", (TypeRef)new TypeRef.Pointer((TypeRef)ElementsHelper.typeRef((String)"char"), Declarator.PointerStyle.Pointer)), new Arg("hint", (TypeRef)new TypeRef.Pointer((TypeRef)ElementsHelper.typeRef((String)"void"), Declarator.PointerStyle.Pointer))});
            dummyNodeBufferFreeCallback.setBody(new Statement.Block());
            sourceFile.addDeclaration((Declaration)dummyNodeBufferFreeCallback);
            this.fillLibraryMapping(result, sourceFiles, (DeclarationsHolder)sourceFile, (DeclarationsHolder)sourceFile, library, null, null);
            initMethod.replaceBy(null);
            sourceFile.addDeclaration((Declaration)initMethod);
            sourceFile.addDeclaration(ElementsHelper.decl((Statement)ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"NODE_MODULE", (Expression[])new Expression[]{ElementsHelper.varRef((Identifier)NodeJSDeclarationsConverter.ident(library)), ElementsHelper.varRef((Identifier)NodeJSDeclarationsConverter.ident(initFunctionName))}))));
            this.writeLibraryInterface(result, sourceFiles, (DeclarationsHolder)sourceFile, library, null);
            Map<String, Object> gypTarget = GYPUtils.map();
            gypTarget.put("target_name", library);
            gypTarget.put("sources", sources);
            gypTarget.put("include_dirs", config.preprocessorConfig.explicitIncludes);
            gypTarget.put("dependencies", dependencies);
            Map<String, Object> linkSettings = GYPUtils.map();
            linkSettings.put("libraries", isFramework ? Arrays.asList("-framework", library) : Arrays.asList("-l" + library));
            ArrayList<String> defines = new ArrayList<String>();
            for (Map.Entry<String, String> e : config.preprocessorConfig.explicitMacros.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                defines.add(v == null || v.length() == 0 ? k : k + "=" + v);
            }
            gypTarget.put("defines", defines);
            gypTarget.put("link_settings", linkSettings);
            gypTargets.add(gypTarget);
        }
        Map<String, Object> gypContents = GYPUtils.map();
        gypContents.put("targets", gypTargets);
        PrintWriter gypOut = result.classOutputter.getSourceWriter("binding.gyp");
        gypOut.print(GYPUtils.toGYP(gypContents));
        gypOut.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        Pointer,
        String,
        Number,
        Boolean,
        VAList,
        Unknown,
        Void;

    }
}

