/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import java.io.File;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.bridj.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NativePlatform {
    linux_x64("so"),
    linux_x86("so"),
    armeabi("so"),
    sunos_x86("so"),
    sunos_sparc("so"),
    darwin_universal("dylib"),
    win32("dll"),
    win64("dll");

    final Pattern pattern;
    final String extension;

    private NativePlatform(String extension) {
        this.extension = extension;
        this.pattern = Pattern.compile(".*?\\." + Pattern.quote(extension));
    }

    public static EnumSet<NativePlatform> getPossiblePlatformsOfLibraryFile(String path) {
        String name = new File(path).getName();
        EnumSet<NativePlatform> set = EnumSet.noneOf(NativePlatform.class);
        for (NativePlatform p : NativePlatform.values()) {
            if (!p.pattern.matcher(name).matches()) continue;
            set.add(p);
        }
        return set;
    }

    public static NativePlatform getCurrentPlatform() {
        if (Platform.isWindows()) {
            return Platform.is64Bits() ? win64 : win32;
        }
        if (Platform.isAndroid()) {
            return Platform.isArm() ? armeabi : linux_x86;
        }
        if (Platform.isLinux()) {
            return Platform.is64Bits() ? linux_x64 : linux_x86;
        }
        if (Platform.isSolaris()) {
            if (Platform.isSparc()) {
                return sunos_sparc;
            }
            return sunos_x86;
        }
        if (Platform.isMacOSX()) {
            return darwin_universal;
        }
        return null;
    }
}

