/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorUtils;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.string.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingNamesChooser
extends Scanner {
    final boolean renameFunctionSignatures;
    NameGenerationStyle nameGenerationStyle = NameGenerationStyle.PreserveCaseAndSeparateByUnderscores;
    Result result;
    Map<String, Integer> nextUnnamedId = new LinkedHashMap<String, Integer>();
    int nextAnonymous = 1;

    public static boolean isNamedFunctionType(TypeRef tr) {
        if (!(tr instanceof TypeRef.FunctionSignature)) {
            return false;
        }
        TypeRef.FunctionSignature fs = (TypeRef.FunctionSignature)tr;
        Function f = fs.getFunction();
        return f != null && f.getName() != null;
    }

    public MissingNamesChooser(Result result, boolean renameFunctionSignatures) {
        this.result = result;
        this.renameFunctionSignatures = renameFunctionSignatures;
    }

    protected boolean treatFunctionSignatureAsPointers() {
        return this.result.config.runtime.hasJNA;
    }

    public void setNameGenerationStyle(NameGenerationStyle nameGenerationStyle) {
        this.nameGenerationStyle = nameGenerationStyle;
    }

    public String chooseArgNameFromType(TypeRef tr) throws UnsupportedConversionException {
        if (tr instanceof TypeRef.SimpleTypeRef) {
            String out;
            Identifier name = ((TypeRef.SimpleTypeRef)tr).getName();
            out = MissingNamesChooser.isNull(name) ? ((out = StringUtils.implode((Iterable)tr.getModifiers(), (Object)"")).length() > 0 ? out.substring(0, 1) : out) : name.toString();
            return out;
        }
        if (tr instanceof TypeRef.Pointer) {
            return this.chooseArgNameFromType(((TypeRef.Pointer)tr).getTarget()) + "Ptr";
        }
        if (tr instanceof TypeRef.ArrayRef) {
            return this.chooseArgNameFromType(((TypeRef.ArrayRef)tr).getTarget()) + "Arr";
        }
        throw new UnsupportedConversionException((Element)tr, String.valueOf(tr));
    }

    public void visitFunction(Function function) {
        switch (function.getType()) {
            case CFunction: 
            case CppMethod: {
                TreeSet<String> names = new TreeSet<String>();
                ArrayList<Pair> missing = new ArrayList<Pair>();
                int i = 0;
                for (Arg arg : function.getArgs()) {
                    String name = arg.getName();
                    if (name == null && !MissingNamesChooser.isNamedFunctionType(arg.getValueType())) {
                        missing.add(new Pair((Object)arg, (Object)i));
                    } else if (name != null) {
                        names.add(name);
                    }
                    ++i;
                }
                for (Pair p : missing) {
                    String name;
                    String base;
                    i = 1;
                    if (((Arg)p.getFirst()).isVarArg()) {
                        base = "varArgs";
                    } else {
                        try {
                            base = this.chooseArgNameFromType(((Arg)p.getFirst()).getValueType());
                        }
                        catch (UnsupportedConversionException ex) {
                            base = "arg";
                        }
                    }
                    while (names.contains(name = base + i)) {
                        ++i;
                    }
                    names.add(name);
                    ((Arg)p.getFirst()).setName(name);
                }
                break;
            }
        }
        super.visitFunction(function);
    }

    static boolean isNull(Identifier i) {
        return i == null || i.resolveLastSimpleIdentifier() == null || i.resolveLastSimpleIdentifier().getName() == null;
    }

    public void visitFunctionSignature(TypeRef.FunctionSignature functionSignature) {
        Identifier origName = functionSignature.getFunction() == null ? null : functionSignature.getFunction().getName();
        Element parent = functionSignature.getParentElement();
        if (!this.renameFunctionSignatures) {
            Arg arg;
            super.visitFunctionSignature(functionSignature);
            if (functionSignature.getParentElement() instanceof Arg && (arg = (Arg)functionSignature.getParentElement()).getName() == null) {
                arg.setName(origName.toString());
                functionSignature.getFunction().setName(null);
            }
            return;
        }
        if (!this.chooseNameIfMissing(functionSignature)) {
            super.visitFunctionSignature(functionSignature);
        }
        if (parent instanceof StoredDeclarations.TypeDef || parent instanceof TypeRef.Pointer && parent.getParentElement() instanceof StoredDeclarations.TypeDef) {
            return;
        }
        DeclarationsHolder holder = (DeclarationsHolder)functionSignature.findParentOfType(DeclarationsHolder.class);
        Function f = functionSignature.getFunction();
        if (holder != null && f != null && !MissingNamesChooser.isNull(f.getName())) {
            Identifier fnameClone = f.getName().clone();
            StoredDeclarations d = (StoredDeclarations)SyntaxUtils.as((Object)parent, StoredDeclarations.class);
            if (d != null && d.getDeclarators().isEmpty()) {
                if (d instanceof VariablesDeclaration) {
                    VariablesDeclaration pvd = (VariablesDeclaration)d;
                    pvd.addDeclarator((Declarator)new Declarator.DirectDeclarator((origName == null ? fnameClone : origName).toString()));
                    functionSignature.replaceBy((Element)this.functionSignatureRef(fnameClone));
                } else {
                    d.replaceBy(null);
                }
            } else {
                functionSignature.replaceBy((Element)this.functionSignatureRef(fnameClone));
            }
            StoredDeclarations.TypeDef td = new StoredDeclarations.TypeDef();
            td.importDetails((Element)functionSignature, true);
            td.setValueType((TypeRef)functionSignature);
            td.addDeclarator((Declarator)new Declarator.DirectDeclarator(fnameClone.toString()));
            holder.addDeclaration((Declaration)td);
            td.accept((Visitor)this);
        }
    }

    TypeRef functionSignatureRef(Identifier funSigName) {
        TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef(funSigName.clone());
        return tr;
    }

    static boolean isUnnamed(TaggedTypeRefDeclaration d) {
        return d != null && d.getTaggedTypeRef() != null && MissingNamesChooser.isNull(d.getTaggedTypeRef().getTag());
    }

    Set<Identifier> listChildIdentifiers(DeclarationsHolder h) {
        ArrayList<Identifier> list = new ArrayList<Identifier>();
        for (Declaration d : h.getDeclarations()) {
            if (d instanceof Function) {
                list.add(((Function)d).getName());
                continue;
            }
            if (d instanceof TaggedTypeRefDeclaration) {
                TaggedTypeRefDeclaration td = (TaggedTypeRefDeclaration)d;
                TypeRef.TaggedTypeRef tr = td.getTaggedTypeRef();
                if (tr == null) continue;
                list.add(tr.getTag());
                continue;
            }
            if (!(d instanceof VariablesDeclaration)) continue;
            for (Declarator dc : ((VariablesDeclaration)d).getDeclarators()) {
                list.add(ElementsHelper.ident((String[])new String[]{dc.resolveName()}));
            }
        }
        HashSet<Identifier> ret = new HashSet<Identifier>();
        for (Identifier i : list) {
            if (i == null) continue;
            ret.add(i);
        }
        return ret;
    }

    List<TaggedTypeRefDeclaration> getUnnamedTaggedTypeRefs(List<Declaration> ds) {
        ArrayList<TaggedTypeRefDeclaration> ret = new ArrayList<TaggedTypeRefDeclaration>();
        for (Declaration d : ds) {
            TaggedTypeRefDeclaration td;
            TypeRef.TaggedTypeRef tr;
            if (!(d instanceof TaggedTypeRefDeclaration) || (tr = (td = (TaggedTypeRefDeclaration)d).getTaggedTypeRef()) == null || tr.getTag() != null) continue;
            ret.add(td);
        }
        return ret;
    }

    public void visitStruct(Struct struct) {
        this.fixUnNamedChildren(struct);
        super.visitStruct(struct);
    }

    private void fixUnNamedChildren(Struct struct) {
        List<TaggedTypeRefDeclaration> trs = this.getUnnamedTaggedTypeRefs(struct.getDeclarations());
        if (trs.isEmpty()) {
            return;
        }
        Set<Identifier> ids = this.listChildIdentifiers((DeclarationsHolder)struct);
        for (TaggedTypeRefDeclaration td : trs) {
            TypeRef.TaggedTypeRef tr = td.getTaggedTypeRef();
            if (!(tr instanceof Struct)) continue;
            Struct s = (Struct)tr;
            switch (s.getType()) {
                case CStruct: 
                case CUnion: {
                    Identifier fieldName;
                    String n = this.chooseNameSuffix((Element)tr);
                    int i = 1;
                    while (!ids.add(fieldName = ElementsHelper.ident((String[])new String[]{"field" + i}))) {
                        ++i;
                    }
                    td.replaceBy((Element)new VariablesDeclaration((TypeRef)tr, new Declarator[]{new Declarator.DirectDeclarator(fieldName.toString())}));
                }
            }
        }
    }

    public void visitTaggedTypeRef(TypeRef.TaggedTypeRef taggedTypeRef) {
        DeclarationsHolder holder;
        super.visitTaggedTypeRef(taggedTypeRef);
        this.chooseNameIfMissing(taggedTypeRef);
        Element parent = taggedTypeRef.getParentElement();
        if (!(parent instanceof TaggedTypeRefDeclaration || parent instanceof StoredDeclarations.TypeDef || (holder = (DeclarationsHolder)taggedTypeRef.findParentOfType(DeclarationsHolder.class)) == null || holder == taggedTypeRef.getParentElement() || parent instanceof DeclarationsHolder)) {
            TaggedTypeRefDeclaration td = new TaggedTypeRefDeclaration();
            if (parent instanceof VariablesDeclaration && ((VariablesDeclaration)parent).getDeclarators().isEmpty()) {
                taggedTypeRef.importDetails(parent, false);
                parent.replaceBy(null);
            } else {
                TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef(taggedTypeRef.getTag().clone());
                for (Modifier mod : taggedTypeRef.getModifiers()) {
                    if (!mod.isA(ModifierKind.StorageClassSpecifier)) continue;
                    tr.addModifiers(new Modifier[]{mod});
                }
                taggedTypeRef.replaceBy((Element)tr);
                if (taggedTypeRef instanceof Struct) {
                    tr.setMarkedAsResolved(true);
                }
            }
            td.setTaggedTypeRef(taggedTypeRef);
            holder.addDeclaration((Declaration)td);
        }
    }

    private boolean chooseNameIfMissing(TypeRef.FunctionSignature functionSignature) {
        Function function = functionSignature.getFunction();
        Element parent = functionSignature.getParentElement();
        if (function != null && (MissingNamesChooser.isNull(function.getName()) || parent instanceof VariablesDeclaration || parent instanceof Arg)) {
            String name = null;
            String exact = JNAeratorUtils.getExactTypeDefName((Element)functionSignature);
            if (exact != null) {
                name = exact;
            } else {
                List<String> ownerNames = JNAeratorUtils.guessOwnerName((Element)function);
                if (function.getName() != null) {
                    ownerNames.add(function.getName().toString());
                }
                name = this.chooseName((Element)functionSignature, ownerNames, true);
            }
            if (name != null) {
                function.setName(ElementsHelper.ident((String[])new String[]{name}));
                function.accept((Visitor)this);
                return true;
            }
        }
        return false;
    }

    private boolean chooseNameIfMissing(TypeRef.TaggedTypeRef taggedTypeRef) {
        if (MissingNamesChooser.isNull(taggedTypeRef.getTag()) && !(taggedTypeRef.getParentElement() instanceof TaggedTypeRefDeclaration)) {
            Identifier tag = this.result.declarationsConverter.getActualTaggedTypeName(taggedTypeRef);
            if (MissingNamesChooser.isNull(tag)) {
                List<String> ownerNames = JNAeratorUtils.guessOwnerName((Element)taggedTypeRef);
                tag = ElementsHelper.ident((String[])new String[]{this.chooseName((Element)taggedTypeRef, ownerNames, true)});
            }
            if (!MissingNamesChooser.isNull(tag)) {
                taggedTypeRef.setTag(tag.clone());
                return true;
            }
        }
        return false;
    }

    private int getNextUnnamedId(String type) {
        Integer i = this.nextUnnamedId.get(type);
        int unnamedId = i == null ? 1 : i;
        this.nextUnnamedId.put(type, unnamedId + 1);
        return unnamedId;
    }

    public String chooseName(Element e, List<String> ownerNames, boolean isType) {
        String n;
        String s = this.chooseNameSuffix(e);
        if (s == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (ownerNames != null) {
            names.addAll(ownerNames);
        }
        if (ownerNames.isEmpty()) {
            n = s + this.nextAnonymous++;
        } else {
            names.add(s);
            switch (this.nameGenerationStyle) {
                case Java: {
                    n = StringUtils.capitalize(ownerNames, (String)"");
                    break;
                }
                case PreserveCaseAndSeparateByUnderscores: {
                    n = StringUtils.implode(names, (Object)"_");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown name generation style " + (Object)((Object)this.nameGenerationStyle));
                }
            }
        }
        if (this.result.config.beautifyNames) {
            n = this.result.typeConverter.beautify(n, isType);
        }
        return n;
    }

    public String chooseNameSuffix(Element e) {
        if (e instanceof Struct) {
            Struct struct = (Struct)e;
            if (struct.getType() == Struct.Type.CStruct) {
                return "struct";
            }
            if (struct.getType() == Struct.Type.CUnion) {
                return "union";
            }
        } else {
            if (e instanceof Enum) {
                return "enum";
            }
            if (e instanceof TypeRef.FunctionSignature) {
                return "callback";
            }
        }
        return null;
    }

    static <T extends Element> T importDetails(T t, Element e, boolean move) {
        t.importDetails(e, move);
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameGenerationStyle {
        Java,
        PreserveCaseAndSeparateByUnderscores;

    }
}

