/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingUtils {
    public static TypeRef recognizeSizeOf(Expression e) {
        if (!(e instanceof Expression.FunctionCall)) {
            return null;
        }
        Expression.FunctionCall fc = (Expression.FunctionCall)e;
        List args = fc.getArguments();
        if (args.size() != 1) {
            return null;
        }
        Pair arg = (Pair)args.get(0);
        if (arg == null) {
            return null;
        }
        Expression f = fc.getFunction();
        if (!(f instanceof Expression.VariableRef)) {
            return null;
        }
        Expression.VariableRef vr = (Expression.VariableRef)f;
        if (!"sizeof".equals(String.valueOf(vr.getName()))) {
            return null;
        }
        Expression a = (Expression)arg.getSecond();
        if (!(a instanceof Expression.TypeRefExpression)) {
            return null;
        }
        Expression.TypeRefExpression tr = (Expression.TypeRefExpression)a;
        return tr.getType();
    }

    public static Pair<TypeRef, Expression> recognizeSizeOfMult(Expression e) {
        List<Expression> mult = MatchingUtils.recognizeMultiply(e);
        if (mult == null) {
            return null;
        }
        TypeRef typeRef = null;
        Expression f = null;
        for (Expression x : mult) {
            TypeRef tr = MatchingUtils.recognizeSizeOf(x);
            if (tr != null && typeRef == null) {
                typeRef = tr;
                continue;
            }
            if (f == null) {
                f = x;
                continue;
            }
            f = ElementsHelper.expr((Expression)f, (Expression.BinaryOperator)Expression.BinaryOperator.Multiply, (Expression)x);
        }
        if (typeRef == null) {
            return null;
        }
        if (f == null) {
            f = ElementsHelper.expr((int)1);
        }
        return new Pair(typeRef, (Object)f);
    }

    public static List<Expression> recognizeMultiply(Expression e) {
        ArrayList<Expression> ret = new ArrayList<Expression>();
        if (!MatchingUtils.recognizeMultiply(e, ret)) {
            return null;
        }
        return ret;
    }

    public static boolean recognizeMultiply(Expression e, List<Expression> out) {
        if (!(e instanceof Expression.BinaryOp)) {
            return false;
        }
        Expression.BinaryOp op = (Expression.BinaryOp)e;
        if (op.getOperator() != Expression.BinaryOperator.Multiply) {
            return false;
        }
        for (Expression sub : new Expression[]{op.getFirstOperand(), op.getSecondOperand()}) {
            if (MatchingUtils.recognizeMultiply(sub, out)) continue;
            out.add(sub);
        }
        return true;
    }
}

