/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAeratorUtils {
    static String getExactTypeDefName(Element e) {
        Element parent = e.getParentElement();
        if (e instanceof TypeRef.FunctionSignature && parent instanceof TypeRef.Pointer) {
            parent = parent.getParentElement();
        }
        if (parent == null || !(parent instanceof StoredDeclarations.TypeDef)) {
            return null;
        }
        StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)parent;
        return JNAeratorUtils.findBestPlainStorageName((StoredDeclarations)td);
    }

    static List<String> guessOwnerName(Element e) {
        Element parent = e.getParentElement();
        if (parent == null) {
            return null;
        }
        ArrayList<String> ns = new ArrayList<String>();
        while (parent != null && !(parent instanceof DeclarationsHolder)) {
            if (parent instanceof Arg) {
                Arg arg = (Arg)parent;
                if (arg.getName() != null) {
                    ns.add(arg.getName());
                }
            } else {
                if (parent instanceof Function) {
                    Function f = (Function)parent;
                    if (f.getName() != null) {
                        ns.add(0, f.getName().toString());
                    }
                    return ns;
                }
                if (parent instanceof StoredDeclarations) {
                    StoredDeclarations sd = (StoredDeclarations)parent;
                    String bestName = JNAeratorUtils.findBestPlainStorageName(sd);
                    if (bestName != null) {
                        ns.add(0, bestName);
                    }
                } else if (parent instanceof Expression && !ns.contains("expression")) {
                    ns.add("expression");
                }
            }
            parent = parent.getParentElement();
        }
        return ns;
    }

    public static String findBestPlainStorageName(StoredDeclarations sd) {
        if (sd == null) {
            return null;
        }
        TypeRef.TaggedTypeRef ttr = sd.getValueType() instanceof TypeRef.TaggedTypeRef ? (TypeRef.TaggedTypeRef)sd.getValueType() : null;
        String idealName = null;
        if (ttr != null && ttr.getTag() != null) {
            String tn = ttr.getTag().toString();
            if (tn.startsWith("_")) {
                idealName = tn.substring(1);
            } else {
                return tn;
            }
        }
        Declarator.DirectDeclarator plainDecl = null;
        Declarator.DirectDeclarator idealDecl = null;
        boolean plainHasNiceName = false;
        boolean hasMoreThanOnePlainDecl = false;
        for (Declarator st : sd.getDeclarators()) {
            boolean hasNiceName;
            Declarator.DirectDeclarator decl;
            String name;
            if (!(st instanceof Declarator.DirectDeclarator) || (name = (decl = (Declarator.DirectDeclarator)st).getName()) == null) continue;
            if (name.equals(idealName)) {
                idealDecl = decl;
                break;
            }
            boolean bl = hasNiceName = !decl.getName().endsWith("_") && !decl.getName().startsWith("_");
            if (hasMoreThanOnePlainDecl || plainDecl != null && (plainHasNiceName || !hasNiceName)) {
                hasMoreThanOnePlainDecl = true;
                continue;
            }
            plainDecl = decl;
            plainHasNiceName = hasNiceName;
        }
        return idealDecl != null ? idealDecl.resolveName() : (plainDecl != null && !hasMoreThanOnePlainDecl ? plainDecl.resolveName() : null);
    }
}

