/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNATypeConversion
extends TypeConversion {
    public JNATypeConversion(Result result) {
        super(result);
    }

    @Override
    public void initTypes() {
        super.initTypes();
        this.result.prim("BOOL", TypeConversion.JavaPrim.Boolean);
    }

    @Override
    public Expression getEnumItemValue(Enum.EnumItem enumItem, boolean forceConstants) {
        return ElementsHelper.cast((TypeRef)ElementsHelper.typeRef(Integer.TYPE), (Expression)this.findEnumItem(enumItem));
    }

    @Override
    protected TypeConversion.JavaPrim getCppBoolMappingType() {
        return TypeConversion.JavaPrim.Byte;
    }

    public TypeRef convertTypeToJNA(TypeRef valueType, TypeConversion.TypeConversionMode conversionMode, Identifier libraryClassName) throws UnsupportedConversionException {
        Identifier name;
        TypeConversion.JavaPrim prim;
        block95: {
            TypeConversion.JavaPrim prim2;
            TypeRef convArgType;
            boolean staticallySized;
            TypeRef target;
            block97: {
                block98: {
                    Identifier name2;
                    block99: {
                        TypeRef.SimpleTypeRef structRef;
                        boolean isQualStruct;
                        TypeRef original;
                        block96: {
                            String valueTypeString;
                            original = valueType;
                            TypeRef resolvedTypeRef = this.resolveTypeDef(valueType, libraryClassName, true, false);
                            if (resolvedTypeRef != null) {
                                valueType = resolvedTypeRef;
                            }
                            if ((valueTypeString = String.valueOf(valueType)).matches("void\\s*\\*") || valueTypeString.matches("const\\s*void\\s*\\*")) {
                                TypeRef.Pointer p;
                                if (original instanceof TypeRef.Pointer && this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.TypedPointersForForwardDeclarations) && this.allowFakePointers && (p = (TypeRef.Pointer)original).getTarget() instanceof TypeRef.SimpleTypeRef) {
                                    if (this.isResolved((TypeRef.SimpleTypeRef)p.getTarget())) {
                                        return p.getTarget();
                                    }
                                    Identifier name3 = ((TypeRef.SimpleTypeRef)p.getTarget()).getName();
                                    if (!"void".equals(name3.toString()) && name3.isPlain()) {
                                        return ElementsHelper.typeRef((Identifier)this.result.getFakePointer(libraryClassName, name3));
                                    }
                                }
                            } else if (conversionMode == TypeConversion.TypeConversionMode.ReturnType && this.result.config.stringifyConstCStringReturnValues) {
                                if (this.isString(valueTypeString, false)) {
                                    return ElementsHelper.typeRef(String.class);
                                }
                                if (this.isString(valueTypeString, true)) {
                                    return ElementsHelper.typeRef(WString.class);
                                }
                            } else if (conversionMode == TypeConversion.TypeConversionMode.PrimitiveOrBufferParameter) {
                                if (this.isString(valueTypeString, false)) {
                                    return ElementsHelper.typeRef(String.class);
                                }
                                if (this.isString(valueTypeString, true)) {
                                    return ElementsHelper.typeRef(WString.class);
                                }
                                if (this.isStringPtrPtr(valueTypeString, false)) {
                                    return this.arrayRef(ElementsHelper.typeRef(String.class));
                                }
                                if (this.isStringPtrPtr(valueTypeString, true)) {
                                    return this.arrayRef(ElementsHelper.typeRef(WString.class));
                                }
                            }
                            if (valueType instanceof TypeRef.Primitive && (prim = this.getPrimitive(valueType)) != null) {
                                return JNATypeConversion.primRef((Element)valueType, prim);
                            }
                            if (valueType instanceof TypeRef.TaggedTypeRef && (name = this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)valueType)) != null) {
                                TypeRef.SimpleTypeRef tr;
                                if (valueType instanceof Enum) {
                                    tr = this.findEnum(name, libraryClassName);
                                    if (tr != null) {
                                        TypeRef intRef = JNATypeConversion.primRef((Element)valueType, TypeConversion.JavaPrim.Int);
                                        intRef.setCommentBefore(tr.getCommentBefore());
                                        return intRef;
                                    }
                                } else if (valueType instanceof Struct && (tr = this.findStructRef(name, libraryClassName)) != null) {
                                    switch (conversionMode) {
                                        case PointedValue: 
                                        case NativeParameterWithStructsPtrPtrs: 
                                        case NativeParameter: 
                                        case PrimitiveOrBufferParameter: 
                                        case ReturnType: 
                                        case PrimitiveReturnType: 
                                        case FieldType: {
                                            return tr;
                                        }
                                    }
                                    return ElementsHelper.subType((TypeRef.SimpleTypeRef)tr, (Identifier)ElementsHelper.ident((String[])new String[]{"ByValue"}));
                                }
                            }
                            if (valueType instanceof TypeRef.FunctionSignature) {
                                TypeRef tr = this.findCallbackRef((TypeRef.FunctionSignature)valueType, libraryClassName);
                                if (tr != null) {
                                    return tr;
                                }
                                return ElementsHelper.typeRef((Identifier)((TypeRef.FunctionSignature)valueType).getFunction().getName().clone());
                            }
                            if (!(valueType instanceof TypeRef.TargettedTypeRef)) break block95;
                            target = ((TypeRef.TargettedTypeRef)valueType).getTarget();
                            staticallySized = valueType instanceof TypeRef.ArrayRef && ((TypeRef.ArrayRef)valueType).hasStaticStorageSize();
                            convArgType = null;
                            prim2 = this.getPrimitive(target);
                            if (prim2 == null) break block96;
                            if (prim2 == TypeConversion.JavaPrim.Void) {
                                return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                            }
                            convArgType = JNATypeConversion.primRef((Element)valueType, prim2);
                            break block97;
                        }
                        name2 = null;
                        if (target instanceof TypeRef.SimpleTypeRef) {
                            name2 = ((TypeRef.SimpleTypeRef)target).getName();
                        } else if (target instanceof Struct) {
                            Struct struct = (Struct)target;
                            if (struct == null) {
                                valueType = this.resolveTypeDef(original, libraryClassName, true, false);
                                struct = null;
                            } else {
                                name2 = this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)struct);
                            }
                        } else if (target instanceof TypeRef.FunctionSignature) {
                            TypeRef tr = this.findCallbackRef((TypeRef.FunctionSignature)target, libraryClassName);
                            if (tr != null) {
                                if (valueType instanceof TypeRef.ArrayRef) {
                                    return new TypeRef.ArrayRef(tr, new Expression[0]);
                                }
                                return ElementsHelper.typeRef(PointerByReference.class);
                            }
                        } else if (target instanceof TypeRef.Pointer) {
                            if (conversionMode == TypeConversion.TypeConversionMode.NativeParameter) {
                                return ElementsHelper.typeRef(PointerByReference.class);
                            }
                            TypeRef.Pointer pt = (TypeRef.Pointer)target;
                            TypeRef ptarget = pt.getTarget();
                            if (ptarget instanceof TypeRef.SimpleTypeRef) {
                                TypeRef.SimpleTypeRef ptargett = (TypeRef.SimpleTypeRef)ptarget;
                                Identifier tname = ptargett.getName();
                                if (this.result.structsFullNames.contains(tname)) {
                                    return new TypeRef.ArrayRef((TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Identifier)ptargett.getName(), (String)"ByReference")), new Expression[0]);
                                }
                                if ((tname = this.result.findFakePointer(tname)) != null) {
                                    return new TypeRef.ArrayRef((TypeRef)ElementsHelper.typeRef((Identifier)tname.clone()), new Expression[0]);
                                }
                            }
                        }
                        if (name2 == null) break block98;
                        if (this.result.isFakePointer(name2)) {
                            if (conversionMode == TypeConversion.TypeConversionMode.NativeParameter) {
                                return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                            }
                            return ElementsHelper.typeRef(PointerByReference.class);
                        }
                        if (this.result.callbacksFullNames.contains(name2)) {
                            return ElementsHelper.typeRef((Identifier)name2.clone());
                        }
                        convArgType = this.findObjCClass(name2);
                        boolean bl = isQualStruct = this.result.structsFullNames.contains(name2) || this.result.objectiveCClassesFullNames.contains(name2);
                        if (convArgType != null && !isQualStruct) break block97;
                        TypeRef.SimpleTypeRef simpleTypeRef = structRef = isQualStruct ? ElementsHelper.typeRef((Identifier)name2) : this.findStructRef(name2, libraryClassName);
                        if (structRef == null) break block99;
                        switch (conversionMode) {
                            case FieldType: 
                            case ExpressionType: {
                                Object object = convArgType = valueType instanceof TypeRef.ArrayRef ? structRef : ElementsHelper.subType((TypeRef.SimpleTypeRef)structRef, (Identifier)ElementsHelper.ident((String[])new String[]{"ByReference"}));
                                if (valueType instanceof TypeRef.Pointer) {
                                    return convArgType;
                                }
                                break block97;
                            }
                            default: {
                                if (isQualStruct && valueType instanceof TypeRef.ArrayRef && (conversionMode == TypeConversion.TypeConversionMode.NativeParameterWithStructsPtrPtrs || conversionMode == TypeConversion.TypeConversionMode.PrimitiveOrBufferParameter)) {
                                    return this.arrayRef((TypeRef)structRef);
                                }
                                convArgType = structRef;
                                if (valueType instanceof TypeRef.Pointer) {
                                    return convArgType;
                                }
                                break block97;
                            }
                        }
                    }
                    try {
                        TypeConversion.TypeConversionMode targettedConversionMode;
                        switch (conversionMode) {
                            case NativeParameterWithStructsPtrPtrs: 
                            case NativeParameter: 
                            case PrimitiveOrBufferParameter: 
                            case PrimitiveReturnType: {
                                targettedConversionMode = TypeConversion.TypeConversionMode.PointedValue;
                                break;
                            }
                            default: {
                                targettedConversionMode = conversionMode;
                            }
                        }
                        convArgType = this.convertTypeToJNA(target, targettedConversionMode, libraryClassName);
                        if (convArgType != null && this.result.callbacksFullNames.contains(ElementsHelper.ident((String[])new String[]{convArgType.toString()})) && !(valueType instanceof TypeRef.ArrayRef)) {
                            TypeRef tr = ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                            if (!this.result.config.noComments) {
                                tr.setCommentBefore("@see " + convArgType);
                            }
                            return tr;
                        }
                        prim2 = this.getPrimitive(convArgType);
                    }
                    catch (UnsupportedConversionException ex) {
                        if (valueType instanceof TypeRef.Pointer && target instanceof TypeRef.SimpleTypeRef && this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.TypedPointersForForwardDeclarations) && this.allowFakePointers) {
                            if (this.isResolved((TypeRef.SimpleTypeRef)target)) {
                                return target;
                            }
                            return ElementsHelper.typeRef((Identifier)this.result.getFakePointer(libraryClassName, name2));
                        }
                        return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                    }
                }
                try {
                    convArgType = this.convertTypeToJNA(target, conversionMode, libraryClassName);
                    prim2 = this.getPrimitive(convArgType);
                }
                catch (UnsupportedConversionException ex) {
                    return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                }
            }
            switch (conversionMode) {
                case StaticallySizedArrayField: {
                    return new TypeRef.ArrayRef(convArgType, new Expression[0]);
                }
                case PrimitiveOrBufferParameter: {
                    if (!this.result.config.noPrimitiveArrays && (target.getModifiers().contains(ModifierType.Const) || valueType.getModifiers().contains(ModifierType.Const))) {
                        return new TypeRef.ArrayRef(convArgType, new Expression[0]);
                    }
                    Class bc = (Class)this.primToBuffer.get((Object)prim2);
                    if (bc != null) {
                        return ElementsHelper.typeRef((Class)bc);
                    }
                }
                case ReturnType: 
                case FieldType: {
                    if (!staticallySized) break;
                    return this.arrayRef(convArgType);
                }
            }
            if (prim2 != null) {
                if (prim2 == TypeConversion.JavaPrim.Byte) {
                    return (TypeRef)ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass).importComments((Element)convArgType, new String[0]);
                }
                Class byRefClass = (Class)this.primToByReference.get((Object)prim2);
                if (byRefClass != null) {
                    return ElementsHelper.typeRef((Class)byRefClass).importDetails((Element)convArgType, false);
                }
            }
            if (convArgType != null && !convArgType.toString().equals(this.result.config.runtime.pointerClass.getName()) && valueType instanceof TypeRef.Pointer && target instanceof TypeRef.SimpleTypeRef) {
                return convArgType;
            }
            if (target instanceof TypeRef.Pointer) {
                return ElementsHelper.typeRef(PointerByReference.class);
            }
            if (this.allowUnknownPointers) {
                return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
            }
        }
        if (valueType instanceof TypeRef.SimpleTypeRef) {
            name = ((TypeRef.SimpleTypeRef)valueType).getName();
            if (name == null) {
                throw new UnsupportedConversionException((Element)valueType, null);
            }
            boolean isQualStruct = this.result.structsFullNames.contains(name);
            TypeRef.SimpleTypeRef structRef = null;
            if (!isQualStruct && valueType instanceof TypeRef.SimpleTypeRef && this.isResolved((TypeRef.SimpleTypeRef)valueType)) {
                structRef = (TypeRef.SimpleTypeRef)valueType;
            } else {
                if (name instanceof Identifier.SimpleIdentifier) {
                    TypeRef tr = this.findObjCClass(name);
                    if (tr == null) {
                        tr = this.findObjCClass((Identifier)new Identifier.SimpleIdentifier(((Identifier.SimpleIdentifier)name).getName(), new Expression[0]));
                    }
                    if (tr != null) {
                        return tr;
                    }
                }
                TypeRef.SimpleTypeRef simpleTypeRef = structRef = isQualStruct ? ElementsHelper.typeRef((Identifier)name) : this.findStructRef(name, libraryClassName);
            }
            if (structRef != null) {
                isQualStruct = this.result.structsFullNames.contains(structRef.getName());
                switch (conversionMode) {
                    case PointedValue: {
                        if (!isQualStruct || !this.isResolved(structRef)) {
                            return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                        }
                    }
                    case FieldType: {
                        return structRef;
                    }
                    case NativeParameterWithStructsPtrPtrs: 
                    case NativeParameter: {
                        if (!this.result.isFakePointer(name)) break;
                        return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                    }
                }
                if (isQualStruct) {
                    return ElementsHelper.subType((TypeRef.SimpleTypeRef)structRef, (Identifier)ElementsHelper.ident((String[])new String[]{"ByValue"}));
                }
                return structRef;
            }
            TypeRef callbackRef = this.findCallbackRef(name, libraryClassName);
            if (callbackRef != null) {
                return callbackRef;
            }
            TypeRef.SimpleTypeRef enumTypeRef = this.findEnum(name, libraryClassName);
            if (enumTypeRef != null) {
                return enumTypeRef;
            }
            TypeRef objCClassRef = this.findObjCClass(name);
            if (objCClassRef != null) {
                return objCClassRef;
            }
        }
        if ((prim = this.getPrimitive(valueType)) != null) {
            return JNATypeConversion.primRef((Element)valueType, prim);
        }
        if (valueType instanceof TypeRef.SimpleTypeRef && this.allowFakePointers) {
            return ElementsHelper.typeRef((Identifier)this.result.getFakePointer(libraryClassName, ((TypeRef.SimpleTypeRef)valueType).getName().clone()));
        }
        this.unknownTypes.add(String.valueOf(valueType));
        throw new UnsupportedConversionException((Element)valueType, null);
    }

    @Override
    public Pair<Expression, TypeRef> convertExpressionToJava(Expression x, Identifier libraryClassName, boolean promoteNativeLongToLong, boolean forceConstant, Map<String, Pair<Expression, TypeRef>> mappings) throws UnsupportedConversionException {
        if (x instanceof Expression.Cast) {
            TypeRef tpe = ((Expression.Cast)x).getType();
            Pair<Expression, TypeRef> casted = this.convertExpressionToJava(((Expression.Cast)x).getTarget(), libraryClassName, promoteNativeLongToLong, forceConstant, mappings);
            TypeRef tr = this.convertTypeToJNA(tpe, TypeConversion.TypeConversionMode.ExpressionType, libraryClassName);
            if (tr instanceof TypeConversion.JavaPrimitive) {
                Expression val = (Expression)casted.getFirst();
                return JNATypeConversion.typed(val, tr);
            }
        } else if (x instanceof Expression.TypeRefExpression) {
            TypeRef.SimpleTypeRef str;
            Identifier ident;
            Expression.TypeRefExpression tre = (Expression.TypeRefExpression)x;
            TypeRef tr = tre.getType();
            if (tr instanceof TypeRef.SimpleTypeRef && (ident = (str = (TypeRef.SimpleTypeRef)tr).getName()) != null && this.result.enumItemsFullName.contains(ident)) {
                return JNATypeConversion.typed((Expression)tre, ElementsHelper.typeRef(Integer.TYPE));
            }
            if (tr.isMarkedAsResolved()) {
                return JNATypeConversion.typed((Expression)tre, tr);
            }
            TypeRef conv = this.convertTypeToJNA(tr, TypeConversion.TypeConversionMode.ExpressionType, libraryClassName);
            return JNATypeConversion.typed((Expression)new Expression.TypeRefExpression(conv), conv);
        }
        return super.convertExpressionToJava(x, libraryClassName, promoteNativeLongToLong, forceConstant, mappings);
    }

    public TypeRef resolveTypeDef(TypeRef valueType, Identifier libraryClassName, boolean convertToJavaRef, boolean convertEnumToJavaRef) {
        return this.resolveTypeDef(valueType, libraryClassName, convertToJavaRef, convertEnumToJavaRef, new HashSet<Identifier>());
    }

    protected TypeRef resolveTypeDef(TypeRef valueType, final Identifier libraryClassName, final boolean convertToJavaRef, final boolean convertEnumToJavaRef, final Set<Identifier> typeDefsEncountered) {
        TypeRef.TaggedTypeRef ttr;
        if (valueType == null) {
            return null;
        }
        if (valueType instanceof TypeRef.TaggedTypeRef && convertToJavaRef && (ttr = (TypeRef.TaggedTypeRef)valueType).getTag() != null) {
            TypeRef.SimpleTypeRef ref;
            TypeRef.SimpleTypeRef simpleTypeRef = ttr instanceof Struct ? this.findStructRef(ttr.getTag(), libraryClassName) : (ref = ttr instanceof Enum && convertEnumToJavaRef ? this.findEnum(ttr.getTag(), libraryClassName) : null);
            if (ref == null && convertEnumToJavaRef) {
                return ref;
            }
        }
        TypeRef valueTypeCl = valueType.clone();
        Arg holder = new Arg();
        holder.setValueType(valueTypeCl);
        holder.setParentElement(valueType.getParentElement());
        holder.accept((Visitor)new Scanner(){
            Stack<String> names = new Stack();
            int depth = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void visitSimpleTypeRef(TypeRef.SimpleTypeRef simpleTypeRef) {
                ++this.depth;
                try {
                    Identifier name = simpleTypeRef.getName();
                    if (name == null) {
                        return;
                    }
                    String nameStr = name.toString();
                    if (nameStr == null) {
                        return;
                    }
                    if (TypeConversion.JavaPrim.getJavaPrim(nameStr) != null) {
                        return;
                    }
                    if (this.names.contains(nameStr)) {
                        return;
                    }
                    this.names.push(nameStr);
                    try {
                        Identifier name2;
                        Expression expression;
                        TypeRef t;
                        if (JNATypeConversion.this.result.resolvePrimitive(nameStr) != null) {
                            return;
                        }
                        super.visitSimpleTypeRef(simpleTypeRef);
                        if (simpleTypeRef.isMarkedAsResolved()) {
                            return;
                        }
                        if (convertToJavaRef && (t = JNATypeConversion.this.findTypeRef(name, libraryClassName)) != null) {
                            if (!convertToJavaRef) return;
                            if (t instanceof Enum && !convertEnumToJavaRef) {
                                return;
                            }
                            simpleTypeRef.replaceBy((Element)t);
                            return;
                        }
                        Define define = JNATypeConversion.this.result.defines.get(name);
                        Expression expression2 = expression = define == null ? null : define.getValue();
                        if (expression != null) {
                            if (!convertToJavaRef) {
                                return;
                            }
                            Identifier fieldName = null;
                            if (expression instanceof Expression.VariableRef) {
                                fieldName = ((Expression.VariableRef)expression).getName();
                            } else if (expression instanceof Expression.MemberRef) {
                                fieldName = ((Expression.MemberRef)expression).getName();
                            }
                            if (fieldName != null && !fieldName.equals((Object)name)) {
                                simpleTypeRef.replaceBy((Element)JNATypeConversion.this.resolveTypeDef((TypeRef)new TypeRef.SimpleTypeRef(fieldName), libraryClassName, true, convertEnumToJavaRef, typeDefsEncountered));
                                return;
                            }
                        }
                        TypeRef tr = typeDefsEncountered.add(name) ? JNATypeConversion.this.result.getTypeDef(name) : null;
                        if (tr == null) return;
                        if (!JNATypeConversion.this.isResoluble(tr, libraryClassName)) {
                            if (convertToJavaRef) {
                                simpleTypeRef.replaceBy((Element)ElementsHelper.typeRef((Identifier)JNATypeConversion.this.result.getFakePointer(libraryClassName, name)));
                                return;
                            }
                            simpleTypeRef.replaceBy((Element)JNATypeConversion.this.resolveTypeDef(tr.clone(), libraryClassName, convertToJavaRef, convertEnumToJavaRef, typeDefsEncountered));
                            return;
                        }
                        if (tr instanceof Enum && !convertEnumToJavaRef) {
                            simpleTypeRef.replaceBy((Element)ElementsHelper.typeRef(Integer.TYPE));
                            return;
                        }
                        if (tr instanceof TypeRef.TaggedTypeRef && (name2 = JNATypeConversion.this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)tr)) != null) {
                            name = name2;
                        }
                        if (convertToJavaRef) {
                            if (tr instanceof TypeRef.TaggedTypeRef) {
                                TypeRef.TaggedTypeRef s = (TypeRef.TaggedTypeRef)tr;
                                if (s.isForwardDeclaration()) {
                                    return;
                                }
                                Identifier ident = JNATypeConversion.this.getTaggedTypeIdentifierInJava(s);
                                if (ident != null) {
                                    tr = ElementsHelper.typeRef((Identifier)ident);
                                }
                            } else if (tr instanceof TypeRef.FunctionSignature) {
                                tr = JNATypeConversion.this.findCallbackRef((TypeRef.FunctionSignature)tr, libraryClassName);
                            }
                        }
                        String strs = simpleTypeRef.toString();
                        String trs = tr == null ? null : tr.toString();
                        if (trs == null) return;
                        if (strs.equals(trs)) return;
                        TypeRef clo = tr.clone();
                        simpleTypeRef.replaceBy((Element)clo);
                        if (this.depth < 30) {
                            clo.accept((Visitor)this);
                            return;
                        }
                        System.err.println("Infinite loop in type conversion ? " + tr);
                        return;
                    }
                    finally {
                        this.names.pop();
                    }
                }
                finally {
                    --this.depth;
                }
            }
        });
        TypeRef tr = holder.getValueType();
        TypeRef resolved = tr == null ? null : tr.clone();
        return resolved;
    }

    boolean isResoluble(TypeRef tr, Identifier libraryClassName) {
        return this.isResoluble(tr, libraryClassName, new HashSet<Identifier>());
    }

    boolean isResoluble(TypeRef tr, Identifier libraryClassName, Set<Identifier> typeDefsEncountered) {
        if (tr instanceof TypeRef.Primitive || tr instanceof TypeRef.FunctionSignature || tr instanceof TypeRef.TaggedTypeRef) {
            return true;
        }
        if (tr instanceof TypeRef.TargettedTypeRef) {
            return this.isResoluble(((TypeRef.TargettedTypeRef)tr).getTarget(), libraryClassName, typeDefsEncountered);
        }
        if (tr instanceof TypeRef.SimpleTypeRef) {
            TypeRef tdt;
            Identifier name = ((TypeRef.SimpleTypeRef)tr).getName();
            TypeRef typeRef = tdt = typeDefsEncountered.add(name) ? this.result.getTypeDef(name) : null;
            if (tdt != null) {
                return this.isResoluble(tdt, libraryClassName, typeDefsEncountered);
            }
            TypeRef ft = this.findTypeRef(name, libraryClassName);
            return ft != null;
        }
        return false;
    }
}

