/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorUtils;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.EmptyDeclaration;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.FriendDeclaration;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Printer;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.lang.jnaerator.runtime.VirtualTablePointer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.bridj.ann.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeclarationsConverter {
    protected static final String DEFAULT_VPTR_NAME = "_vptr";
    protected final Result result;
    static Map<Class<?>, Pair<List<Pair<Function, String>>, Set<String>>> cachedForcedMethodsAndTheirSignatures;
    Map<String, Pair<Function, List<Function>>> functionAlternativesByNativeSignature = new LinkedHashMap<String, Pair<Function, List<Function>>>();

    public DeclarationsConverter(Result result) {
        this.result = result;
    }

    protected static boolean isVarArgs(Arg arg) {
        if (arg.isVarArg()) {
            return true;
        }
        String t = arg.getValueType() + "";
        return t.equals("va_list") || t.equals("__builtin_va_list") || t.equals("__gnuc_va_list");
    }

    public void convertCallback(TypeRef.FunctionSignature functionSignature, Signatures signatures, DeclarationsHolder out, Identifier libraryClass) {
        Struct decl = this.convertCallback(functionSignature, signatures, libraryClass);
        if (decl != null) {
            out.addDeclaration((Declaration)new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)decl));
        }
    }

    public Struct convertCallback(TypeRef.FunctionSignature functionSignature, Signatures signatures, Identifier callerLibraryName) {
        Identifier name = this.result.typeConverter.inferCallBackName(functionSignature, true, false, callerLibraryName);
        if (name == null) {
            return null;
        }
        name = this.result.typeConverter.getValidJavaArgumentName(name);
        Function function = functionSignature.getFunction();
        int i = 1;
        Identifier chosenName = name;
        while (!signatures.addClass(chosenName)) {
            chosenName = ElementsHelper.ident((String[])new String[]{name.toString() + ++i});
        }
        Element parent = functionSignature.getParentElement();
        TypeRef.FunctionSignature comel = parent != null && parent instanceof StoredDeclarations.TypeDef ? parent : functionSignature;
        Struct callbackStruct = new Struct();
        this.configureCallbackStruct(callbackStruct);
        callbackStruct.setTag(ElementsHelper.ident((Identifier)chosenName, (Identifier[])new Identifier[0]));
        if (!this.result.config.noComments) {
            callbackStruct.addToCommentBefore(new String[]{comel.getCommentBefore(), comel.getCommentAfter(), this.getFileCommentContent((Element)comel)});
        }
        this.convertFunction(function, new Signatures(), true, (DeclarationsHolder)callbackStruct, (DeclarationsHolder)callbackStruct, callerLibraryName, -1);
        for (Declaration d : callbackStruct.getDeclarations()) {
            if (!(d instanceof Function)) continue;
            callbackStruct.addAnnotations(callbackStruct.getAnnotations());
            callbackStruct.setAnnotations(null);
            break;
        }
        return callbackStruct;
    }

    public void convertCallbacks(List<TypeRef.FunctionSignature> functionSignatures, Signatures signatures, DeclarationsHolder out, Identifier libraryClass) {
        if (functionSignatures != null) {
            for (TypeRef.FunctionSignature functionSignature : functionSignatures) {
                Arg a;
                if (functionSignature.findParentOfType(Struct.class) != null || (a = (Arg)functionSignature.findParentOfType(Arg.class)) != null && a.getParentElement() == null) continue;
                this.convertCallback(functionSignature, signatures, out, libraryClass);
            }
        }
    }

    protected abstract void configureCallbackStruct(Struct var1);

    protected abstract Struct createFakePointerClass(Identifier var1);

    public void convertConstants(String library, List<Define> defines, Element sourcesRoot, final Signatures signatures, final DeclarationsHolder out) {
        final Map<String, String> constants = Result.getMap(this.result.stringConstants, library);
        sourcesRoot.accept((Visitor)new Scanner(){

            public void visitVariablesDeclaration(VariablesDeclaration v) {
                super.visitVariablesDeclaration(v);
                if (v.findParentOfType(Struct.class) != null) {
                    return;
                }
                if (v.getValueType() instanceof TypeRef.FunctionSignature) {
                    return;
                }
                for (Declarator decl : v.getDeclarators()) {
                    TypeRef mutatedType;
                    if (!(decl instanceof Declarator.DirectDeclarator) || (mutatedType = (TypeRef)decl.mutateTypeKeepingParent((Declarator.MutableByDeclarator)v.getValueType())) == null || !mutatedType.getModifiers().contains(ModifierType.Const) || mutatedType.getModifiers().contains(ModifierType.Extern) || decl.getDefaultValue() == null) continue;
                    String name = decl.resolveName();
                    TypeConversion.JavaPrim prim = DeclarationsConverter.this.result.typeConverter.getPrimitive(mutatedType);
                    if (prim == null) {
                        String value;
                        if (!mutatedType.toString().contains("NSString") || (value = (String)constants.get(name)) == null) continue;
                        DeclarationsConverter.this.outputNSString(name, value, out, signatures, new Element[]{v, decl});
                        continue;
                    }
                    try {
                        DeclarationsConverter.this.convertConstant(name, prim, mutatedType, decl.getDefaultValue(), v, decl, out, signatures, out.getResolvedJavaIdentifier());
                    }
                    catch (UnsupportedConversionException ex) {
                        out.addDeclaration((Declaration)DeclarationsConverter.this.skipDeclaration((Element)decl, ex.getMessage()));
                    }
                }
            }
        });
        if (defines != null) {
            for (Define define : this.reorderDefines(defines)) {
                if (define.getValue() == null) continue;
                try {
                    this.convertDefine(define, out, signatures, out.getResolvedJavaIdentifier());
                }
                catch (UnsupportedConversionException ex) {
                    out.addDeclaration((Declaration)this.skipDeclaration((Element)define, ex.toString()));
                }
            }
        }
        for (Map.Entry<String, String> e : constants.entrySet()) {
            this.outputNSString(e.getKey(), e.getValue(), out, signatures, new Element[0]);
        }
    }

    protected void convertConstant(String name, TypeConversion.JavaPrim prim, TypeRef mutatedType, Expression defaultValue, VariablesDeclaration v, Declarator decl, DeclarationsHolder out, Signatures signatures, Identifier libraryClassName) {
        try {
            Pair<Expression, TypeRef> val = this.result.typeConverter.convertExpressionToJava(defaultValue, libraryClassName, true, false, null);
            if (!signatures.addVariable(name)) {
                return;
            }
            TypeRef.SimpleTypeRef tr = prim == TypeConversion.JavaPrim.NativeLong || prim == TypeConversion.JavaPrim.NativeSize ? ElementsHelper.typeRef((String)"long") : TypeConversion.primRef((Element)v, prim);
            VariablesDeclaration vd = new VariablesDeclaration((TypeRef)tr, new Declarator[]{new Declarator.DirectDeclarator(name, (Expression)val.getFirst())});
            if (!this.result.config.noComments) {
                vd.setCommentBefore(v.getCommentBefore());
                vd.addToCommentBefore(new String[]{decl.getCommentBefore()});
                vd.addToCommentBefore(new String[]{decl.getCommentAfter()});
                vd.addToCommentBefore(new String[]{v.getCommentAfter()});
            }
            vd.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Final});
            out.addDeclaration((Declaration)vd);
        }
        catch (UnsupportedConversionException e) {
            out.addDeclaration((Declaration)this.skipDeclaration((Element)v, e.toString()));
        }
    }

    protected void convertDefine(Define define, DeclarationsHolder out, Signatures signatures, Identifier libraryClassName) {
        out.addDeclaration(this.outputConstant(define.getName(), define.getValue(), signatures, (Element)define.getValue(), "define", libraryClassName, true, false, false));
    }

    protected void outputNSString(String name, String value, DeclarationsHolder out, Signatures signatures, Element ... elementsToTakeCommentsFrom) {
        if (!signatures.addVariable(name)) {
            return;
        }
        TypeRef tr = ElementsHelper.typeRef(String.class);
        VariablesDeclaration vd = new VariablesDeclaration(tr, new Declarator[]{new Declarator.DirectDeclarator(name, ElementsHelper.expr((String)value))});
        if (!this.result.config.noComments) {
            for (Element e : elementsToTakeCommentsFrom) {
                vd.addToCommentBefore(new String[]{e.getCommentBefore()});
                vd.addToCommentBefore(new String[]{e.getCommentAfter()});
            }
        }
        vd.addModifiers(new Modifier[]{ModifierType.Public});
        out.addDeclaration((Declaration)vd);
    }

    public static synchronized Pair<List<Pair<Function, String>>, Set<String>> getMethodsAndTheirSignatures(Class<?> originalLib) {
        Pair pair;
        if (cachedForcedMethodsAndTheirSignatures == null) {
            cachedForcedMethodsAndTheirSignatures = new LinkedHashMap();
        }
        if ((pair = cachedForcedMethodsAndTheirSignatures.get(originalLib)) == null) {
            pair = new Pair(new ArrayList(), new HashSet());
            for (Method m : originalLib.getDeclaredMethods()) {
                Function f = Function.fromMethod((Method)m);
                String sig = f.computeSignature(Function.SignatureType.JavaStyle);
                ((List)pair.getFirst()).add(new Pair((Object)f, (Object)sig));
                ((Set)pair.getSecond()).add(sig);
            }
        }
        return pair;
    }

    public void addMissingMethods(Class<?> originalLib, Signatures existingSignatures, Struct outputLib) {
        for (Pair f : (List)DeclarationsConverter.getMethodsAndTheirSignatures(originalLib).getFirst()) {
            if (!existingSignatures.addMethod((String)f.getSecond())) continue;
            outputLib.addDeclaration((Declaration)((Function)f.getFirst()).clone());
        }
    }

    public EmptyDeclaration skipDeclaration(Element e, String ... preMessages) {
        if (this.result.config.limitComments) {
            return null;
        }
        ArrayList<String> mess = new ArrayList<String>();
        if (preMessages != null) {
            mess.addAll(Arrays.asList(preMessages));
        }
        mess.addAll(Arrays.asList("SKIPPED:", new Printer(null).formatComments(e, true, true, false, new String[0]).toString(), this.getFileCommentContent(e), e.toString().replace("*/", "* /")));
        return new EmptyDeclaration(mess.toArray(new String[0]));
    }

    public abstract void convertEnum(Enum var1, Signatures var2, DeclarationsHolder var3, Identifier var4);

    protected void outputEnumItemsAsConstants(Map<String, TypeConversion.EnumItemResult> results, DeclarationsHolder out, Signatures signatures, Identifier libraryClassName, boolean hasEnumClass) {
        for (TypeConversion.EnumItemResult er : results.values()) {
            try {
                if (er.errorElement != null) {
                    out.addDeclaration(er.errorElement);
                    continue;
                }
                String itemName = this.result.typeConverter.getValidJavaIdentifierString(ElementsHelper.ident((String[])new String[]{er.originalItem.getName()}));
                Declaration ct = this.outputConstant(itemName, this.result.typeConverter.convertExpressionToJava(er.unconvertedValue, libraryClassName, true, false, null), signatures, (Element)er.originalItem, "enum item", libraryClassName, hasEnumClass, true, true, true);
                out.addDeclaration(ct);
            }
            catch (Exception ex) {
                out.addDeclaration((Declaration)this.skipDeclaration((Element)er.originalItem, ex.toString()));
            }
        }
    }

    protected Declaration outputConstant(String name, Expression x, Signatures signatures, Element element, String elementTypeDescription, Identifier libraryClassName, boolean addFileComment, boolean signalErrors, boolean forceInteger) throws UnsupportedConversionException {
        return this.outputConstant(name, TypeConversion.pair(x, null), signatures, element, elementTypeDescription, libraryClassName, addFileComment, signalErrors, forceInteger, false);
    }

    protected Declaration outputConstant(String name, Pair<Expression, TypeRef> x, Signatures signatures, Element element, String elementTypeDescription, Identifier libraryClassName, boolean addFileComment, boolean signalErrors, boolean forceInteger, boolean alreadyConverted) throws UnsupportedConversionException {
        try {
            if (this.result.typeConverter.isJavaKeyword(name)) {
                throw new UnsupportedConversionException(element, "The name '" + name + "' is invalid for a Java field.");
            }
            Pair<Expression, TypeRef> converted = alreadyConverted ? x : this.result.typeConverter.convertExpressionToJava((Expression)x.getFirst(), libraryClassName, true, false, null);
            TypeConversion.JavaPrim prim = this.result.typeConverter.getPrimitive((TypeRef)converted.getValue());
            if (forceInteger && prim == TypeConversion.JavaPrim.Boolean) {
                prim = TypeConversion.JavaPrim.Int;
                converted = TypeConversion.pair(ElementsHelper.expr((int)("true".equals(String.valueOf(converted.toString())) ? 1 : 0)), ElementsHelper.typeRef(Integer.TYPE));
            }
            if ((prim == null || converted.getValue() == null) && signalErrors) {
                if (this.result.config.limitComments) {
                    return null;
                }
                return new EmptyDeclaration(new String[]{"Failed to infer type of " + converted});
            }
            if (prim != TypeConversion.JavaPrim.Void && converted.getValue() != null && signatures.addVariable(name)) {
                String t = converted.toString();
                if (t.contains("sizeof")) {
                    converted = alreadyConverted ? x : this.result.typeConverter.convertExpressionToJava((Expression)x.getFirst(), libraryClassName, false, false, null);
                }
                TypeRef tr = (TypeRef)converted.getValue();
                Expression value = (Expression)converted.getFirst();
                if (this.result.config.castConstants && !alreadyConverted) {
                    if (!(value instanceof Expression.Constant) && !(value instanceof Expression.VariableRef)) {
                        value.setParenthesis(true);
                    }
                    value = new Expression.Cast(tr, value);
                }
                VariablesDeclaration declaration = new VariablesDeclaration(tr, new Declarator[]{new Declarator.DirectDeclarator(name, value)});
                declaration.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Final});
                if (!this.result.config.noComments) {
                    declaration.importComments(element, new String[]{addFileComment ? this.getFileCommentContent(element) : null});
                }
                return declaration;
            }
            return this.skipDeclaration(element, elementTypeDescription);
        }
        catch (UnsupportedConversionException e) {
            return this.skipDeclaration(element, elementTypeDescription, e.toString());
        }
    }

    public void convertEnums(List<Enum> enums, Signatures signatures, DeclarationsHolder out) {
        Identifier libraryClassName = out.getResolvedJavaIdentifier();
        if (enums != null) {
            for (Enum e : enums) {
                if (e.findParentOfType(Struct.class) != null || this.skip(e.getTag() + "", this.result.config.skippedEnumNames)) continue;
                this.convertEnum(e, signatures, out, libraryClassName);
            }
        }
    }

    static <E extends Element> E cleanClone(E e) {
        Element c = e.clone();
        c.setCommentBefore(null);
        c.setCommentAfter(null);
        if (c instanceof Declaration) {
            Declaration d = (Declaration)c;
            d.setAnnotations(null);
        }
        return (E)c;
    }

    void throwBadRuntime() {
        throw new RuntimeException("Unhandled runtime : " + this.result.config.runtime.name());
    }

    protected abstract void convertFunction(Function var1, Signatures var2, boolean var3, DeclarationsHolder var4, DeclarationsHolder var5, Identifier var6, String var7, Identifier var8, String var9, int var10);

    public void convertFunction(Function function, Signatures signatures, boolean isCallback, final DeclarationsHolder declarations, final DeclarationsHolder implementations, Identifier libraryClassName, int iConstructor) {
        block10: {
            if (this.result.config.functionsAccepter != null && !((Boolean)this.result.config.functionsAccepter.adapt((Object)function)).booleanValue()) {
                return;
            }
            String library = this.result.getLibrary((Element)function);
            Identifier functionName = function.getName();
            boolean isMethod = function.getParentElement() instanceof Struct;
            if (functionName == null || isCallback) {
                if (function.getParentElement() instanceof TypeRef.FunctionSignature) {
                    functionName = ElementsHelper.ident((String[])new String[]{this.result.config.callbackInvokeMethodName});
                } else {
                    return;
                }
            }
            if (function.getParentElement() instanceof FriendDeclaration) {
                return;
            }
            String n = functionName.toString();
            if (n.contains("<") || n.startsWith("~")) {
                return;
            }
            if (this.result.config.beautifyNames) {
                functionName = ElementsHelper.ident((String[])new String[]{this.result.typeConverter.beautify(n, false)});
            }
            if ((functionName = this.result.typeConverter.getValidJavaMethodName(functionName)) == null) {
                return;
            }
            String sig = function.computeSignature(Function.SignatureType.JavaStyle);
            DeclarationsHolder objOut = this.result.config.reification && !isCallback && !isMethod ? new DeclarationsHolder(){

                public void addDeclaration(Declaration d) {
                    implementations.addDeclaration(d);
                    if (d instanceof Function) {
                        Function f = (Function)d;
                        List args = f.getArgs();
                        ArrayList<TypeRef> trs = new ArrayList<TypeRef>(2);
                        trs.add(f.getValueType());
                        if (!args.isEmpty()) {
                            trs.add(((Arg)args.get(0)).getValueType());
                        }
                        for (TypeRef tr : trs) {
                            Identifier id;
                            if (!(tr instanceof TypeRef.SimpleTypeRef) || !DeclarationsConverter.this.result.isFakePointer(id = ((TypeRef.SimpleTypeRef)tr).getName())) continue;
                            DeclarationsConverter.this.result.addFunctionReifiableInFakePointer(id, declarations.getResolvedJavaIdentifier(), f);
                        }
                    }
                }

                public List<Declaration> getDeclarations() {
                    return implementations.getDeclarations();
                }

                public Identifier getResolvedJavaIdentifier() {
                    return implementations.getResolvedJavaIdentifier();
                }

                public DeclarationsHolder resolveHolder() {
                    return implementations.resolveHolder();
                }
            } : implementations;
            try {
                this.convertFunction(function, signatures, isCallback, declarations, objOut, libraryClassName, sig, functionName, library, iConstructor);
            }
            catch (UnsupportedConversionException ex) {
                EmptyDeclaration d = this.skipDeclaration((Element)function, new String[0]);
                if (d == null) break block10;
                d.addToCommentBefore(new String[]{ex.toString()});
                declarations.addDeclaration((Declaration)d);
                implementations.addDeclaration(d.clone());
            }
        }
    }

    protected boolean isCPlusPlusFileName(String file) {
        if (file == null) {
            return true;
        }
        return !(file = file.toLowerCase()).endsWith(".c") && !file.endsWith(".m");
    }

    protected void collectParamComments(Function f) {
        for (Arg arg : f.getArgs()) {
            arg.moveAllCommentsBefore();
            TypeRef argType = arg.getValueType();
            if (argType != null) {
                if (!this.result.config.noComments) {
                    argType.moveAllCommentsBefore();
                    arg.addToCommentBefore(new String[]{argType.getCommentBefore()});
                }
                argType.stripDetails();
            }
            if (arg.getCommentBefore() == null) continue;
            if (!this.result.config.noComments) {
                f.addToCommentBefore(new String[]{"@param " + arg.getName() + " " + Element.cleanComment((String)arg.getCommentBefore())});
            }
            arg.stripDetails();
        }
    }

    public final void convertFunctions(List<Function> functions, Signatures signatures, DeclarationsHolder declarations, DeclarationsHolder implementations) {
        if (functions != null) {
            for (Function function : functions) {
                if (this.skip(function.getName() + "", this.result.config.skippedFunctionNames)) continue;
                this.convertFunction(function, signatures, false, declarations, implementations, declarations.getResolvedJavaIdentifier(), -1);
            }
        }
    }

    public Identifier getActualTaggedTypeName(TypeRef.TaggedTypeRef struct) {
        Identifier structName = null;
        Identifier tag = struct.getTag();
        if (tag == null || tag.isPlain() && tag.toString().startsWith("_")) {
            String better;
            Pair<StoredDeclarations.TypeDef, Declarator> pair;
            StoredDeclarations.TypeDef parentDef = (StoredDeclarations.TypeDef)SyntaxUtils.as((Object)struct.getParentElement(), StoredDeclarations.TypeDef.class);
            if (parentDef != null) {
                structName = new Identifier.SimpleIdentifier(JNAeratorUtils.findBestPlainStorageName((StoredDeclarations)parentDef), new Expression[0]);
            } else if (tag != null && (pair = this.result.typeDefs.get(better = tag.toString().substring(1))) != null && ((StoredDeclarations.TypeDef)pair.getFirst()).getValueType() != null && pair.getSecond() instanceof Declarator.DirectDeclarator) {
                TypeRef tr = ((StoredDeclarations.TypeDef)pair.getFirst()).getValueType();
                Declarator.DirectDeclarator dd = (Declarator.DirectDeclarator)pair.getSecond();
                if (tr instanceof TypeRef.SimpleTypeRef) {
                    if (tag.equals((Object)((TypeRef.SimpleTypeRef)tr).getName())) {
                        structName = ElementsHelper.ident((String[])new String[]{dd.resolveName()});
                    }
                } else if (tr instanceof TypeRef.TaggedTypeRef && tag.equals((Object)((TypeRef.TaggedTypeRef)tr).getTag())) {
                    structName = ElementsHelper.ident((String[])new String[]{dd.resolveName()});
                }
            }
        }
        if (structName == null || structName.toString().equals("")) {
            structName = tag;
        }
        return structName == null ? null : structName.clone();
    }

    public abstract Struct convertStruct(Struct var1, Signatures var2, Identifier var3, String var4, boolean var5) throws IOException;

    public int countFieldsInStruct(Struct s) throws UnsupportedConversionException {
        int count = 0;
        for (Declaration declaration : s.getDeclarations()) {
            if (!(declaration instanceof VariablesDeclaration)) continue;
            count += ((VariablesDeclaration)declaration).getDeclarators().size();
        }
        for (TypeRef.SimpleTypeRef parentName : s.getParents()) {
            Struct parent = this.result.structsByName.get(parentName.getName());
            if (parent == null) {
                throw new UnsupportedConversionException((Element)s, "Cannot find parent " + parentName + " of struct " + s);
            }
            count += this.countFieldsInStruct(parent);
        }
        return count;
    }

    protected void outputConvertedStruct(Struct struct, Signatures signatures, DeclarationsHolder out, String callerLibrary, boolean onlyFields) throws IOException {
        Struct structJavaClass = this.convertStruct(struct, signatures, out.getResolvedJavaIdentifier(), callerLibrary, onlyFields);
        if (structJavaClass == null) {
            return;
        }
        if (this.result.config.putTopStructsInSeparateFiles && struct.findParentOfType(Struct.class) == null) {
            String library = this.result.getLibrary((Element)struct);
            Identifier javaPackage = this.result.getLibraryPackage(library);
            Identifier fullClassName = ElementsHelper.ident((Identifier)javaPackage, (Identifier[])new Identifier[]{structJavaClass.getTag().clone()});
            if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
                structJavaClass.addAnnotation(new Annotation(ElementsHelper.typeRef(Library.class), ElementsHelper.expr((String)library)));
            }
            structJavaClass.removeModifiers(new Modifier[]{ModifierType.Static});
            structJavaClass = this.result.notifyBeforeWritingClass(fullClassName, structJavaClass, signatures, library);
            if (structJavaClass != null) {
                PrintWriter pout = this.result.classOutputter.getClassSourceWriter(fullClassName.toString());
                this.result.printJavaClass(javaPackage, structJavaClass, pout);
                pout.close();
            }
        } else {
            out.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)structJavaClass));
        }
    }

    private boolean skip(String name, List<Pattern> skipPatterns) {
        for (Pattern p : skipPatterns) {
            if (!p.matcher(name).matches()) continue;
            System.out.println("Skipping '" + name + "' because of skip pattern \"" + p.pattern() + "\"");
            return true;
        }
        return false;
    }

    public boolean isOptionalFunction(String name) {
        for (Pattern p : this.result.config.optionalFunctions) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public final void convertStructs(List<Struct> structs, Signatures signatures, DeclarationsHolder out, String library) throws IOException {
        if (structs != null) {
            for (Struct struct : structs) {
                if (struct.findParentOfType(Struct.class) != null || !this.result.config.genCPlusPlus && struct.getType().isCpp() || this.skip(struct.getTag() + "", this.result.config.skippedStructNames)) continue;
                this.outputConvertedStruct(struct, signatures, out, library, false);
            }
        }
    }

    public abstract boolean convertVariablesDeclaration(VariablesDeclaration var1, Signatures var2, DeclarationsHolder var3, int[] var4, boolean var5, Identifier var6, Identifier var7, String var8);

    TaggedTypeRefDeclaration publicStaticClassDecl(Identifier name, Identifier parentName, Struct.Type type, Element toCloneCommentsFrom, Identifier ... interfaces) {
        return ElementsHelper.decl((TypeRef.TaggedTypeRef)this.publicStaticClass(name, parentName, type, toCloneCommentsFrom, interfaces));
    }

    Struct publicStaticClass(Identifier name, Identifier parentName, Struct.Type type, Element toCloneCommentsFrom, Identifier ... interfaces) {
        Struct cl = new Struct();
        cl.setType(type);
        cl.setTag(name);
        if (parentName != null) {
            cl.setParents(new TypeRef.SimpleTypeRef[]{ElementsHelper.typeRef((Identifier)parentName)});
        }
        if (type == Struct.Type.JavaInterface) {
            for (Identifier inter : interfaces) {
                cl.addParent(ElementsHelper.typeRef((Identifier)inter));
            }
        } else {
            for (Identifier inter : interfaces) {
                cl.addProtocol(ElementsHelper.typeRef((Identifier)inter));
            }
        }
        if (!this.result.config.noComments) {
            cl.importComments(toCloneCommentsFrom, new String[]{this.getFileCommentContent(toCloneCommentsFrom)});
        }
        cl.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static});
        return cl;
    }

    public Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> getParentAndOwnDeclarations(Struct structJavaClass, Struct nativeStruct) throws IOException {
        Pair ret = new Pair(new ArrayList(), new ArrayList());
        if (!nativeStruct.getParents().isEmpty()) {
            for (TypeRef.SimpleTypeRef parentName : nativeStruct.getParents()) {
                Struct parent = this.result.structsByName.get(parentName.getName());
                if (parent == null) continue;
                Struct parentJavaClass = this.convertStruct(parent, new Signatures(), null, null, true);
                Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> parentDecls = this.getParentAndOwnDeclarations(parentJavaClass, parent);
                ((List)ret.getFirst()).addAll((Collection)parentDecls.getFirst());
                ((List)ret.getFirst()).addAll((Collection)parentDecls.getSecond());
            }
        }
        for (Declaration d : structJavaClass.getDeclarations()) {
            VariablesDeclaration vd;
            if (!(d instanceof VariablesDeclaration) || (vd = (VariablesDeclaration)d).getDeclarators().size() != 1 || !this.isField(vd)) continue;
            ((List)ret.getSecond()).add(vd);
        }
        return ret;
    }

    protected boolean isField(VariablesDeclaration vd) {
        List mods = vd.getModifiers();
        if (vd.hasModifier((Modifier)ModifierType.Final)) {
            return false;
        }
        return vd.getValueType() != null && !vd.getValueType().toString().equals(VirtualTablePointer.class.getName());
    }

    Statement throwIfArraySizeDifferent(String varAndFieldName) {
        return new Statement.If(ElementsHelper.expr((Expression)ElementsHelper.memberRef((Expression)ElementsHelper.varRef((String)varAndFieldName), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"length"), (Expression.BinaryOperator)Expression.BinaryOperator.IsDifferent, (Expression)ElementsHelper.memberRef((Expression)ElementsHelper.memberRef((Expression)ElementsHelper.thisRef(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)varAndFieldName), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"length")), (Statement)new Statement.Throw((Expression)new Expression.New(ElementsHelper.typeRef(IllegalArgumentException.class), new Expression[]{ElementsHelper.expr((String)"Wrong array size !")})), null);
    }

    void addConstructor(Struct s, Function f) {
        Identifier structName = this.getActualTaggedTypeName((TypeRef.TaggedTypeRef)s);
        f.setName(structName);
        s.addDeclaration((Declaration)f);
    }

    String getFileCommentContent(File file, Element e) {
        if (file != null) {
            Struct parent;
            Function fc;
            String path = this.result.config.relativizeFileForSourceComments(file.getAbsolutePath());
            String inCategoryStr = "";
            if (e instanceof Function && (fc = (Function)e).getType() == Function.Type.ObjCMethod && (parent = (Struct)SyntaxUtils.as((Object)fc.getParentElement(), Struct.class)) != null && parent.getCategoryName() != null) {
                inCategoryStr = "from " + parent.getCategoryName() + " ";
            }
            return "<i>" + inCategoryStr + "native declaration : " + path + (e == null || e.getElementLine() < 0 ? "" : ":" + e.getElementLine()) + "</i>";
        }
        if (e != null && e.getElementLine() >= 0) {
            return "<i>native declaration : <input>:" + e.getElementLine() + "</i>";
        }
        return null;
    }

    String getFileCommentContent(Element e) {
        if (e == null || this.result.config.limitComments) {
            return null;
        }
        String f = Element.getFileOfAscendency((Element)e);
        if (f == null && e != null && e.getElementLine() >= 0) {
            return "<i>native declaration : line " + e.getElementLine() + "</i>";
        }
        return f == null ? null : this.getFileCommentContent(new File(f), e);
    }

    public List<Define> reorderDefines(Collection<Define> defines) {
        boolean progressed;
        ArrayList<Define> reordered = new ArrayList<Define>(defines.size());
        HashSet<Identifier> added = new HashSet<Identifier>();
        HashSet<Identifier> all = new HashSet<Identifier>();
        LinkedHashMap<String, Pair> pending = new LinkedHashMap<String, Pair>();
        for (Define define : defines) {
            TreeSet<Identifier> dependencies = new TreeSet<Identifier>();
            this.computeVariablesDependencies((Element)define.getValue(), dependencies);
            all.add(ElementsHelper.ident((String[])new String[]{define.getName()}));
            if (dependencies.isEmpty()) {
                reordered.add(define);
                added.add(ElementsHelper.ident((String[])new String[]{define.getName()}));
                continue;
            }
            pending.put(define.getName(), new Pair((Object)define, dependencies));
        }
        do {
            progressed = false;
            Iterator it = pending.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Set dependencies = (Set)((Pair)e.getValue()).getSecond();
                String name = (String)e.getKey();
                boolean missesDep = false;
                for (Identifier dependency : dependencies) {
                    if (added.contains(dependency)) continue;
                    missesDep = true;
                    if (all.contains(dependency)) break;
                    it.remove();
                    all.remove(name);
                    break;
                }
                if (missesDep) continue;
                it.remove();
                reordered.add((Define)((Pair)e.getValue()).getFirst());
                added.add(ElementsHelper.ident((String[])new String[]{name}));
                progressed = true;
            }
        } while (!pending.isEmpty() && progressed);
        return reordered;
    }

    public void computeVariablesDependencies(Element e, final Set<Identifier> names) {
        e.accept((Visitor)new Scanner(){

            public void visitVariableRef(Expression.VariableRef variableRef) {
                names.add(variableRef.getName());
            }
        });
    }

    protected String chooseJavaArgName(String name, int iArg, Set<String> names) {
        String argName;
        Identifier jan = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident((String[])new String[]{name}));
        String baseArgName = jan == null ? null : jan.toString();
        int i = 1;
        if (baseArgName == null) {
            baseArgName = "arg";
        }
        do {
            argName = baseArgName + (i == 1 ? "" : i + "");
            ++i;
        } while (names.contains(argName) || this.result.typeConverter.isJavaKeyword(argName));
        names.add(argName);
        return argName;
    }

    public abstract void generateLibraryFiles(SourceFiles var1, Result var2, JNAeratorConfig var3) throws IOException;

    protected void fillLibraryMapping(Result result, SourceFiles sourceFiles, DeclarationsHolder declarations, DeclarationsHolder implementations, String library, Identifier javaPackage, Expression nativeLibFieldExpr) throws IOException {
        Set<String> undefinedTypes;
        Struct ptClass;
        Identifier fakePointer;
        Set<String> declFakePointers;
        Identifier implementationsFullClassName = result.getLibraryClassFullName(library);
        Identifier declarationsFullClassName = result.getLibraryDeclarationsClassFullName(library);
        Identifier libraryClass = declarations.getResolvedJavaIdentifier();
        Signatures signatures = result.getSignaturesForOutputClass(declarationsFullClassName);
        result.typeConverter.allowFakePointers = true;
        this.convertEnums(result.enumsByLibrary.get(library), signatures, declarations);
        this.convertConstants(library, result.definesByLibrary.get(library), sourceFiles, signatures, declarations);
        this.convertStructs(result.structsByLibrary.get(library), signatures, declarations, library);
        this.convertCallbacks(result.callbacksByLibrary.get(library), signatures, declarations, libraryClass);
        this.convertFunctions(result.functionsByLibrary.get(library), signatures, declarations, implementations);
        if (result.globalsGenerator != null) {
            result.globalsGenerator.convertGlobals(result.globalsByLibrary.get(library), signatures, declarations, nativeLibFieldExpr, library);
        }
        result.typeConverter.allowFakePointers = false;
        Set<String> implFakePointers = result.fakePointersByLibrary.get(implementationsFullClassName.toString());
        Set<String> set = declFakePointers = declarationsFullClassName == null ? null : result.fakePointersByLibrary.get(declarationsFullClassName.toString());
        if (implFakePointers != null || declFakePointers != null) {
            HashSet<String> fakePointers = new HashSet<String>();
            if (implFakePointers != null) {
                fakePointers.addAll(implFakePointers);
            }
            if (declFakePointers != null) {
                fakePointers.addAll(declFakePointers);
            }
            for (String fakePointerName : fakePointers) {
                if (fakePointerName.contains("::") || !signatures.addClass(fakePointer = ElementsHelper.ident((String[])new String[]{fakePointerName}))) continue;
                ptClass = result.declarationsConverter.createFakePointerClass(fakePointer);
                if (result.config.noComments) {
                    ptClass.addToCommentBefore(new String[]{"Pointer to unknown (opaque) type"});
                }
                declarations.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)ptClass));
                if (!result.config.reification) continue;
                result.reifier.reifyFakePointer(ptClass, declarations.getResolvedJavaIdentifier(), fakePointerName, signatures);
            }
        }
        if ((undefinedTypes = result.undefinedTypesByLibrary.get(declarations.getResolvedJavaIdentifier())) != null) {
            for (String undefinedTypeName : undefinedTypes) {
                if (undefinedTypeName.contains("::") || !signatures.addClass(fakePointer = ElementsHelper.ident((String[])new String[]{undefinedTypeName}))) continue;
                ptClass = result.declarationsConverter.publicStaticClass(fakePointer, null, Struct.Type.JavaInterface, null, new Identifier[0]);
                ptClass.addToCommentBefore(new String[]{"Undefined type"});
                declarations.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)ptClass));
            }
        }
    }

    protected void writeLibraryInterface(Result result, SourceFiles sourceFiles, DeclarationsHolder interf, String library, Identifier javaPackage) throws IOException {
        Identifier fullLibraryClassName = interf.getResolvedJavaIdentifier();
        Signatures signatures = result.getSignaturesForOutputClass(fullLibraryClassName);
        if (interf instanceof Struct) {
            if ((interf = result.notifyBeforeWritingClass(fullLibraryClassName, (Struct)interf, signatures, library)) != null) {
                PrintWriter out = result.classOutputter.getClassSourceWriter(fullLibraryClassName.toString());
                result.printJavaClass(javaPackage, (Struct)interf, out);
                out.close();
            }
        } else if (interf instanceof SourceFile) {
            SourceFile sourceFile = (SourceFile)interf;
            String sourcePath = sourceFile.getElementFile();
            assert (sourcePath != null);
            PrintWriter out = result.classOutputter.getSourceWriter(sourcePath);
            out.print(sourceFile);
            out.close();
        }
    }
}

