/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorUtils;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CToJavaPreScanner
extends Scanner {
    static Modifier longAlias = ModifierType.Long.resolveAlias();
    static Modifier shortAlias = ModifierType.Short.resolveAlias();
    private static final boolean mutateDeclaratorTypes = true;

    public void visitStruct(Struct struct) {
        Element parent;
        super.visitStruct(struct);
        if (struct.isForwardDeclaration() && struct.getTag() != null && !((parent = struct.getParentElement()) instanceof TaggedTypeRefDeclaration)) {
            TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef(struct.getTag());
            for (Modifier mod : struct.getModifiers()) {
                if (!mod.isA(ModifierKind.StorageClassSpecifier)) continue;
                tr.addModifiers(new Modifier[]{mod});
            }
            struct.replaceBy((Element)tr);
            tr.accept((Visitor)this);
        }
    }

    void moveModifiersOfType(ModifierKind kind, ModifiableElement source, ModifiableElement destination) {
        ArrayList<Modifier> mods = null;
        for (Modifier m : source.getModifiers()) {
            if (!m.isA(kind)) continue;
            if (mods == null) {
                mods = new ArrayList<Modifier>();
            }
            mods.add(m);
        }
        if (mods != null) {
            Modifier[] modsArray = mods.toArray(new Modifier[mods.size()]);
            source.removeModifiers(modsArray);
            destination.addModifiers(modsArray);
        }
    }

    static List<Modifier> getLongShortModifiers(ModifiableElement e) {
        ArrayList<Modifier> ret = null;
        for (Modifier mod : e.getModifiers()) {
            Modifier res = mod.resolveAlias();
            if (!res.equals(longAlias) && !res.equals(shortAlias)) continue;
            if (ret == null) {
                ret = new ArrayList<Modifier>();
            }
            ret.add(mod);
        }
        return ret;
    }

    static TypeRef longShortModsToTypeRef(List<Modifier> mods) {
        TypeRef.Primitive tr = new TypeRef.Primitive();
        tr.addModifiers(mods);
        return tr;
    }

    static void attachLongOrShortModifiersToPointedType(TypeRef tr, List<Modifier> mods) {
        while (tr instanceof TypeRef.TargettedTypeRef) {
            TypeRef.TargettedTypeRef ttr = (TypeRef.TargettedTypeRef)tr;
            if (ttr.getTarget() == null) {
                ttr.setTarget(CToJavaPreScanner.longShortModsToTypeRef(mods));
                return;
            }
            tr = ttr.getTarget();
        }
        tr.addModifiers(mods);
    }

    public void visitFunction(Function function) {
        List<Modifier> mods = CToJavaPreScanner.getLongShortModifiers((ModifiableElement)function);
        if (mods != null) {
            if (function.getValueType() == null) {
                function.setValueType(CToJavaPreScanner.longShortModsToTypeRef(mods));
            } else {
                CToJavaPreScanner.attachLongOrShortModifiersToPointedType(function.getValueType(), mods);
            }
            function.removeModifiers(mods);
        }
        if (function.getValueType() != null) {
            this.moveModifiersOfType(ModifierKind.CallingConvention, (ModifiableElement)function.getValueType(), (ModifiableElement)function);
        } else {
            Element parent = function.getParentElement();
            boolean returnsInt = false;
            if (parent instanceof Struct) {
                Struct parentStruct = (Struct)parent;
                switch (parentStruct.getType()) {
                    case CPPClass: 
                    case CStruct: {
                        if (function.getName().equals((Object)parentStruct.getTag())) break;
                        returnsInt = true;
                        break;
                    }
                }
            } else {
                returnsInt = true;
            }
            if (returnsInt) {
                function.setValueType((TypeRef)ElementsHelper.typeRef((String)"int"));
            }
        }
        super.visitFunction(function);
    }

    public void visitTaggedTypeRefDeclaration(TaggedTypeRefDeclaration taggedTypeRefDeclaration) {
        TypeRef.TaggedTypeRef tr = taggedTypeRefDeclaration.getTaggedTypeRef();
        if (tr != null) {
            String before = tr.getCommentBefore();
            tr.setCommentBefore(taggedTypeRefDeclaration.getCommentBefore());
            tr.addToCommentBefore(new String[]{before});
            taggedTypeRefDeclaration.setCommentBefore(null);
        }
        super.visitTaggedTypeRefDeclaration(taggedTypeRefDeclaration);
    }

    protected void visitStoredDeclarations(StoredDeclarations d) {
        Declarator declarator;
        super.visitStoredDeclarations(d);
        if (d.getDeclarators().size() == 1 && (declarator = (Declarator)d.getDeclarators().get(0)) instanceof Declarator.FunctionDeclarator) {
            Declarator.FunctionDeclarator fd = (Declarator.FunctionDeclarator)declarator;
            Function f = new Function(Function.Type.CFunction, null, d.getValueType(), fd.getArgs());
            f.addModifiers(fd.getTarget().getModifiers());
            TypeRef.FunctionSignature fs = new TypeRef.FunctionSignature(f);
            d.setValueType((TypeRef)fs);
            Declarator target = fd.getTarget();
            Declarator.DirectDeclarator newTarget = target == null ? new Declarator.DirectDeclarator(fd.resolveName(), fd.getDefaultValue()) : target.clone();
            d.setDeclarators(Arrays.asList(newTarget));
            d.accept((Visitor)this);
        }
    }

    public void visitPrimitive(TypeRef.Primitive primitive) {
        Identifier name;
        super.visitPrimitive(primitive);
        if (ModifierType.Long.isContainedBy((Collection)primitive.getModifiers())) {
            Identifier name2 = primitive.getName();
            if (name2 == null || name2.equals((Object)"int") || name2.equals((Object)"long")) {
                primitive.setName(ElementsHelper.ident((String[])new String[]{"long"}));
                if (name2 == null) {
                    primitive.removeModifiers(new Modifier[]{ModifierType.Long});
                }
            }
        } else if (ModifierType.Short.isContainedBy((Collection)primitive.getModifiers()) && ((name = primitive.getName()) == null || name.equals((Object)"int"))) {
            primitive.setName(ElementsHelper.ident((String[])new String[]{"short"}));
            primitive.removeModifiers(new Modifier[]{ModifierType.Short});
        }
    }

    public void visitTypeDef(StoredDeclarations.TypeDef v) {
        super.visitTypeDef(v);
        StoredDeclarations.TypeDef toAddAfter = v;
        TypeRef valueType = v.getValueType();
        String bestName = null;
        String origName = null;
        TypeRef.TaggedTypeRef ttr = null;
        if (valueType instanceof TypeRef.TaggedTypeRef) {
            ttr = (TypeRef.TaggedTypeRef)valueType;
            bestName = JNAeratorUtils.findBestPlainStorageName((StoredDeclarations)v);
            if (bestName != null) {
                origName = ttr.getTag() != null ? ttr.getTag().toString() : null;
            }
        }
        for (Declarator vs : v.getDeclarators()) {
            if (vs == null) continue;
            String name = vs.resolveName();
            if (vs instanceof Declarator.DirectDeclarator && name.equals(bestName) && ttr != null && origName != null) {
                Declarator.DirectDeclarator rep = new Declarator.DirectDeclarator(origName);
                vs.replaceBy((Element)rep);
                ttr.setTag(ElementsHelper.ident((String[])new String[]{bestName}));
                vs = rep;
                name = origName;
            }
            StoredDeclarations.TypeDef decl = null;
            Declarator.MutableByDeclarator type = vs.mutateType((Declarator.MutableByDeclarator)v.getValueType());
            if (!(type instanceof TypeRef)) continue;
            TypeRef tr = (TypeRef)type;
            decl = new StoredDeclarations.TypeDef(tr, new Declarator[]{new Declarator.DirectDeclarator(name)});
            decl.importDetails((Element)v, false);
            decl.importDetails((Element)vs, false);
            decl.importDetails((Element)tr, true);
            toAddAfter.insertSibling((Element)decl, false);
            toAddAfter = decl;
        }
        if (toAddAfter != v) {
            v.replaceBy(null);
        }
    }

    public void visitArg(Arg arg) {
        Declarator d = arg.getDeclarator();
        if (d == null) {
            TypeRef target;
            TypeRef tr = arg.getValueType();
            if (tr instanceof TypeRef.Pointer && (target = ((TypeRef.Pointer)tr).getTarget()) instanceof TypeRef.FunctionSignature) {
                Identifier name;
                TypeRef.FunctionSignature fs = (TypeRef.FunctionSignature)target;
                Identifier identifier = name = fs.getFunction() == null ? null : fs.getFunction().getName();
                if (name != null) {
                    arg.setDeclarator((Declarator)new Declarator.DirectDeclarator(name.toString()));
                    fs.getFunction().setName(null);
                }
            }
        } else if (!(d instanceof Declarator.DirectDeclarator)) {
            Declarator.MutableByDeclarator type = d.mutateType((Declarator.MutableByDeclarator)arg.getValueType());
            if (type instanceof TypeRef) {
                arg.setValueType((TypeRef)type);
                arg.setDeclarator((Declarator)new Declarator.DirectDeclarator(d.resolveName(), d.getBits(), arg.getDefaultValue()));
            } else {
                Object var3_4 = null;
            }
        }
        super.visitArg(arg);
    }

    public void visitVariablesDeclaration(VariablesDeclaration v) {
        super.visitVariablesDeclaration(v);
        VariablesDeclaration toAddAfter = v;
        int nDecl = v.getDeclarators().size();
        for (Declarator vs : v.getDeclarators()) {
            if (vs == null || vs instanceof Declarator.DirectDeclarator && nDecl == 1) continue;
            Declaration decl = null;
            Declarator.MutableByDeclarator mutatedType = vs.mutateType((Declarator.MutableByDeclarator)v.getValueType());
            if (mutatedType instanceof Function) {
                Function f = (Function)mutatedType;
                f.setName((Identifier)new Identifier.SimpleIdentifier(vs.resolveName(), new Expression[0]));
                decl = (Function)mutatedType;
                decl.importDetails((Element)v, false);
                decl.importDetails((Element)vs, false);
            } else {
                if (mutatedType instanceof TypeRef) {
                    TypeRef tr = (TypeRef)mutatedType;
                    decl = new VariablesDeclaration(tr, new Declarator[]{new Declarator.DirectDeclarator(vs.resolveName(), vs.getBits(), vs.getDefaultValue())});
                    decl.importDetails((Element)v, false);
                    decl.importDetails((Element)vs, false);
                    decl.importDetails((Element)tr, true);
                } else if (mutatedType instanceof Declaration) {
                    decl = (Declaration)mutatedType;
                }
                if (decl == null) {
                    TypeRef vt = v.getValueType();
                    decl = new VariablesDeclaration(vt == null ? null : vt.clone(), new Declarator[]{vs.clone()});
                    decl.importDetails((Element)v, false);
                    decl.importDetails((Element)vs, false);
                    decl.importDetails((Element)v.getValueType(), true);
                }
            }
            toAddAfter.insertSibling((Element)decl, false);
            toAddAfter = decl;
        }
        if (toAddAfter != v) {
            v.replaceBy(null);
        }
    }
}

