/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorConfigUtils;
import com.ochafik.lang.jnaerator.JNAeratorParser;
import com.ochafik.lang.jnaerator.PreprocessorUtils;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.anarres.cpp.LexerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSlicer {
    State state = State.Normal;
    Stack<BlockType> blocks = new Stack();
    StringBuilder content = new StringBuilder();
    int semiColonCount;

    private CharSequence getContent() {
        return this.content;
    }

    private void pop(BlockType blockType) {
        if (this.blocks.isEmpty()) {
            throw new RuntimeException("Empty blocks, got closing " + (Object)((Object)blockType));
        }
        if (this.blocks.pop() != blockType) {
            System.out.println("bad pop");
        }
    }

    void appendLine(String s) {
        for (char c : s.toCharArray()) {
            this.append(c);
        }
        this.append('\n');
    }

    private void append(char c) {
        if (this.state == State.NormalSlash) {
            switch (c) {
                case '/': {
                    this.state = State.SingleLineComment;
                    return;
                }
                case '*': {
                    this.state = State.MultilineComment;
                    return;
                }
            }
            this.content.append('/');
            this.state = State.Normal;
        }
        switch (this.state) {
            case Char: {
                switch (c) {
                    case '\'': {
                        this.state = State.Normal;
                        break;
                    }
                    case '\\': {
                        this.state = State.CharEscape;
                    }
                }
                break;
            }
            case String: {
                switch (c) {
                    case '\"': {
                        this.state = State.Normal;
                        break;
                    }
                    case '\\': {
                        this.state = State.StringEscape;
                    }
                }
                break;
            }
            case CharEscape: {
                this.state = State.Char;
                break;
            }
            case StringEscape: {
                this.state = State.String;
                break;
            }
            case SingleLineComment: {
                if (c != '\n') break;
                this.state = State.Normal;
                break;
            }
            case MultilineComment: {
                if (c != '*') break;
                this.state = State.StarInMultilineComment;
                break;
            }
            case StarInMultilineComment: {
                if (c == '/') {
                    this.state = State.Normal;
                    return;
                }
                this.state = State.MultilineComment;
                break;
            }
            case Normal: {
                switch (c) {
                    case '/': {
                        this.state = State.NormalSlash;
                        break;
                    }
                    case '\'': {
                        this.state = State.Char;
                        break;
                    }
                    case '\"': {
                        this.state = State.String;
                        break;
                    }
                    case '(': {
                        this.blocks.push(BlockType.Paren);
                        break;
                    }
                    case '{': {
                        this.blocks.push(BlockType.Curly);
                        break;
                    }
                    case '[': {
                        this.blocks.push(BlockType.Square);
                        break;
                    }
                    case ')': {
                        this.pop(BlockType.Paren);
                        break;
                    }
                    case '}': {
                        this.pop(BlockType.Curly);
                        break;
                    }
                    case ']': {
                        this.pop(BlockType.Square);
                        break;
                    }
                    case ';': {
                        ++this.semiColonCount;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("state unhandled : " + (Object)((Object)this.state));
            }
        }
        switch (this.state) {
            case SingleLineComment: 
            case MultilineComment: 
            case StarInMultilineComment: 
            case NormalSlash: {
                break;
            }
            default: {
                this.content.append(c);
            }
        }
    }

    boolean isParsable() {
        return this.state == State.Normal && this.blocks.isEmpty();
    }

    public int getSemiColonCount() {
        return this.semiColonCount;
    }

    public static String removeComments(String s) {
        CSlicer tester = new CSlicer();
        tester.appendLine(s);
        return tester.getContent().toString();
    }

    public static String[] getLines(String source) {
        String[] lines = source.split("\n");
        ArrayList<String> ret = new ArrayList<String>(lines.length);
        for (String line : lines) {
            String s = line.trim();
            if (s.length() == 0) continue;
            ret.add(s);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static void getParseableIncrements(String source, Callback cb) {
        String[] lines = CSlicer.getLines(source);
        CSlicer tester = new CSlicer();
        for (String line : lines) {
            tester.appendLine(line);
            if (tester.isParsable() && !cb.apply(tester.getContent(), tester.getSemiColonCount())) break;
        }
    }

    public static void main(String[] args) throws IOException, LexerException {
        String source = CSlicer.preprocess(new File("test.h"));
        source = CSlicer.removeComments(source);
        CSlicer.getParseableIncrements(source, new Callback(){
            int lastDeclCount;
            int lastSemiCount;
            int lastContentLength;
            int nErr;

            public boolean apply(CharSequence content, int semiColonCount) {
                try {
                    if (semiColonCount == this.lastSemiCount) {
                        return true;
                    }
                    String source = content.toString() + ";";
                    List<Declaration> decls = CSlicer.parseDeclarations(source);
                    int nDecls = decls.size();
                    int length = content.length();
                    System.out.println("Parsed " + nDecls + " declarations in " + length + " chars");
                    if (nDecls == this.lastDeclCount) {
                        String diff = content.subSequence(this.lastContentLength, length).toString();
                        String errFile = "err-" + ++this.nErr + ".h";
                        System.out.println("Failed to parse new declaration in : \n\t" + diff.replaceAll("\n", "\n\t") + "\nCode was saved in " + errFile);
                        System.out.println("Last parsed declaration :");
                        System.out.println("\t" + String.valueOf(decls.get(decls.size() - 1)).replaceAll("\n", "\n\t"));
                        PrintStream out = new PrintStream(new FileOutputStream(errFile));
                        out.println(source);
                        out.println("#if 0 // Here's the diff to the last compilable code :");
                        out.println(diff);
                        out.println("#endif");
                        out.println("#if 0 // Here's the last parsed declaration");
                        out.println(String.valueOf(decls.get(decls.size() - 1)));
                        out.println("#endif");
                        out.close();
                    }
                    this.lastContentLength = length;
                    this.lastSemiCount = semiColonCount;
                    this.lastDeclCount = nDecls;
                    return true;
                }
                catch (Throwable ex) {
                    Logger.getLogger(CSlicer.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        });
    }

    static String preprocess(File source) throws IOException, LexerException {
        JNAeratorConfig config = new JNAeratorConfig();
        JNAeratorConfigUtils.autoConfigure(config);
        config.preprocessorConfig.implicitIncludes.add("C:\\program files\\Microsoft SDKs\\Windows\\v7.0A\\Include");
        config.preprocessorConfig.implicitIncludes.add("C:\\program files\\Microsoft Visual Studio 10.0\\VC\\include");
        config.addSourceFile(source, null, false, true, true);
        Result result = new Result(config, null, null);
        String pre = PreprocessorUtils.preprocessSources(config, Collections.EMPTY_LIST, false, result.typeConverter, null);
        return pre;
    }

    static List<Declaration> parseDeclarations(String source) throws IOException, LexerException, InterruptedException {
        JNAeratorConfig config = new JNAeratorConfig();
        JNAeratorConfigUtils.autoConfigure(config);
        config.preprocessorConfig.includeStrings.add(source);
        Result result = new Result(config, null, null);
        SourceFiles parse = new JNAeratorParser().parse(config, result.typeConverter, null);
        ArrayList<Declaration> ret = new ArrayList<Declaration>();
        CSlicer.flatten(parse, ret);
        return ret;
    }

    static void flatten(Element element, List<Declaration> out) {
        if (element instanceof SourceFiles) {
            for (SourceFile f : ((SourceFiles)element).getSourceFiles()) {
                CSlicer.flatten((Element)f, out);
            }
        }
        if (element instanceof DeclarationsHolder) {
            for (Declaration d : ((DeclarationsHolder)element).getDeclarations()) {
                CSlicer.flatten((Element)d, out);
            }
        } else if (element instanceof Declaration) {
            out.add((Declaration)element);
        }
    }

    static interface Callback {
        public boolean apply(CharSequence var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        String,
        Char,
        Normal,
        StringEscape,
        CharEscape,
        NormalSlash,
        SingleLineComment,
        MultilineComment,
        StarInMultilineComment;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BlockType {
        Paren,
        Curly,
        Square;

    }
}

