/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorParser;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.ObjCDemanglingLexer;
import com.ochafik.lang.jnaerator.parser.ObjCDemanglingParser;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.xml.XMLUtils;
import com.ochafik.xml.XPathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.xpath.XPathExpressionException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BridgeSupportParser {
    final Result result;
    SourceFiles sourceFiles;

    public BridgeSupportParser(Result result, SourceFiles sourceFiles) {
        this.result = result;
        this.sourceFiles = sourceFiles;
    }

    public static void main(String[] args) {
        try {
            JNAeratorConfig config = new JNAeratorConfig();
            config.verbose = true;
            Result result = new Result(config, null, null);
            SourceFiles sourceFiles = new SourceFiles();
            File file = new File("/System/Library/Frameworks/Foundation.framework/Resources/BridgeSupport/FoundationFull.bridgesupport");
            new BridgeSupportParser(result, sourceFiles).parseBridgeSupportFile(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseBridgeSupportFiles() throws FileNotFoundException {
        SourceFiles sfs;
        block9: {
            block10: {
                sfs = new SourceFiles();
                try {
                    for (File bsf : this.result.config.bridgeSupportFiles) {
                        try {
                            sfs.add(this.parseBridgeSupportFile(bsf));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    Object var6_5 = null;
                    if (this.result.config.bridgesupportOutFile == null) break block9;
                    if (!this.result.config.verbose) break block10;
                    System.out.println("Writing bridgesupport definitions to " + this.result.config.bridgesupportOutFile.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (this.result.config.bridgesupportOutFile != null) {
                        if (this.result.config.verbose) {
                            System.out.println("Writing bridgesupport definitions to " + this.result.config.bridgesupportOutFile.getAbsolutePath());
                        }
                        PrintWriter pw = new PrintWriter(this.result.config.bridgesupportOutFile);
                        pw.println((Object)sfs);
                        pw.close();
                    }
                    for (SourceFile sf : sfs.getSourceFiles()) {
                        this.sourceFiles.add(sf);
                    }
                    throw throwable;
                }
            }
            PrintWriter pw = new PrintWriter(this.result.config.bridgesupportOutFile);
            pw.println((Object)sfs);
            pw.close();
        }
        for (SourceFile sf : sfs.getSourceFiles()) {
            this.sourceFiles.add(sf);
        }
    }

    private SourceFile parseBridgeSupportFile(File bsf) throws Exception {
        String framework = bsf.getName();
        if (framework.toLowerCase().endsWith(".bridgesupport")) {
            framework = framework.substring(0, framework.length() - ".bridgesupport".length());
        }
        Document xml = XMLUtils.readXML((File)bsf);
        String sourceFilePath = bsf.toString();
        Node signatures = XMLUtils.getFirstNamedNode((Node)xml, (String)"signatures");
        if (signatures == null) {
            return null;
        }
        SourceFile sf = new SourceFile();
        sf.setElementFile(sourceFilePath);
        this.parseStructs(signatures, sf);
        this.parseEnums(signatures, sf);
        this.parseConstants(signatures, sf);
        this.parseClasses(framework, signatures, sf);
        this.parseStringConstants(framework, signatures, sf);
        this.parseFunctions(framework, signatures, sf);
        return sf;
    }

    private void parseEnums(Node signatures, SourceFile sf) {
        for (Node en : XMLUtils.getChildrenByName((Node)signatures, (String)"enum")) {
            String name = XMLUtils.getAttribute((Node)en, (String)"name");
            String value = XMLUtils.getAttribute((Node)en, (String)"value");
            if (value == null) continue;
            try {
                try {
                    int i = value.matches(".*?\\.0+$") ? value.lastIndexOf(46) : -1;
                    String v = i > 0 ? value.substring(0, i) : value;
                    sf.addDeclaration((Declaration)new VariablesDeclaration(ElementsHelper.typeRef((String)"int").addModifiers(new Modifier[]{ModifierType.Const}), new Declarator[]{new Declarator.DirectDeclarator(name, ElementsHelper.expr((int)Integer.parseInt(v)))}));
                }
                catch (NumberFormatException fex) {
                    sf.addDeclaration((Declaration)new VariablesDeclaration(ElementsHelper.typeRef((String)"double").addModifiers(new Modifier[]{ModifierType.Const}), new Declarator[]{new Declarator.DirectDeclarator(name, ElementsHelper.expr((double)Double.parseDouble(value)))}));
                }
            }
            catch (Exception ex) {
                System.err.println("Parsing of enum " + name + " with value '" + value + "' failed : " + ex);
            }
        }
    }

    private void parseConstants(Node signatures, SourceFile sf) {
        for (Node cn : XMLUtils.getChildrenByName((Node)signatures, (String)"constant")) {
            String name = XMLUtils.getAttribute((Node)cn, (String)"name");
            try {
                TypeRef tr = this.parseType(cn);
                if (tr == null) continue;
                sf.addDeclaration((Declaration)new VariablesDeclaration(tr.addModifiers(new Modifier[]{ModifierType.Extern, ModifierType.Const}), new Declarator[]{new Declarator.DirectDeclarator(name)}));
            }
            catch (Exception ex) {
                System.err.println("Parsing of constant " + name + " failed : " + ex);
            }
        }
    }

    private void parseClasses(String framework, Node signatures, SourceFile sf) throws XPathExpressionException {
        Struct cs;
        for (Node classe : XMLUtils.getChildrenByName((Node)signatures, (String)"class")) {
            cs = this.parseClasse(classe, Struct.Type.ObjCClass, sf);
            if (cs == null || "NSObject".equals(String.valueOf(cs.getTag().toString()))) continue;
            cs.setParents(new TypeRef.SimpleTypeRef[]{ElementsHelper.typeRef((Identifier)ElementsHelper.ident((String[])new String[]{"NSObject"}))});
        }
        for (Node classe : XMLUtils.getChildrenByName((Node)signatures, (String)"informal_protocol")) {
            cs = this.parseClasse(classe, Struct.Type.ObjCClass, sf);
            if (cs == null) continue;
            cs.setCategoryName(cs.getTag() == null ? null : cs.getTag().toString());
            cs.setTag(ElementsHelper.ident((String[])new String[]{"NSObject"}));
        }
    }

    private Struct parseClasse(Node classe, Struct.Type type, SourceFile sf) throws XPathExpressionException {
        Struct cs = new Struct();
        cs.setType(type);
        String name = XMLUtils.getAttribute((Node)classe, (String)"name");
        if (this.result.config.verbose) {
            System.out.println("Parsing class " + name);
        }
        cs.setTag(ElementsHelper.ident((String[])new String[]{name}));
        for (Node method : XPathUtils.findNodesIterableByXPath((String)"method", (Object)classe)) {
            try {
                cs.addDeclaration((Declaration)this.parseFunction(Function.Type.ObjCMethod, method, sf));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        sf.addDeclaration((Declaration)new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)cs));
        return cs;
    }

    private void parseFunctions(String framework, Node signatures, SourceFile sf) throws XPathExpressionException {
        for (Node function : XMLUtils.getChildrenByName((Node)signatures, (String)"function")) {
            String already_retained;
            String name = XMLUtils.getAttribute((Node)function, (String)"name");
            Node retval = XMLUtils.getFirstNamedNode((Node)function, (String)"retval");
            String string = already_retained = retval != null ? XMLUtils.getAttribute((Node)retval, (String)"already_retained") : null;
            if (already_retained != null && (already_retained = already_retained.trim()).length() > 0) {
                boolean alreadyRetained = "true".equals(already_retained);
                Result.getMap(this.result.retainedRetValFunctions, framework).put(name, alreadyRetained);
            }
            if ("true".equals(XMLUtils.getAttribute((Node)function, (String)"inline"))) continue;
            try {
                Function f = this.parseFunction(Function.Type.CFunction, function, sf);
                if (f == null) continue;
                sf.addDeclaration((Declaration)f);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public TypeRef parseType(Node node) throws XPathExpressionException, RecognitionException, IOException {
        if (node == null) {
            return null;
        }
        TypeRef declaredType = null;
        try {
            String dt = XMLUtils.getAttribute((Node)node, (String)"declared_type");
            if (dt != null) {
                ObjCppParser parser = new JNAeratorParser().newObjCppParser(this.result.typeConverter, dt, false, null);
                parser.setupScopes();
                declaredType = parser.mutableTypeRef();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TypeRef inferredType = null;
        if ((declaredType == null || declaredType instanceof TypeRef.SimpleTypeRef) && (inferredType = this.parseAndReconciliateType(XMLUtils.getAttribute((Node)node, (String)"type"), XMLUtils.getAttribute((Node)node, (String)"type64"))) != null && declaredType instanceof TypeRef.SimpleTypeRef && !inferredType.toString().equals(declaredType.toString())) {
            String sn = ((TypeRef.SimpleTypeRef)declaredType).getName().toString();
            this.result.addWeakTypeDef(inferredType.clone(), sn);
        }
        return declaredType != null ? declaredType : inferredType;
    }

    private Function parseFunction(Function.Type cfunction, Node function, SourceFile sf) throws XPathExpressionException, RecognitionException, IOException {
        TypeRef tr = this.parseType(XMLUtils.getFirstNamedNode((Node)function, (String)"retval"));
        String selector = XMLUtils.getAttribute((Node)function, (String)"selector");
        String[] splitSelector = selector == null ? null : selector.split(":");
        String name = XMLUtils.getAttribute((Node)function, (String)"name");
        if (name == null && splitSelector != null && splitSelector.length > 0) {
            name = splitSelector[0];
        }
        String type = XMLUtils.getAttribute((Node)function, (String)"type");
        String type64 = XMLUtils.getAttribute((Node)function, (String)"type64");
        Function methodType = null;
        if (type != null) {
            methodType = this.parseAndReconciliateMethods(type, type64);
            if (tr == null) {
                tr = methodType.getValueType();
            }
        }
        Function f = new Function(cfunction, ElementsHelper.ident((String[])new String[]{name}), tr);
        String class_method = XMLUtils.getAttribute((Node)function, (String)"class_method");
        if ("true".equals(class_method)) {
            f.addModifiers(new Modifier[]{ModifierType.Static});
        }
        int iArg = 0;
        for (Node arg : XMLUtils.getChildrenByName((Node)function, (String)"arg")) {
            Object at = this.parseType(arg);
            if (at == null && methodType != null) {
                at = iArg < methodType.getArgs().size() ? ((Arg)methodType.getArgs().get(iArg)).getValueType() : null;
            }
            if (at == null) {
                return null;
            }
            Arg a = new Arg();
            a.setName(XMLUtils.getAttribute((Node)arg, (String)"name"));
            a.setValueType(at);
            a.setSelector(splitSelector == null || iArg >= splitSelector.length ? null : splitSelector[iArg]);
            f.addArg(a);
            ++iArg;
        }
        return f;
    }

    TypeRef parseType(String mangled) throws RecognitionException, IOException {
        return BridgeSupportParser.newObjCDemangler(mangled, true).mangledTypeEOF();
    }

    Function parseMethod(String mangled) throws RecognitionException, IOException {
        return BridgeSupportParser.newObjCDemangler(mangled, true).methodType();
    }

    TypeRef parseAndReconciliateType(String mangled32, String mangled64) throws RecognitionException, IOException {
        if (mangled32 == null) {
            return null;
        }
        TypeRef tr32 = this.parseType(mangled32);
        if (mangled64 != null && mangled64.trim().length() > 0 && !mangled32.equals(mangled64)) {
            TypeRef tr64 = this.parseType(mangled64);
            try {
                return (TypeRef)this.result.universalReconciliator.reconciliate32bitsAnd64bits((Element)tr32, (Element)tr64);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return tr32;
    }

    Function parseAndReconciliateMethods(String mangled32, String mangled64) throws RecognitionException, IOException {
        if (mangled32 == null) {
            return null;
        }
        Function tr32 = this.parseMethod(mangled32);
        if (mangled64 != null && mangled64.trim().length() > 0 && !mangled32.equals(mangled64)) {
            Function tr64 = this.parseMethod(mangled64);
            try {
                return (Function)this.result.universalReconciliator.reconciliate32bitsAnd64bits((Element)tr32, (Element)tr64);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return tr32;
    }

    private void parseStructs(Node signatures, SourceFile sf) throws XPathExpressionException {
        for (Node function : XMLUtils.getChildrenByName((Node)signatures, (String)"struct")) {
            String name = XMLUtils.getAttribute((Node)function, (String)"name");
            String type32 = XMLUtils.getAttribute((Node)function, (String)"type");
            String type64 = XMLUtils.getAttribute((Node)function, (String)"type64");
            try {
                try {
                    TypeRef tr = this.parseAndReconciliateType(type32, type64);
                    StoredDeclarations.TypeDef td = new StoredDeclarations.TypeDef(tr, new Declarator[]{new Declarator.DirectDeclarator(name)});
                    sf.addDeclaration((Declaration)td);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static ObjCDemanglingParser newObjCDemangler(String s, final boolean verbose) throws IOException {
        return new ObjCDemanglingParser((TokenStream)new CommonTokenStream((TokenSource)new ObjCDemanglingLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(s))))){

            public void reportError(RecognitionException arg0) {
                if (verbose) {
                    super.reportError(arg0);
                }
            }
        };
    }

    private void parseStringConstants(String framework, Node signatures, SourceFile sf) throws XPathExpressionException {
        for (Node string_constant : XMLUtils.getChildrenByName((Node)signatures, (String)"string_constant")) {
            String name = XMLUtils.getAttribute((Node)string_constant, (String)"name");
            String value = XMLUtils.getAttribute((Node)string_constant, (String)"value");
            if (value == null) continue;
            Result.getMap(this.result.stringConstants, framework).put(name, value);
        }
    }
}

