/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.string.StringUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bridj.ComplexDouble;
import org.bridj.IntValuedEnum;
import org.bridj.SizeT;
import org.bridj.TimeT;
import org.bridj.ann.CLong;
import org.bridj.ann.Ptr;
import org.bridj.util.DefaultParameterizedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridJTypeConversion
extends TypeConversion {
    public BridJTypeConversion(Result result) {
        super(result);
    }

    @Override
    public void initTypes() {
        super.initTypes();
        this.result.prim("BOOL", TypeConversion.JavaPrim.Int);
    }

    @Override
    public Expression typeLiteral(TypeRef c) {
        Identifier id;
        Identifier.SimpleIdentifier sid;
        if (c instanceof TypeRef.SimpleTypeRef && this.result.config.runtime == JNAeratorConfig.Runtime.BridJ && !(sid = (id = ((TypeRef.SimpleTypeRef)c).getName()).resolveLastSimpleIdentifier()).getTemplateArguments().isEmpty()) {
            Identifier erased = id.eraseTemplateArguments();
            ArrayList<Expression> exprs = new ArrayList<Expression>();
            exprs.add(this.typeLiteral((TypeRef)ElementsHelper.typeRef((Identifier)erased.clone())));
            for (Expression t : sid.getTemplateArguments()) {
                if (!(t instanceof Expression.TypeRefExpression)) continue;
                exprs.add(this.typeLiteral(((Expression.TypeRefExpression)t).getType().clone()));
            }
            return ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(DefaultParameterizedType.class)), (String)"paramType", (Expression[])exprs.toArray(new Expression[exprs.size()]));
        }
        return super.typeLiteral(c);
    }

    @Override
    public Expression getEnumItemValue(Enum.EnumItem enumItem, boolean forceConstants) {
        Map<String, TypeConversion.EnumItemResult> values;
        TypeConversion.EnumItemResult enumResult;
        Enum e = (Enum)enumItem.getParentElement();
        if (forceConstants && (enumResult = (values = this.getEnumValuesAndCommentsByName(e, null)).get(enumItem.getName())) != null) {
            return enumResult.constantValue;
        }
        Expression enumValue = this.findEnumItem(enumItem);
        if (e.getTag() != null) {
            enumValue = ElementsHelper.methodCall((Expression)enumValue, (String)"value", (Expression[])new Expression[0]);
        }
        return ElementsHelper.cast((TypeRef)ElementsHelper.typeRef(Integer.TYPE), (Expression)enumValue.setParenthesis(true));
    }

    public NL4JConversion convertTypeToNL4J(TypeRef valueType, Identifier libraryClassName, Expression structIOExpr, Expression valueExpr, int fieldIndex, int bits) throws UnsupportedConversionException {
        Identifier name;
        TypeRef original = valueType;
        TypeConversion.JavaPrim prim = this.getPrimitive(valueType = this.normalizeTypeRef(valueType));
        if (prim != null) {
            return this.convertPrimitiveTypeRefToNL4J(prim, structIOExpr, fieldIndex, valueExpr);
        }
        NL4JConversion conv = new NL4JConversion();
        if (valueType == null) {
            conv.type = TypeConversion.ConvType.Void;
            conv.typeRef = BridJTypeConversion.primRef((Element)valueType, TypeConversion.JavaPrim.Void);
            return conv;
        }
        if (valueType instanceof TypeRef.TargettedTypeRef) {
            TypeRef targetRef = ((TypeRef.TargettedTypeRef)valueType).getTarget();
            if (valueType instanceof TypeRef.ArrayRef) {
                TypeRef.ArrayRef arrayRef = (TypeRef.ArrayRef)valueType;
                ArrayList<Expression> sizes = new ArrayList<Expression>();
                for (Expression dim : arrayRef.flattenDimensions()) {
                    if (dim == null || dim instanceof Expression.EmptyArraySize) continue;
                    Expression m = (Expression)this.convertExpressionToJava(dim, libraryClassName, false, true, null).getFirst();
                    m.setParenthesis(false);
                    sizes.add(m);
                }
                if (!sizes.isEmpty()) {
                    conv.arrayLengths = sizes;
                }
            }
            try {
                conv.targetTypeConversion = this.convertTypeToNL4J(targetRef, libraryClassName, null, null, -1, -1);
            }
            catch (UnsupportedConversionException ex) {
                // empty catch block
            }
            if (this.allowFakePointers && (conv.targetTypeConversion == null || conv.targetTypeConversion.isUndefined) && original instanceof TypeRef.SimpleTypeRef) {
                conv.type = TypeConversion.ConvType.Pointer;
                conv.isTypedPointer = true;
                conv.typeRef = (TypeRef)ElementsHelper.typeRef((Identifier)this.result.getFakePointer(libraryClassName, ((TypeRef.SimpleTypeRef)original).getName().clone()));
                if (structIOExpr != null) {
                    if (conv.arrayLengths == null) {
                        conv.setFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"setPointerField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex), valueExpr});
                    }
                    conv.getFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"getTypedPointerField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex)});
                }
                return conv;
            }
            if (conv.targetTypeConversion == null) {
                conv.type = TypeConversion.ConvType.Pointer;
                conv.typeRef = ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
                return conv;
            }
            TypeRef pointedTypeRef = conv.targetTypeConversion.getIndirectTypeRef();
            if (pointedTypeRef != null) {
                conv.type = TypeConversion.ConvType.Pointer;
                conv.typeRef = (TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Class)this.result.config.runtime.pointerClass, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)pointedTypeRef.clone())}));
                if (conv.targetTypeConversion != null && conv.targetTypeConversion.type == TypeConversion.ConvType.Void) {
                    conv.pointerGetterName = "getPointer";
                    conv.pointerSetterName = "setPointer";
                }
                if (structIOExpr != null) {
                    if (conv.arrayLengths == null) {
                        conv.setFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"setPointerField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex), valueExpr});
                    }
                    conv.getFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"getPointerField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex)});
                }
                return conv;
            }
        } else if (valueType.getResolvedJavaIdentifier() != null) {
            conv.typeRef = (TypeRef)ElementsHelper.typeRef((Identifier)valueType.getResolvedJavaIdentifier().clone());
            if (valueType instanceof TypeRef.FunctionSignature) {
                conv.type = TypeConversion.ConvType.FunctionSignature;
            } else if (valueType instanceof Enum) {
                conv.type = TypeConversion.ConvType.Enum;
                conv.typeRef = (TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident(IntValuedEnum.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)conv.typeRef)}));
                if (structIOExpr != null) {
                    conv.setFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"setEnumField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex), valueExpr});
                    conv.getFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"getEnumField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex)});
                }
            } else if (valueType instanceof Struct) {
                conv.type = TypeConversion.ConvType.Struct;
                if (structIOExpr != null) {
                    conv.setFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"setNativeObjectField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex), valueExpr});
                    conv.getFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)"getNativeObjectField", (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex)});
                }
            } else {
                throw new RuntimeException("Failed to recognize conversion type: " + valueType);
            }
            return conv;
        }
        if (valueType instanceof TypeRef.SimpleTypeRef && this.allowFakePointers && (name = ((TypeRef.SimpleTypeRef)valueType).getName()) != null) {
            conv.type = TypeConversion.ConvType.Pointer;
            conv.typeRef = (TypeRef)ElementsHelper.typeRef((Identifier)this.result.getUndefinedType(libraryClassName, name.resolveLastSimpleIdentifier().clone()));
            conv.isUndefined = true;
            return conv;
        }
        throw new UnsupportedConversionException((Element)original, "Unsupported type");
    }

    @Override
    public TypeRef functionPointerTypeRef(TypeRef.FunctionSignature fs) {
        return this.pointerTypeRef((TypeRef)fs);
    }

    @Override
    public TypeRef pointerTypeRef(TypeRef targetTypeRef) {
        return ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Class)this.result.config.runtime.pointerClass, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)targetTypeRef.clone())}));
    }

    @Override
    public TypeRef findCallbackRef(TypeRef.FunctionSignature s, Identifier callerLibraryClass) {
        return this.pointerTypeRef(super.findCallbackRef(s, callerLibraryClass));
    }

    private NL4JConversion convertPrimitiveTypeRefToNL4J(TypeConversion.JavaPrim prim, Expression structIOExpr, int fieldIndex, Expression valueExpr) {
        String radix;
        NL4JConversion conv = new NL4JConversion();
        switch (prim) {
            case NativeLong: {
                conv.type = TypeConversion.ConvType.NativeLong;
                conv.typeRef = ElementsHelper.typeRef(Long.TYPE);
                conv.indirectType = ElementsHelper.typeRef(org.bridj.CLong.class);
                radix = "CLong";
                break;
            }
            case NativeSize: {
                conv.type = TypeConversion.ConvType.NativeSize;
                conv.typeRef = ElementsHelper.typeRef(Long.TYPE);
                conv.indirectType = ElementsHelper.typeRef(SizeT.class);
                radix = "SizeT";
                break;
            }
            case NativeTime: {
                conv.type = TypeConversion.ConvType.NativeTime;
                conv.typeRef = ElementsHelper.typeRef(TimeT.class);
                radix = "TimeT";
                break;
            }
            case Void: {
                conv.type = TypeConversion.ConvType.Void;
                conv.typeRef = BridJTypeConversion.primRef((Element)valueExpr, prim);
                radix = null;
                break;
            }
            case ComplexDouble: {
                conv.type = TypeConversion.ConvType.ComplexDouble;
                conv.typeRef = ElementsHelper.typeRef(ComplexDouble.class);
                radix = "NativeObject";
                break;
            }
            default: {
                conv.type = TypeConversion.ConvType.Primitive;
                conv.typeRef = BridJTypeConversion.primRef((Element)valueExpr, prim);
                conv.indirectType = ElementsHelper.typeRef(prim.wrapperType);
                radix = StringUtils.capitalize((String)prim.type.getName());
            }
        }
        if (radix != null && prim != TypeConversion.JavaPrim.NativeTime) {
            conv.pointerGetterName = "get" + radix;
            conv.pointerSetterName = "set" + radix;
        }
        if (structIOExpr != null && radix != null) {
            conv.setFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)("set" + radix + "Field"), (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex), valueExpr});
            conv.getFieldExpr = ElementsHelper.methodCall((Expression)structIOExpr.clone(), (String)("get" + radix + "Field"), (Expression[])new Expression[]{ElementsHelper.thisRef(), ElementsHelper.expr((int)fieldIndex)});
        }
        return conv;
    }

    public Expression getFlatArraySizeExpression(TypeRef.ArrayRef arrayRef, Identifier callerLibraryName) throws UnsupportedConversionException {
        Expression mul = null;
        List dims = arrayRef.flattenDimensions();
        int i = dims.size();
        while (i-- != 0) {
            Expression x = (Expression)dims.get(i);
            if (x == null || x instanceof Expression.EmptyArraySize) {
                return null;
            }
            Pair<Expression, TypeRef> c = this.convertExpressionToJava(x, callerLibraryName, false, true, null);
            ((Expression)c.getFirst()).setParenthesis(dims.size() > 1);
            if (mul == null) {
                mul = (Expression)c.getFirst();
                continue;
            }
            mul = ElementsHelper.expr((Expression)((Expression)c.getFirst()), (Expression.BinaryOperator)Expression.BinaryOperator.Multiply, (Expression)mul);
        }
        return mul;
    }

    protected Expression sizeofToJava(TypeRef type, Identifier libraryClassName) throws UnsupportedConversionException {
        Expression res;
        block12: {
            Struct s;
            block14: {
                block13: {
                    block11: {
                        type = this.normalizeTypeRef(type);
                        res = null;
                        if (!(type instanceof TypeRef.Pointer)) break block11;
                        res = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"SIZE");
                        break block12;
                    }
                    if (!(type instanceof TypeRef.ArrayRef)) break block13;
                    res = this.sizeofToJava(((TypeRef.ArrayRef)type).getTarget(), libraryClassName);
                    if (res == null) {
                        return null;
                    }
                    TypeRef.ArrayRef ar = (TypeRef.ArrayRef)type;
                    for (Expression x : ar.getDimensions()) {
                        Expression c = (Expression)this.convertExpressionToJava(x, libraryClassName, false, true, null).getFirst();
                        res = ElementsHelper.expr((Expression)res, (Expression.BinaryOperator)Expression.BinaryOperator.Multiply, (Expression)c);
                    }
                    break block12;
                }
                if (!(type instanceof TypeRef.SimpleTypeRef) && !(type instanceof TypeRef.Primitive)) break block14;
                TypeConversion.JavaPrim prim = this.getPrimitive(type);
                if (prim != null) {
                    res = this.sizeof(prim);
                } else {
                    TypeRef.SimpleTypeRef structRef = this.findStructRef(((TypeRef.SimpleTypeRef)type).getName(), libraryClassName);
                    if (structRef == null) {
                        structRef = this.findStructRef((Identifier)((TypeRef.SimpleTypeRef)type).getName().resolveLastSimpleIdentifier(), libraryClassName);
                    }
                    if (structRef != null) {
                        return ElementsHelper.methodCall((Expression)new Expression.New((TypeRef)structRef), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"size", (Expression[])new Expression[0]);
                    }
                }
                break block12;
            }
            if (!(type instanceof Struct) || (s = (Struct)type) == null) break block12;
            Identifier structName = this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)s);
            TypeRef.SimpleTypeRef structRef = this.findStructRef(structName, libraryClassName);
            if (structRef != null) {
                return ElementsHelper.methodCall((Expression)new Expression.New((TypeRef)structRef), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"size", (Expression[])new Expression[0]);
            }
            for (Declaration d : s.getDeclarations()) {
                if (!(d instanceof VariablesDeclaration)) continue;
                TypeRef varsType = d.getValueType();
                for (Declarator sto : ((VariablesDeclaration)d).getDeclarators()) {
                    Expression so = this.sizeofToJava((TypeRef)SyntaxUtils.as((Object)sto.mutateType((Declarator.MutableByDeclarator)varsType), TypeRef.class), libraryClassName);
                    if (so == null) {
                        return null;
                    }
                    if (res == null) {
                        res = so;
                        continue;
                    }
                    res = ElementsHelper.expr((Expression)res, (Expression.BinaryOperator)Expression.BinaryOperator.Plus, (Expression)so);
                }
            }
        }
        return res;
    }

    @Override
    public Pair<Expression, TypeRef> convertExpressionToJava(Expression x, Identifier libraryClassName, boolean promoteNativeLongToLong, boolean forceConstants, Map<String, Pair<Expression, TypeRef>> mappings) throws UnsupportedConversionException {
        Expression.TypeRefExpression typeEx;
        Expression.FunctionCall fc;
        Pair<Expression, TypeRef> res = null;
        if (x instanceof Expression.Cast) {
            TypeRef tpe = ((Expression.Cast)x).getType();
            Pair<Expression, TypeRef> casted = this.convertExpressionToJava(((Expression.Cast)x).getTarget(), libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
            NL4JConversion conv = this.convertTypeToNL4J(tpe, libraryClassName, null, null, -1, -1);
            TypeRef tr = conv.typeRef;
            Expression val = (Expression)casted.getFirst();
            if (TypeConversion.ConvType.Pointer.equals((Object)conv.type)) {
                val = this.isString(val) ? ElementsHelper.methodCall((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass)), (String)"pointerToCString", (Expression[])new Expression[]{val}), (String)"as", (Expression[])new Expression[]{this.typeLiteral(conv.targetTypeConversion.typeRef)}) : ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass)), (String)"pointerToAddress", (Expression[])new Expression[]{val, this.typeLiteral(conv.targetTypeConversion.typeRef)});
            }
            res = BridJTypeConversion.typed(val, tr);
        } else if (x instanceof Expression.FunctionCall && "sizeof".equals(String.valueOf((fc = (Expression.FunctionCall)x).getFunction())) && fc.getArguments().size() == 1 && (typeEx = (Expression.TypeRefExpression)SyntaxUtils.as((Object)((Pair)fc.getArguments().get(0)).getValue(), Expression.TypeRefExpression.class)) != null) {
            res = BridJTypeConversion.typed(this.sizeofToJava(typeEx.getType(), libraryClassName), ElementsHelper.typeRef(Integer.TYPE));
        }
        if (res == null) {
            return super.convertExpressionToJava(x, libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
        }
        if (res.getFirst() == null) {
            return null;
        }
        ((Expression)res.getFirst()).setParenthesis(x.getParenthesis());
        return res;
    }

    @Override
    protected TypeConversion.JavaPrim getCppBoolMappingType() {
        return TypeConversion.JavaPrim.Boolean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NL4JConversion {
        public TypeConversion.ConvType type = TypeConversion.ConvType.Default;
        public NL4JConversion targetTypeConversion;
        private TypeRef typeRef;
        private TypeRef indirectType;
        public List<Expression> arrayLengths;
        public Expression bits;
        public Expression getFieldExpr;
        public Expression setFieldExpr;
        public String pointerGetterName;
        public String pointerSetterName;
        public boolean wideString;
        public boolean readOnly;
        public boolean byValue;
        public boolean nativeSize;
        public boolean cLong;
        public boolean isUndefined;
        public boolean isTypedPointer;
        public Charset charset;
        public final List<Annotation> annotations = new ArrayList<Annotation>();

        public TypeRef getTypeRef(boolean useRawTypes) {
            if (useRawTypes) {
                switch (this.type) {
                    case Pointer: {
                        return ElementsHelper.typeRef(Long.TYPE);
                    }
                    case Enum: {
                        return ElementsHelper.typeRef(Integer.TYPE);
                    }
                }
                return this.typeRef;
            }
            return this.typeRef;
        }

        public Expression arrayLength() {
            Expression length = null;
            for (Expression m : this.arrayLengths) {
                m.setParenthesis(true);
                if (length == null) {
                    length = m.clone();
                    continue;
                }
                length = ElementsHelper.expr((Expression)length, (Expression.BinaryOperator)Expression.BinaryOperator.Multiply, (Expression)m.clone());
            }
            return length.setParenthesis(this.arrayLengths.size() > 1);
        }

        public TypeRef getIndirectTypeRef() {
            if (this.type == TypeConversion.ConvType.Void) {
                return ElementsHelper.typeRef((Identifier)ElementsHelper.ident((String[])new String[]{"?"}));
            }
            if (this.type == TypeConversion.ConvType.NativeSize) {
                return ElementsHelper.typeRef(SizeT.class);
            }
            if (this.type == TypeConversion.ConvType.NativeTime) {
                return ElementsHelper.typeRef(TimeT.class);
            }
            if (this.type == TypeConversion.ConvType.NativeLong) {
                return ElementsHelper.typeRef(org.bridj.CLong.class);
            }
            if (this.type == TypeConversion.ConvType.ComplexDouble) {
                return ElementsHelper.typeRef(ComplexDouble.class);
            }
            TypeRef t = this.indirectType == null ? this.typeRef : this.indirectType;
            return t == null ? null : t.clone();
        }

        public <M extends ModifiableElement> M annotateRawType(M element) throws UnsupportedConversionException {
            element.addAnnotations(this.annotations);
            if (this.type != null) {
                switch (this.type) {
                    case Enum: 
                    case Primitive: 
                    case Void: {
                        break;
                    }
                    case NativeLong: {
                        element.addAnnotation(new Annotation(ElementsHelper.typeRef(CLong.class)));
                        break;
                    }
                    case NativeSize: {
                        element.addAnnotation(new Annotation(ElementsHelper.typeRef(Ptr.class)));
                        break;
                    }
                    case Pointer: {
                        element.addAnnotation(new Annotation(ElementsHelper.typeRef(Ptr.class)));
                        break;
                    }
                    case Struct: 
                    case ComplexDouble: 
                    case FunctionSignature: 
                    case Default: 
                    case NativeTime: {
                        break;
                    }
                    default: {
                        throw new UnsupportedConversionException((Element)this.typeRef, "Not supported");
                    }
                }
            }
            return element;
        }

        public <M extends ModifiableElement> M annotateTypedType(M element, boolean useRawTypes) throws UnsupportedConversionException {
            element.addAnnotations(this.annotations);
            if (this.type != TypeConversion.ConvType.Pointer || useRawTypes) {
                this.annotateRawType(element);
            }
            return element;
        }
    }
}

