/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.google.common.collect.ImmutableMap;
import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.BridJTypeConversion;
import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.EmptyDeclaration;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.util.string.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.TypedPointer;
import org.bridj.ann.Convention;
import org.bridj.ann.Library;
import org.bridj.ann.Name;
import org.bridj.ann.Namespace;
import org.bridj.ann.Optional;
import org.bridj.ann.Runtime;
import org.bridj.cpp.CPPObject;
import org.bridj.cpp.CPPRuntime;
import org.bridj.cpp.com.IUnknown;
import org.bridj.objc.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridJDeclarationsConverter
extends DeclarationsConverter {
    Map<Identifier, Boolean> structsVirtuality = new LinkedHashMap<Identifier, Boolean>();
    protected String ioVarName = "io";
    protected String ioStaticVarName = "IO";
    int nextAnonymousFieldId;

    public BridJDeclarationsConverter(Result result) {
        super(result);
    }

    public void annotateActualName(ModifiableElement e, Identifier name) {
        e.addAnnotation(new Annotation(ElementsHelper.typeRef(Name.class), ElementsHelper.expr((String)name.toString())));
    }

    @Override
    public Struct convertCallback(TypeRef.FunctionSignature functionSignature, Signatures signatures, Identifier callerLibraryName) {
        Struct decl = super.convertCallback(functionSignature, signatures, callerLibraryName);
        if (decl != null) {
            decl.setParents(Arrays.asList(TypeRef.FunctionSignature.Type.ObjCBlock.equals((Object)functionSignature.getType()) ? this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.ObjCBlock) : ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Class)this.result.config.runtime.callbackClass, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)decl.getTag().clone()))}))));
        }
        return decl;
    }

    @Override
    public void convertEnum(Enum e, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
        if (e.isForwardDeclaration()) {
            return;
        }
        Identifier rawEnumName = this.getActualTaggedTypeName((TypeRef.TaggedTypeRef)e);
        Map<String, TypeConversion.EnumItemResult> results = this.result.typeConverter.getEnumValuesAndCommentsByName(e, libraryClassName);
        boolean hasEnumClass = false;
        if (rawEnumName != null && rawEnumName.resolveLastSimpleIdentifier().getName() != null) {
            hasEnumClass = true;
            Identifier enumName = this.result.typeConverter.getValidJavaIdentifier(rawEnumName);
            if (!signatures.addClass(enumName)) {
                return;
            }
            signatures = new Signatures();
            Enum en = new Enum();
            if (this.result.config.forceNames || !rawEnumName.equals((Object)enumName)) {
                this.annotateActualName((ModifiableElement)en, rawEnumName);
            }
            this.addParentNamespaceAnnotation((ModifiableElement)en, e.getParentNamespace());
            if (!this.result.config.noComments) {
                en.importComments((Element)e, new String[]{"enum values", this.getFileCommentContent((Element)e)});
            }
            en.setType(Enum.Type.Java);
            en.setTag(enumName.clone());
            en.addModifiers(new Modifier[]{ModifierType.Public});
            out.addDeclaration((Declaration)new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)en));
            Struct body = new Struct();
            en.setBody(body);
            boolean hasValidItem = false;
            for (TypeConversion.EnumItemResult er : results.values()) {
                if (er.errorElement != null) {
                    out.addDeclaration(er.errorElement);
                    continue;
                }
                String itemName = this.result.typeConverter.getValidJavaIdentifierString(ElementsHelper.ident((String[])new String[]{er.originalItem.getName()}));
                Enum.EnumItem item = new Enum.EnumItem(itemName, new Expression[]{er.convertedValue});
                en.addItem(item);
                hasValidItem = true;
                if (this.result.config.noComments || item == null) continue;
                item.importComments((Element)er.originalItem, new String[0]);
            }
            if (hasValidItem) {
                en.addInterface(ElementsHelper.ident(IntValuedEnum.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)enumName.clone()))}));
                String valueArgName = "value";
                body.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, enumName.clone(), null, new Arg[]{new Arg(valueArgName, ElementsHelper.typeRef(Long.TYPE))}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.expr((Expression)ElementsHelper.memberRef((Expression)ElementsHelper.thisRef(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)valueArgName), (Expression.AssignmentOperator)Expression.AssignmentOperator.Equal, (Expression)ElementsHelper.varRef((String)valueArgName)))})));
                body.addDeclaration((Declaration)new VariablesDeclaration(ElementsHelper.typeRef(Long.TYPE), new Declarator[]{new Declarator.DirectDeclarator(valueArgName)}).addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Final}));
                body.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{valueArgName}), ElementsHelper.typeRef(Long.TYPE)).setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return(ElementsHelper.memberRef((Expression)ElementsHelper.thisRef(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)valueArgName))})).addModifiers(new Modifier[]{ModifierType.Public}));
                body.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{"iterator"}), (TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident(Iterator.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)enumName.clone()))}))).setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Collections.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"singleton", (Expression[])new Expression[]{ElementsHelper.thisRef()}), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"iterator", (Expression[])new Expression[0]))})).addModifiers(new Modifier[]{ModifierType.Public}));
                body.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{"fromValue"}), (TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident(IntValuedEnum.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)enumName.clone()))})), new Arg[]{new Arg(valueArgName, ElementsHelper.typeRef(Integer.TYPE))}).setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(FlagSet.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"fromValue", (Expression[])new Expression[]{ElementsHelper.varRef((String)valueArgName), ElementsHelper.methodCall((String)"values", (Expression[])new Expression[0])}))})).addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static}));
            }
        } else {
            this.outputEnumItemsAsConstants(results, out, signatures, libraryClassName, hasEnumClass);
        }
    }

    void addCallingConventionAnnotation(Function originalFunction, ModifiableElement target) {
        Convention.Style cc = null;
        if (originalFunction.hasModifier((Modifier)ModifierType.__stdcall)) {
            cc = Convention.Style.StdCall;
        } else if (originalFunction.hasModifier((Modifier)ModifierType.__fastcall)) {
            cc = Convention.Style.FastCall;
        } else if (originalFunction.hasModifier((Modifier)ModifierType.__thiscall)) {
            cc = Convention.Style.ThisCall;
        } else if (originalFunction.hasModifier((Modifier)ModifierType.__pascal)) {
            cc = Convention.Style.Pascal;
        }
        if (cc != null) {
            target.addAnnotation(new Annotation(ElementsHelper.typeRef(Convention.class), ElementsHelper.enumRef((java.lang.Enum)cc)));
        }
    }

    @Override
    public void convertFunction(Function function, Signatures signatures, boolean isCallback, DeclarationsHolder declarations, DeclarationsHolder implementations, Identifier libraryClassName, String sig, Identifier functionName, String library, int iConstructor) throws UnsupportedConversionException {
        assert (implementations != null);
        boolean extractingDeclarations = declarations != null && declarations.resolveHolder() != implementations.resolveHolder();
        Element parent = function.getParentElement();
        Struct.MemberVisibility visibility = function.getVisibility();
        boolean isPublic = visibility == Struct.MemberVisibility.Public || function.hasModifier((Modifier)ModifierType.Public);
        boolean isPrivate = visibility == Struct.MemberVisibility.Private || function.hasModifier((Modifier)ModifierType.Private);
        boolean isProtected = visibility == Struct.MemberVisibility.Protected || function.hasModifier((Modifier)ModifierType.Protected);
        boolean isInStruct = parent instanceof Struct;
        if (isInStruct && this.result.config.skipPrivateMembers && (isPrivate || !isPublic && !isProtected)) {
            return;
        }
        boolean isStatic = function.hasModifier((Modifier)ModifierType.Static);
        boolean isConstructor = iConstructor != -1;
        Function nativeMethod = new Function(Function.Type.JavaMethod, ElementsHelper.ident((Identifier)functionName, (Identifier[])new Identifier[0]), null);
        if (this.result.config.synchronizedMethods && !isCallback) {
            nativeMethod.addModifiers(new Modifier[]{ModifierType.Synchronized});
        }
        this.addCallingConventionAnnotation(function, (ModifiableElement)nativeMethod);
        boolean annotatedActualName = false;
        if (!(function.getName() == null || isCallback || functionName.toString().equals(function.getName().toString()) && !this.result.config.forceNames)) {
            this.annotateActualName((ModifiableElement)nativeMethod, function.getName());
            annotatedActualName = true;
        }
        Function rawMethod = nativeMethod.clone();
        boolean isObjectiveC = function.getType() == Function.Type.ObjCMethod;
        TreeSet<String> argNames = new TreeSet<String>();
        ArrayList<Expression> superConstructorArgs = null;
        if (isConstructor) {
            superConstructorArgs = new ArrayList<Expression>();
            superConstructorArgs.add(ElementsHelper.cast((TypeRef)ElementsHelper.typeRef(Void.class), (Expression)ElementsHelper.nullExpr()));
            superConstructorArgs.add(ElementsHelper.expr((int)iConstructor));
        }
        Identifier varArgType = null;
        String varArgName = null;
        BridJTypeConversion.NL4JConversion returnType = null;
        ArrayList<BridJTypeConversion.NL4JConversion> paramTypes = new ArrayList<BridJTypeConversion.NL4JConversion>();
        ArrayList<String> paramNames = new ArrayList<String>();
        if (!isConstructor) {
            returnType = ((BridJTypeConversion)this.result.typeConverter).convertTypeToNL4J(function.getValueType(), libraryClassName, null, null, -1, -1);
        }
        int nArgs = function.getArgs().size();
        for (int iArg = 0; iArg < nArgs; ++iArg) {
            Object paramName;
            Arg arg = (Arg)function.getArgs().get(iArg);
            boolean isVarArgs = BridJDeclarationsConverter.isVarArgs(arg);
            if (isVarArgs && iArg == nArgs - 1) {
                varArgName = this.chooseJavaArgName(arg.getName() == null ? "varargs" : arg.getName(), iArg + 1, argNames);
                paramName = varArgName;
                varArgType = ElementsHelper.ident(isObjectiveC ? NSObject.class : Object.class, (Expression[])new Expression[0]);
            } else {
                TypeRef argType = arg.getValueType();
                if (isVarArgs) {
                    argType = new TypeRef.Pointer(ElementsHelper.typeRef(Void.TYPE), Declarator.PointerStyle.Pointer);
                }
                paramName = this.chooseJavaArgName(arg.getName(), iArg + 1, argNames);
                paramTypes.add(((BridJTypeConversion)this.result.typeConverter).convertTypeToNL4J(argType, libraryClassName, null, null, -1, -1));
            }
            paramNames.add((String)paramName);
            if (!isConstructor) continue;
            superConstructorArgs.add(ElementsHelper.varRef((String)paramName));
        }
        this.fillIn(signatures, functionName, nativeMethod, returnType, paramTypes, paramNames, varArgType, varArgName, isCallback, false);
        ArrayList<Function> extractibleDecls = new ArrayList<Function>();
        Statement.Block convertedBody = null;
        if (isConstructor) {
            convertedBody = ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])superConstructorArgs.toArray(new Expression[superConstructorArgs.size()])))});
        } else if (this.result.config.convertBodies && function.getBody() != null) {
            try {
                Pair<Element, List<Declaration>> bodyAndExtraDeclarations = this.result.bridjer.convertToJava((Element)function.getBody(), libraryClassName);
                convertedBody = (Statement.Block)bodyAndExtraDeclarations.getFirst();
                for (Declaration d : (List)bodyAndExtraDeclarations.getSecond()) {
                    implementations.addDeclaration(d);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                nativeMethod.addToCommentBefore(new String[]{"TRANSLATION OF BODY FAILED: " + ex});
            }
        }
        if (!this.result.config.noComments) {
            nativeMethod.importComments((Element)function, new String[]{isCallback ? null : this.getFileCommentContent((Element)function)});
        }
        boolean generateStaticMethod = (isStatic || !isCallback && !isInStruct) && (declarations == null || implementations == declarations);
        nativeMethod.addModifiers(new Modifier[]{isProtected && !extractingDeclarations && !this.result.config.publicRawBindings ? ModifierType.Protected : ModifierType.Public, generateStaticMethod ? ModifierType.Static : null});
        boolean isOptional = this.isOptionalFunction(function.getName() + "");
        implementations.addDeclaration((Declaration)nativeMethod);
        boolean forwardedToRaw = false;
        if (convertedBody == null) {
            if (this.result.config.genRawBindings) {
                rawMethod.setArgs(Collections.EMPTY_LIST);
                this.fillIn(signatures, functionName, rawMethod, returnType, paramTypes, paramNames, varArgType, varArgName, isCallback, true);
                rawMethod.addModifiers(new Modifier[]{extractingDeclarations || isCallback || this.result.config.publicRawBindings ? ModifierType.Public : ModifierType.Protected, isCallback ? ModifierType.Abstract : ModifierType.Native});
                if (generateStaticMethod) {
                    rawMethod.addModifiers(new Modifier[]{ModifierType.Static});
                }
                if (!nativeMethod.computeSignature(Function.SignatureType.ArgsAndRet).equals(rawMethod.computeSignature(Function.SignatureType.ArgsAndRet))) {
                    implementations.addDeclaration((Declaration)rawMethod);
                    extractibleDecls.add(rawMethod);
                    if (isOptional && !isCallback) {
                        rawMethod.addAnnotation(new Annotation(ElementsHelper.typeRef(Optional.class)));
                    }
                    ArrayList<Expression> objectToRawFollowedArgs = new ArrayList<Expression>();
                    ArrayList<Expression> arrayList = new ArrayList<Expression>();
                    int n = paramTypes.size();
                    block13: for (int i = 0; i < n; ++i) {
                        BridJTypeConversion.NL4JConversion paramType = (BridJTypeConversion.NL4JConversion)paramTypes.get(i);
                        String paramName = (String)paramNames.get(i);
                        switch (paramType.type) {
                            case Pointer: {
                                objectToRawFollowedArgs.add(this.createGetPeerExpression(ElementsHelper.varRef((String)paramName)));
                                arrayList.add(this.createPointerToAddressExpression(paramType, ElementsHelper.varRef((String)paramName)));
                                continue block13;
                            }
                            case Enum: {
                                objectToRawFollowedArgs.add(this.createGetEnumValueExpression(ElementsHelper.varRef((String)paramName)));
                                arrayList.add(this.createEnumExpression(paramType, ElementsHelper.varRef((String)paramName)));
                                continue block13;
                            }
                            default: {
                                objectToRawFollowedArgs.add(ElementsHelper.varRef((String)paramName));
                                arrayList.add(ElementsHelper.varRef((String)paramName));
                            }
                        }
                    }
                    if (varArgType != null) {
                        objectToRawFollowedArgs.add(ElementsHelper.varRef((String)varArgName));
                        arrayList.add(ElementsHelper.varRef((String)varArgName));
                    }
                    Expression.FunctionCall objectToRawFollowedCall = ElementsHelper.methodCall((String)rawMethod.getName().toString(), (Expression[])objectToRawFollowedArgs.toArray(new Expression[objectToRawFollowedArgs.size()]));
                    Expression.FunctionCall rawToObjectFollowedCall = ElementsHelper.methodCall((String)nativeMethod.getName().toString(), (Expression[])arrayList.toArray(new Expression[arrayList.size()]));
                    boolean isVoid = "void".equals(String.valueOf(nativeMethod.getValueType()));
                    if (isVoid) {
                        nativeMethod.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)objectToRawFollowedCall)}));
                        if (isCallback) {
                            rawMethod.removeModifiers(new Modifier[]{ModifierType.Abstract});
                            rawMethod.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)rawToObjectFollowedCall)}));
                        }
                    } else {
                        switch (returnType.type) {
                            case Pointer: {
                                objectToRawFollowedCall = this.createPointerToAddressExpression(returnType, (Expression)objectToRawFollowedCall);
                                rawToObjectFollowedCall = this.createGetPeerExpression((Expression)rawToObjectFollowedCall);
                                break;
                            }
                            case Enum: {
                                objectToRawFollowedCall = this.createEnumExpression(returnType, (Expression)objectToRawFollowedCall);
                                rawToObjectFollowedCall = this.createGetEnumValueExpression((Expression)rawToObjectFollowedCall);
                                break;
                            }
                            case NativeLong: 
                            case NativeSize: {
                                if (rawMethod.getValueType().toString().equals("long")) break;
                                objectToRawFollowedCall = new Expression.New(nativeMethod.getValueType().clone(), new Expression[]{objectToRawFollowedCall});
                                rawToObjectFollowedCall = this.createGetIntegralValueExpression((Expression)rawToObjectFollowedCall);
                            }
                        }
                        nativeMethod.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)objectToRawFollowedCall)}));
                        if (isCallback) {
                            rawMethod.removeModifiers(new Modifier[]{ModifierType.Abstract});
                            rawMethod.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)rawToObjectFollowedCall)}));
                        } else if (function.getName() != null && !function.getName().equals((Object)rawMethod.getName()) && !annotatedActualName) {
                            this.annotateActualName((ModifiableElement)rawMethod, function.getName());
                            annotatedActualName = true;
                        }
                    }
                    forwardedToRaw = true;
                }
            }
            if (!forwardedToRaw) {
                nativeMethod.addModifiers(new Modifier[]{isCallback ? ModifierType.Abstract : ModifierType.Native});
                if (isOptional && !isCallback) {
                    nativeMethod.addAnnotation(new Annotation(ElementsHelper.typeRef(Optional.class)));
                }
            }
        } else {
            nativeMethod.setBody(convertedBody);
        }
        if (!forwardedToRaw && convertedBody == null) {
            extractibleDecls.add(nativeMethod);
        }
        for (Declaration declaration : extractibleDecls) {
            if (!extractingDeclarations || !(declaration instanceof Function)) continue;
            Function m = (Function)declaration.clone();
            m.setBody(null);
            m.removeModifiers(new Modifier[]{ModifierType.Abstract, ModifierType.Final, ModifierType.Static, ModifierType.Native, ModifierType.Public, ModifierType.Protected});
            declarations.addDeclaration((Declaration)m);
        }
    }

    private Expression createGetEnumValueExpression(Expression value) {
        return ElementsHelper.cast((TypeRef)ElementsHelper.typeRef(Integer.TYPE), (Expression)ElementsHelper.methodCall((Expression)value, (String)"value", (Expression[])new Expression[0]));
    }

    private Expression createGetIntegralValueExpression(Expression value) {
        return ElementsHelper.methodCall((Expression)value, (String)"longValue", (Expression[])new Expression[0]);
    }

    private Expression createGetPeerExpression(Expression value) {
        return ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Pointer.class)), (String)"getPeer", (Expression[])new Expression[]{value});
    }

    private Expression createPointerToAddressExpression(BridJTypeConversion.NL4JConversion pointerType, Expression value) {
        TypeRef tr = pointerType.getTypeRef(false);
        if (pointerType.isTypedPointer) {
            return new Expression.New(tr, new Expression[]{value});
        }
        Expression ptrExpr = ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Pointer.class));
        Expression targetTypeExpr = this.result.typeConverter.typeLiteral(ElementsHelper.getSingleTypeParameter((TypeRef)tr));
        if (targetTypeExpr == null || pointerType.targetTypeConversion != null && pointerType.targetTypeConversion.type == TypeConversion.ConvType.Void) {
            return ElementsHelper.methodCall((Expression)ptrExpr, (String)"pointerToAddress", (Expression[])new Expression[]{value});
        }
        return ElementsHelper.cast((TypeRef)ElementsHelper.typeRef(Pointer.class), (Expression)ElementsHelper.methodCall((Expression)ptrExpr, (String)"pointerToAddress", (Expression[])new Expression[]{value, targetTypeExpr}));
    }

    private Expression createEnumExpression(BridJTypeConversion.NL4JConversion enumType, Expression value) {
        TypeRef tr = enumType.getTypeRef(false);
        return ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(FlagSet.class)), (String)"fromValue", (Expression[])new Expression[]{value, this.result.typeConverter.typeLiteral(ElementsHelper.getSingleTypeParameter((TypeRef)tr))});
    }

    private void fillIn(Signatures signatures, Identifier functionName, Function nativeMethod, BridJTypeConversion.NL4JConversion returnType, List<BridJTypeConversion.NL4JConversion> paramTypes, List<String> paramNames, Identifier varArgType, String varArgName, boolean isCallback, boolean useRawTypes) {
        Identifier javaMethodName;
        int n = paramTypes.size();
        for (int i = 0; i < n; ++i) {
            BridJTypeConversion.NL4JConversion paramType = paramTypes.get(i);
            String paramName = paramNames.get(i);
            nativeMethod.addArg(paramType.annotateTypedType(new Arg(paramName, paramType.getTypeRef(useRawTypes)), useRawTypes));
        }
        if (varArgType != null) {
            nativeMethod.addArg(new Arg(varArgName, (TypeRef)ElementsHelper.typeRef((Identifier)varArgType.clone()))).setVarArg(true);
        }
        if (returnType != null) {
            returnType.annotateTypedType(nativeMethod, useRawTypes);
            nativeMethod.setValueType(returnType.getTypeRef(useRawTypes));
        }
        String natSig = nativeMethod.computeSignature(Function.SignatureType.JavaStyle);
        Identifier identifier = javaMethodName = signatures == null ? functionName : signatures.findNextMethodName(natSig, functionName);
        if (!javaMethodName.equals((Object)functionName)) {
            nativeMethod.setName(javaMethodName);
        }
    }

    @Override
    public Struct convertStruct(Struct struct, Signatures signatures, Identifier callerLibraryClass, String callerLibrary, boolean onlyFields) throws IOException {
        Identifier structName = this.getActualTaggedTypeName((TypeRef.TaggedTypeRef)struct);
        if (structName == null) {
            return null;
        }
        if (struct.isForwardDeclaration()) {
            return null;
        }
        if (!signatures.addClass(structName)) {
            return null;
        }
        boolean isUnion = struct.getType() == Struct.Type.CUnion;
        boolean inheritsFromStruct = false;
        Identifier baseClass = null;
        int parentFieldsCount = 0;
        ArrayList<String> preComments = new ArrayList<String>();
        for (Object parentName : struct.getParents()) {
            Struct parent = this.result.structsByName.get(parentName.getName());
            if (parent == null) continue;
            try {
                parentFieldsCount += this.countFieldsInStruct(parent);
            }
            catch (UnsupportedConversionException ex) {
                preComments.add("Error: " + ex);
            }
            if ((baseClass = this.result.typeConverter.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)parent)) == null) continue;
            inheritsFromStruct = true;
            break;
        }
        boolean hasMemberFunctions = false;
        for (Declaration d : struct.getDeclarations()) {
            if (!(d instanceof Function)) continue;
            hasMemberFunctions = true;
            break;
        }
        Expression.Constant uuid = (Expression.Constant)struct.getModifierValue(ModifierType.UUID);
        if (baseClass == null) {
            switch (struct.getType()) {
                case CStruct: 
                case CUnion: {
                    if (!hasMemberFunctions) {
                        baseClass = ElementsHelper.ident(StructObject.class, (Expression[])new Expression[0]);
                        break;
                    }
                }
                case CPPClass: {
                    baseClass = ElementsHelper.ident(uuid == null ? CPPObject.class : IUnknown.class, (Expression[])new Expression[0]);
                    this.result.hasCPlusPlus = true;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        Struct structJavaClass = this.publicStaticClass(structName, baseClass, Struct.Type.JavaClass, (Element)struct, new Identifier[0]);
        if (!this.result.config.noStaticInit) {
            structJavaClass.addDeclaration((Declaration)this.newStaticInit());
        }
        if (uuid != null) {
            structJavaClass.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.IID), (Expression)uuid));
        }
        structJavaClass.setResolvedJavaIdentifier(ElementsHelper.ident((Identifier)structName, (Identifier[])new Identifier[0]));
        if (this.result.config.forceNames) {
            this.annotateActualName((ModifiableElement)structJavaClass, structName);
        }
        this.addParentNamespaceAnnotation((ModifiableElement)structJavaClass, struct.getParentNamespace());
        structJavaClass.addToCommentBefore(preComments);
        int[] iChild = new int[]{parentFieldsCount};
        Signatures childSignatures = new Signatures();
        if (isUnion) {
            structJavaClass.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Union)));
        }
        int iVirtual = 0;
        int iConstructor = 0;
        boolean succeeded = true;
        for (Declaration d : struct.getDeclarations()) {
            String library;
            boolean isConstructor;
            if (d instanceof VariablesDeclaration) {
                succeeded = this.convertVariablesDeclaration((VariablesDeclaration)d, childSignatures, (DeclarationsHolder)structJavaClass, iChild, false, structName, callerLibraryClass, callerLibrary) && succeeded;
                continue;
            }
            if (onlyFields) continue;
            if (d instanceof TaggedTypeRefDeclaration) {
                TypeRef.TaggedTypeRef tr = ((TaggedTypeRefDeclaration)d).getTaggedTypeRef();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, (DeclarationsHolder)structJavaClass, callerLibrary, false);
                    continue;
                }
                if (!(tr instanceof Enum)) continue;
                this.convertEnum((Enum)tr, childSignatures, (DeclarationsHolder)structJavaClass, callerLibraryClass);
                continue;
            }
            if (d instanceof StoredDeclarations.TypeDef) {
                TypeRef target;
                StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)d;
                TypeRef tr = td.getValueType();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, (DeclarationsHolder)structJavaClass, callerLibrary, false);
                    continue;
                }
                TypeRef.FunctionSignature fs = null;
                if (tr instanceof TypeRef.FunctionSignature) {
                    fs = (TypeRef.FunctionSignature)tr;
                } else if (tr instanceof TypeRef.Pointer && (target = ((TypeRef.Pointer)tr).getTarget()) instanceof TypeRef.FunctionSignature) {
                    fs = (TypeRef.FunctionSignature)target;
                }
                if (fs == null) continue;
                this.convertCallback(fs, childSignatures, (DeclarationsHolder)structJavaClass, callerLibraryClass);
                continue;
            }
            if (!this.result.config.genCPlusPlus || !(d instanceof Function)) continue;
            Function f = (Function)d;
            boolean isVirtual = f.hasModifier((Modifier)ModifierType.Virtual);
            boolean bl = isConstructor = f.getName().equals((Object)structName) && (f.getValueType() == null || f.getValueType().toString().equals("void"));
            if (isConstructor && f.getArgs().isEmpty() || (library = this.result.getLibrary((Element)struct)) == null) continue;
            ArrayList decls = new ArrayList();
            DeclarationsHolder.ListWrapper out = new DeclarationsHolder.ListWrapper(decls);
            this.convertFunction(f, childSignatures, false, (DeclarationsHolder)out, (DeclarationsHolder)out, callerLibraryClass, isConstructor ? iConstructor : -1);
            for (Declaration md : decls) {
                if (!(md instanceof Function)) continue;
                Function method = (Function)md;
                boolean commentOut = false;
                if (isVirtual) {
                    method.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Virtual), ElementsHelper.expr((int)iVirtual)));
                } else if (method.getValueType() == null) {
                    method.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Constructor), ElementsHelper.expr((int)iConstructor)));
                    isConstructor = true;
                }
                if (method.getName().toString().equals("operator")) {
                    commentOut = true;
                }
                if (commentOut) {
                    structJavaClass.addDeclaration((Declaration)new EmptyDeclaration(new String[]{method.toString()}));
                    continue;
                }
                structJavaClass.addDeclaration((Declaration)method);
            }
            if (isVirtual) {
                ++iVirtual;
            }
            if (!isConstructor) continue;
            ++iConstructor;
        }
        if (succeeded) {
            Function defaultConstructor = new Function(Function.Type.JavaMethod, ElementsHelper.ident((Identifier)structName, (Identifier[])new Identifier[0]), null).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0]))})).addModifiers(new Modifier[]{ModifierType.Public});
            if (childSignatures.addMethod(defaultConstructor)) {
                structJavaClass.addDeclaration((Declaration)defaultConstructor);
            }
            String ptrName = "pointer";
            Function castConstructor = new Function(Function.Type.JavaMethod, ElementsHelper.ident((Identifier)structName, (Identifier[])new Identifier[0]), null, new Arg[]{new Arg(ptrName, ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass))}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[]{ElementsHelper.varRef((String)ptrName)}))})).addModifiers(new Modifier[]{ModifierType.Public});
            if (childSignatures.addMethod(castConstructor)) {
                structJavaClass.addDeclaration((Declaration)castConstructor);
            }
        } else {
            structJavaClass.addModifiers(new Modifier[]{ModifierType.Abstract});
        }
        return structJavaClass;
    }

    public boolean isVirtual(Struct struct) {
        Identifier name = this.getActualTaggedTypeName((TypeRef.TaggedTypeRef)struct);
        Boolean bVirtual = this.structsVirtuality.get(name);
        if (bVirtual == null) {
            boolean hasVirtualParent = false;
            boolean hasVirtualMembers = false;
            for (TypeRef.SimpleTypeRef parentName : struct.getParents()) {
                Struct parentStruct = this.result.structsByName.get(parentName.getName());
                if (parentStruct == null) {
                    if (!this.result.config.verbose) continue;
                    System.out.println("Failed to resolve parent '" + parentName + "' for struct '" + name + "'");
                    continue;
                }
                if (!this.isVirtual(parentStruct)) continue;
                hasVirtualParent = true;
                break;
            }
            for (Declaration mb : struct.getDeclarations()) {
                if (!mb.hasModifier((Modifier)ModifierType.Virtual)) continue;
                hasVirtualMembers = true;
                break;
            }
            bVirtual = hasVirtualMembers && !hasVirtualParent;
            this.structsVirtuality.put(name, bVirtual);
        }
        return bVirtual;
    }

    public List<Declaration> convertVariablesDeclarationToBridJ(String name, TypeRef mutatedType, int[] iChild, int bits, boolean isGlobal, Identifier holderName, Identifier callerLibraryName, String callerLibrary, Element ... toImportDetailsFrom) throws UnsupportedConversionException {
        name = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident((String[])new String[]{name})).toString();
        boolean useRawTypes = false;
        int fieldIndex = iChild[0];
        BridJTypeConversion.NL4JConversion conv = ((BridJTypeConversion)this.result.typeConverter).convertTypeToNL4J(mutatedType, callerLibraryName, ElementsHelper.thisField((String)"io"), ElementsHelper.varRef((String)name), fieldIndex, bits);
        if (conv == null) {
            throw new UnsupportedConversionException((Element)mutatedType, "failed to convert type to Java");
        }
        if (conv.isUndefined) {
            throw new UnsupportedConversionException((Element)mutatedType, "failed to convert type to Java (undefined type)");
        }
        if ("void".equals(String.valueOf(conv.getTypeRef(false)))) {
            throw new UnsupportedConversionException((Element)mutatedType, "void type !");
        }
        Function convDecl = new Function();
        conv.annotateTypedType(convDecl, false);
        convDecl.setType(Function.Type.JavaMethod);
        convDecl.addModifiers(new Modifier[]{ModifierType.Public});
        if (conv.arrayLengths != null) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Length), (Expression)new Expression.OpaqueExpression("{" + StringUtils.implode(conv.arrayLengths, (Object)", ") + "}")));
        }
        if (conv.bits != null) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Bits), conv.bits));
        }
        if (conv.byValue) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.ByValue)));
        }
        for (Element e : toImportDetailsFrom) {
            convDecl.importDetails(e, false);
        }
        convDecl.importDetails((Element)mutatedType, true);
        convDecl.moveAllCommentsBefore();
        convDecl.deDioxygenizeCommentBefore();
        convDecl.setName(ElementsHelper.ident((String[])new String[]{name}));
        if (!isGlobal) {
            convDecl.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Field), ElementsHelper.expr((int)fieldIndex)));
        }
        convDecl.setValueType(conv.getTypeRef(false));
        TypeRef javaType = convDecl.getValueType();
        String pointerGetSetMethodSuffix = StringUtils.capitalize((String)javaType.toString());
        ArrayList<Declaration> out = new ArrayList<Declaration>();
        boolean addedGetterOrSetter = false;
        Expression.FunctionCall getGlobalPointerExpr = ElementsHelper.methodCall((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(BridJ.class)), (String)"getNativeLibrary", (Expression[])new Expression[]{ElementsHelper.expr((String)callerLibrary)}), (String)"getSymbolPointer", (Expression[])new Expression[]{ElementsHelper.expr((String)name)});
        String getterName = "get";
        String setterName = "set";
        if (isGlobal) {
            if (conv.pointerGetterName != null && conv.pointerSetterName != null) {
                getterName = conv.pointerGetterName;
                setterName = conv.pointerSetterName;
            } else {
                getGlobalPointerExpr = ElementsHelper.methodCall((Expression)getGlobalPointerExpr, (String)"as", (Expression[])new Expression[]{this.result.typeConverter.typeLiteral(javaType.clone())});
            }
        }
        if (conv.getFieldExpr != null) {
            Function getter = convDecl.clone();
            if (isGlobal) {
                getter.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.tryRethrow((Statement)new Statement.Return(ElementsHelper.cast((TypeRef)javaType.clone(), (Expression)ElementsHelper.methodCall((Expression)getGlobalPointerExpr, (String)getterName, (Expression[])new Expression[0]))))}));
            } else {
                getter.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return(conv.getFieldExpr)}));
            }
            out.add((Declaration)getter);
            addedGetterOrSetter = true;
        }
        if (!conv.readOnly && conv.setFieldExpr != null) {
            Function setter = convDecl.clone();
            setter.setValueType((TypeRef)ElementsHelper.typeRef((Identifier)holderName.clone()));
            setter.addArg(new Arg(name, javaType));
            if (isGlobal) {
                setter.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.tryRethrow((Statement)ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)getGlobalPointerExpr, (String)setterName, (Expression[])new Expression[]{ElementsHelper.varRef((String)name)})), new Statement.Return(ElementsHelper.thisRef())}))}));
            } else {
                setter.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)conv.setFieldExpr), new Statement.Return(ElementsHelper.thisRef())}));
            }
            out.add((Declaration)setter);
            addedGetterOrSetter = true;
            if (this.result.config.scalaStructSetters) {
                setter = new Function();
                setter.setType(Function.Type.JavaMethod);
                setter.setName(ElementsHelper.ident((String[])new String[]{name + "_$eq"}));
                setter.setValueType(javaType.clone());
                setter.addArg(new Arg(name, javaType.clone()));
                setter.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Final});
                setter.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)name, (Expression[])new Expression[]{ElementsHelper.varRef((String)name)})), new Statement.Return(ElementsHelper.varRef((String)name))}));
                out.add((Declaration)setter);
            }
        }
        if (!addedGetterOrSetter) {
            out.add((Declaration)new EmptyDeclaration(new String[]{"Failed to convert value " + name + " of type " + mutatedType}));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean convertVariablesDeclaration(VariablesDeclaration v, Signatures signatures, DeclarationsHolder out, int[] iChild, boolean isGlobal, Identifier holderName, Identifier callerLibraryClass, String callerLibrary) {
        boolean bl;
        try {
            TypeRef valueType = v.getValueType();
            for (Declarator vs : v.getDeclarators()) {
                if (vs.getDefaultValue() != null) continue;
                String name = vs.resolveName();
                if (name == null || name.length() == 0) {
                    name = "anonymous" + this.nextAnonymousFieldId++;
                }
                TypeRef mutatedType = valueType;
                if (!(vs instanceof Declarator.DirectDeclarator)) {
                    mutatedType = (TypeRef)vs.mutateTypeKeepingParent((Declarator.MutableByDeclarator)valueType);
                    vs = new Declarator.DirectDeclarator(vs.resolveName());
                }
                List<Declaration> vds = this.convertVariablesDeclarationToBridJ(name, mutatedType, iChild, vs.getBits(), isGlobal, holderName, callerLibraryClass, callerLibrary, new Element[]{v, vs});
                if (vs.getBits() > 0) {
                    for (Declaration vd : vds) {
                        vd.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Bits), ElementsHelper.expr((int)vs.getBits())));
                    }
                }
                for (Declaration vd : vds) {
                    if (vd instanceof Function && !signatures.addMethod((Function)vd)) continue;
                    vd.importDetails((Element)mutatedType, true);
                    vd.moveAllCommentsBefore();
                    if (!(mutatedType instanceof TypeRef.Primitive) && !this.result.config.noComments) {
                        vd.addToCommentBefore(new String[]{"C type : " + mutatedType});
                    }
                    out.addDeclaration(vd);
                }
            }
            bl = true;
            Object var18_20 = null;
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                if (!(e instanceof UnsupportedConversionException)) {
                    e.printStackTrace();
                }
                out.addDeclaration((Declaration)new EmptyDeclaration(new String[]{e.toString()}));
                bl2 = false;
                Object var18_21 = null;
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                iChild[0] = iChild[0] + 1;
                throw throwable;
            }
            iChild[0] = iChild[0] + 1;
            return bl2;
        }
        iChild[0] = iChild[0] + 1;
        return bl;
    }

    @Override
    protected void configureCallbackStruct(Struct callbackStruct) {
        callbackStruct.setType(Struct.Type.JavaClass);
        callbackStruct.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Abstract});
    }

    @Override
    protected Struct createFakePointerClass(Identifier fakePointer) {
        Struct ptClass = this.result.declarationsConverter.publicStaticClass(fakePointer, ElementsHelper.ident(TypedPointer.class, (Expression[])new Expression[0]), Struct.Type.JavaClass, null, new Identifier[0]);
        String addressVarName = "address";
        ptClass.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, fakePointer, null, new Arg[]{new Arg(addressVarName, ElementsHelper.typeRef(Long.TYPE))}).addModifiers(new Modifier[]{ModifierType.Public}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[]{ElementsHelper.varRef((String)addressVarName)}))})));
        ptClass.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, fakePointer, null, new Arg[]{new Arg(addressVarName, ElementsHelper.typeRef(Pointer.class))}).addModifiers(new Modifier[]{ModifierType.Public}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[]{ElementsHelper.varRef((String)addressVarName)}))})));
        return ptClass;
    }

    @Override
    protected void fillLibraryMapping(Result result, SourceFiles sourceFiles, DeclarationsHolder declarations, DeclarationsHolder implementations, String library, Identifier javaPackage, Expression nativeLibFieldExpr) throws IOException {
        super.fillLibraryMapping(result, sourceFiles, declarations, implementations, library, javaPackage, nativeLibFieldExpr);
        if (implementations instanceof ModifiableElement) {
            ModifiableElement minterf = (ModifiableElement)implementations;
            List<String> deps = result.config.dependencies.get(library);
            ImmutableMap namedArguments = null;
            if (deps != null) {
                ArrayList<Expression> depExprs = new ArrayList<Expression>();
                for (String dep : deps) {
                    depExprs.add(ElementsHelper.expr((String)dep));
                }
                namedArguments = ImmutableMap.of((Object)"dependencies", (Object)Expression.NewArray.newAnnotationArrayValue(depExprs));
            }
            minterf.addAnnotation(new Annotation(ElementsHelper.typeRef(Library.class), ElementsHelper.expr((String)library), namedArguments));
            minterf.addAnnotation(new Annotation(ElementsHelper.typeRef(Runtime.class), ElementsHelper.classLiteral(result.hasCPlusPlus ? CPPRuntime.class : CRuntime.class)));
        }
    }

    @Override
    public void generateLibraryFiles(SourceFiles sourceFiles, Result result, JNAeratorConfig config) throws IOException {
        for (String library : result.libraries) {
            Struct declarations;
            if (library == null) continue;
            Identifier javaPackage = result.javaPackageByLibrary.get(library);
            Identifier implementationsSimpleClassName = result.getLibraryClassSimpleName(library);
            Identifier declarationsSimpleClassName = result.getLibraryDeclarationsClassSimpleName(library);
            Identifier implementationsFullClassName = result.getLibraryClassFullName(library);
            Identifier declarationsFullClassName = result.getLibraryDeclarationsClassFullName(library);
            Struct implementations = new Struct();
            implementations.setType(Struct.Type.JavaClass);
            implementations.addToCommentBefore(new String[]{"Wrapper for library <b>" + library + "</b>", result.declarationsConverter.getFileCommentContent(result.config.libraryProjectSources.get(library), null)});
            implementations.addModifiers(new Modifier[]{ModifierType.Public});
            implementations.setTag(implementationsSimpleClassName);
            implementations.addParent(ElementsHelper.ident((Class)config.runtime.libraryClass, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)implementationsSimpleClassName))}));
            if (declarationsFullClassName != null) {
                implementations.addProtocol(declarationsFullClassName.clone());
            }
            if (!config.noStaticInit) {
                implementations.addDeclaration((Declaration)this.newStaticInit());
            }
            implementations.setResolvedJavaIdentifier(implementationsFullClassName);
            if (declarationsFullClassName != null) {
                declarations = new Struct();
                declarations.setType(Struct.Type.JavaInterface);
                declarations.addToCommentBefore(new String[]{"Interface for library <b>" + library + "</b>", result.declarationsConverter.getFileCommentContent(result.config.libraryProjectSources.get(library), null)});
                declarations.addModifiers(new Modifier[]{ModifierType.Public});
                declarations.setTag(declarationsSimpleClassName.clone());
                declarations.setResolvedJavaIdentifier(declarationsFullClassName);
            } else {
                declarations = implementations;
            }
            this.fillLibraryMapping(result, sourceFiles, (DeclarationsHolder)declarations, (DeclarationsHolder)implementations, library, javaPackage, ElementsHelper.varRef((String)"this"));
            this.writeLibraryInterface(result, sourceFiles, (DeclarationsHolder)declarations, library, javaPackage);
            if (declarations == implementations) continue;
            this.writeLibraryInterface(result, sourceFiles, (DeclarationsHolder)implementations, library, javaPackage);
        }
    }

    private Function newStaticInit() {
        Function f = new Function(Function.Type.StaticInit, null, null).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(BridJ.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"register", (Expression[])new Expression[0]))})).addModifiers(new Modifier[]{ModifierType.Static});
        return f;
    }

    private void addParentNamespaceAnnotation(ModifiableElement dest, Identifier parentNamespace) {
        if (parentNamespace != null) {
            dest.addAnnotation(new Annotation(ElementsHelper.typeRef(Namespace.class), ElementsHelper.expr((String)parentNamespace.toString())));
        }
    }
}

