/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.admin.visualstudio;

import com.ochafik.admin.visualstudio.Project;
import com.ochafik.io.ReadText;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solution {
    private static final boolean verbose = true;
    public File solutionFile;
    public Map<String, Project> idToProject;
    public Set<File> allFiles = new HashSet<File>(10000);
    static Pattern solutionIdPattern = Pattern.compile("Project\\(\"\\{[^}]+\\}\"\\) = \"([^\"]+)\", \"([^\"]+)\", [^{]+\\{([^}]+)\\}\".*?ProjectSection\\(ProjectDependencies\\)(.*?)EndProjectSection", 8);
    static Pattern projectDependencyPattern = Pattern.compile("\\{[^}]+\\} = \\{([^}]+)\\}");
    static Pattern projectConfigsForSolutionConfigPattern = Pattern.compile("^\\s*\\{([^}]+)\\}\\.([^\\.]+)\\.ActiveCfg\\s*=\\s*(.*)\\s*$");

    public Solution(File solutionFile) {
        this.solutionFile = solutionFile;
    }

    public void parse() throws Exception {
        if (this.idToProject == null) {
            this.idToProject = new LinkedHashMap<String, Project>();
            String solutionContent = ReadText.readText((File)this.solutionFile);
            File solutionPath = this.solutionFile.getParentFile();
            Matcher solutionIdMatcher = solutionIdPattern.matcher(solutionContent.replace('\n', ' '));
            while (solutionIdMatcher.find()) {
                Project p = new Project(this, Solution.relFile(solutionPath, solutionIdMatcher.group(2)), solutionIdMatcher.group(1), solutionIdMatcher.group(3));
                Matcher depM = projectDependencyPattern.matcher(solutionIdMatcher.group(4));
                while (depM.find()) {
                    p.depsIds.add(depM.group(1));
                }
                this.idToProject.put(p.id, p);
            }
            Matcher m = projectConfigsForSolutionConfigPattern.matcher(solutionContent);
            while (m.find()) {
                String id = m.group(1);
                String slnConfigName = m.group(2);
                String projConfigName = m.group(3);
                Project p = this.idToProject.get(id);
                if (p == null) continue;
                p.activeConfigurationNameBySolutionConfigurationName.put(slnConfigName, projConfigName);
            }
        }
    }

    public String getName() {
        return this.solutionFile == null ? null : this.solutionFile.getName().replaceAll("\\.[^.]+$", "");
    }

    public void parseProjects(final FileFilter fileFilter) throws Exception {
        this.parse();
        int nThreads = Runtime.getRuntime().availableProcessors() * 2;
        System.out.println("Parsing Solution: " + this.solutionFile.getName() + " (" + nThreads + " threads)");
        final Semaphore semaphore = new Semaphore(0);
        final LinkedList<Project> projects = new LinkedList<Project>(this.idToProject.values());
        int i = nThreads;
        while (i-- != 0) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Worker
            extends Thread {
                Worker() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    block10: while (true) {
                        Set<File> set;
                        try {
                            while (true) {
                                Project project = null;
                                set = projects;
                                synchronized (set) {
                                    if (projects.isEmpty()) {
                                        break block10;
                                    }
                                    project = (Project)projects.removeLast();
                                }
                                set = System.out;
                                synchronized (set) {
                                    System.out.println("Parsing Project: " + project.name);
                                }
                                project.parse(fileFilter, false, Solution.this);
                                set = Solution.this.allFiles;
                                synchronized (set) {
                                    Solution.this.allFiles.addAll(project.files);
                                }
                            }
                        }
                        catch (Exception ex) {
                            set = System.err;
                            synchronized (set) {
                                ex.printStackTrace(System.err);
                            }
                            continue;
                        }
                        break;
                    }
                    semaphore.release();
                }
            }
            new Worker().start();
        }
        semaphore.acquire(nThreads);
    }

    static File relFile(File base, String relPath) {
        relPath = relPath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return new File(base, relPath);
    }

    public Collection<Project> getProjects() {
        return this.idToProject.values();
    }
}

